/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.styles;

import inform.agent.schemes.converters.odg.OdgParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgMasterStyles {
    LayerSet layerSet;

    public OdgMasterStyles(Element element) {
        List<Element> listPage = OdgParser.getChildElements(element);
        for (Element page : listPage) {
            if (!page.getTagName().equals("draw:layer-set")) continue;
            this.layerSet = new LayerSet(page);
        }
    }

    public LayerSet.Layer getLayerSet(String name) {
        return this.layerSet.layerHashMap.get(name);
    }

    public int countLayers() {
        return this.layerSet.layerHashMap.size();
    }

    public ArrayList<LayerSet.Layer> getLayersMap() {
        Collection<LayerSet.Layer> layerCollections = this.layerSet.layerHashMap.values();
        return new ArrayList<LayerSet.Layer>(layerCollections);
    }

    public static class LayerSet {
        LinkedHashMap<String, Layer> layerHashMap = new LinkedHashMap();

        public LayerSet(Element element) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                Layer layer = new Layer();
                layer.drawName = el.getAttribute("draw:name");
                if (el.hasAttribute("draw:display")) {
                    layer.drawDisplay = el.getAttribute("draw:display");
                }
                if (el.hasAttribute("draw:protected")) {
                    layer.drawProtected = Boolean.parseBoolean(el.getAttribute("draw:protected"));
                }
                if (el.hasChildNodes()) {
                    NodeList list = el.getChildNodes();
                    for (int j = 0; j < list.getLength(); ++j) {
                        Element ele = (Element)list.item(j);
                        if (!ele.getTagName().equals("svg:desc")) continue;
                        layer.svgDesc = ele.getTextContent();
                    }
                }
                this.layerHashMap.put(layer.drawName, layer);
            }
        }

        public static class Layer {
            public String drawName;
            public String drawDisplay = "always";
            public String svgDesc = "";
            public boolean drawProtected = false;
        }
    }
}

