/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.odg.styles;

import inform.agent.schemes.converters.odg.content.OdgOfficeStyles;
import inform.agent.schemes.converters.odg.styles.OdgAutomaticStyles;
import inform.agent.schemes.converters.odg.styles.OdgMasterStyles;
import inform.agent.schemes.converters.odg.styles.OdgOfficeFontFaceDecls;
import inform.agent.schemes.converters.odg.styles.OdgStyles;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdgStylesParser {
    private OdgOfficeFontFaceDecls officeFontFaceDecls;
    private OdgOfficeStyles officeStyles;
    private OdgAutomaticStyles officeAutomaticStyles;
    private OdgMasterStyles officeMasterStyles;

    public OdgStylesParser(Document documentStyles) {
        Element el = (Element)((Object)documentStyles.getDocumentElement().getChildNodes());
        NodeList stylesList = el.getChildNodes();
        block12: for (int i = 0; i < stylesList.getLength(); ++i) {
            Node node = stylesList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            switch (element.getNodeName()) {
                case "office:font-face-decls": {
                    this.officeFontFaceDecls = new OdgOfficeFontFaceDecls(element);
                    continue block12;
                }
                case "office:styles": {
                    this.officeStyles = new OdgOfficeStyles(element);
                    continue block12;
                }
                case "office:automatic-styles": {
                    this.officeAutomaticStyles = new OdgAutomaticStyles(element);
                    continue block12;
                }
                case "office:master-styles": {
                    this.officeMasterStyles = new OdgMasterStyles(element);
                    continue block12;
                }
            }
        }
    }

    public OdgStyles getStyles() {
        OdgStyles styles = new OdgStyles();
        styles.setOfficeAutomaticStyles(this.officeAutomaticStyles);
        styles.setOfficeStyles(this.officeStyles);
        styles.setOfficeMasterStyles(this.officeMasterStyles);
        styles.setOfficeFontFaceDecls(this.officeFontFaceDecls);
        return styles;
    }
}

