/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import java.util.ArrayList;
import java.util.List;

public class VsdxConnection {
    public List<VsdxConnectionRow> rows = new ArrayList<VsdxConnectionRow>();

    public void addRow(VsdxConnectionRow connection) {
        this.rows.add(connection);
    }

    public VsdxConnectionRow findRowById(String id) {
        if (id != null && this.rows != null) {
            for (VsdxConnectionRow r : this.rows) {
                if (!id.equals(r.ID)) continue;
                return r;
            }
        }
        return null;
    }

    public VsdxConnectionRow findRowByName(String name) {
        if (name != null && this.rows != null) {
            for (VsdxConnectionRow r : this.rows) {
                if (!name.equals(r.Name)) continue;
                return r;
            }
        }
        return null;
    }

    public int getRowIndexByName(String name) {
        if (name != null && this.rows != null) {
            int cnt = this.rows.size();
            for (int i = 0; i < cnt; ++i) {
                VsdxConnectionRow r = this.rows.get(i);
                if (r == null || !name.equals(r.Name)) continue;
                return i;
            }
        }
        return -1;
    }

    public VsdxConnectionRow get(int index) {
        if (index < 0 || this.rows == null || index >= this.rows.size()) {
            return null;
        }
        return this.rows.get(index);
    }

    void applyProperties(VsdxConnection connection) {
        if (connection == null || connection.rows == null) {
            return;
        }
        if (this.rows == null) {
            this.rows = new ArrayList<VsdxConnectionRow>();
        }
        boolean isEmpty = this.rows.isEmpty();
        for (VsdxConnectionRow connectionRow : connection.rows) {
            VsdxConnectionRow row = null;
            if (!isEmpty) {
                if (connectionRow.ID != null && !connectionRow.ID.isEmpty()) {
                    row = this.findRowById(connectionRow.ID);
                } else if (connectionRow.Name != null && !connectionRow.Name.isEmpty()) {
                    row = this.findRowByName(connectionRow.Name);
                }
            }
            if (row == null) {
                row = new VsdxConnectionRow();
                row.ID = connectionRow.ID;
                row.Name = connectionRow.Name;
                this.rows.add(row);
            }
            if (connectionRow.Del != null) {
                row.Del = connectionRow.Del;
            }
            if (connectionRow.Type != null) {
                row.Type = connectionRow.Type;
            }
            if (connectionRow.X != null) {
                row.X = connectionRow.X;
            }
            if (connectionRow.Y == null) continue;
            row.Y = connectionRow.Y;
        }
    }

    public boolean isEmpty() {
        return this.rows == null || this.rows.isEmpty();
    }

    public int size() {
        return this.rows == null ? 0 : this.rows.size();
    }

    public static class VsdxConnectionRow {
        public String ID = "";
        public String Name = "";
        public String Del;
        public String X;
        public String Y;
        public String Type;
    }
}

