/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxGeometry;
import inform.agent.schemes.converters.vsdx.VsdxGeometryRow;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxRowsSectionParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VsdxGeometryParser
extends VsdxRowsSectionParser {
    VsdxGeometryParser(VsdxParser vsdxParser, Element geometryNode) {
        super(vsdxParser, geometryNode);
    }

    void parse(VsdxShape shape) {
        Element geometrySection = this.getSectionNode();
        NodeList rows = geometrySection.getChildNodes();
        String geometryIX = geometrySection.getAttribute("IX");
        VsdxGeometry geometry = shape.findGeometryById(geometryIX);
        if (geometry == null) {
            geometry = new VsdxGeometry(shape);
            geometry.ID = geometryIX;
            shape.geometries.add(geometry);
        }
        for (int i = 0; i < rows.getLength(); ++i) {
            if (rows.item(i).getNodeType() != 1) continue;
            Element item = (Element)rows.item(i);
            if (item.getTagName().equals("Cell")) {
                String cellValue = item.getAttribute("V");
                switch (item.getAttribute("N")) {
                    case "NoFill": {
                        geometry.NoFill = cellValue;
                        break;
                    }
                    case "NoLine": {
                        geometry.NoLine = cellValue;
                        break;
                    }
                    case "NoShow": {
                        geometry.NoShow = cellValue;
                    }
                }
                continue;
            }
            String rowId = item.getAttribute("IX");
            VsdxGeometryRow row = geometry.findRowById(rowId);
            if (row == null) {
                row = new VsdxGeometryRow();
                row.ID = rowId;
                if (geometry.rows == null) {
                    geometry.rows = new ArrayList<VsdxGeometryRow>();
                }
                geometry.rows.add(row);
            }
            row.Del = item.getAttribute("Del");
            row.T = item.getAttribute("T");
            NodeList cells = item.getChildNodes();
            block29: for (int j = 0; j < cells.getLength(); ++j) {
                if (cells.item(j).getNodeType() != 1) continue;
                Element cell = (Element)cells.item(j);
                String cellValue = cell.getAttribute("V");
                switch (cell.getAttribute("N")) {
                    case "X": {
                        row.X = cellValue;
                        continue block29;
                    }
                    case "Y": {
                        row.Y = cellValue;
                        continue block29;
                    }
                    case "A": {
                        row.A = cellValue;
                        String s = VsdxUtils.validateFunction(cell.getAttribute("F"));
                        if (s == null || s.isEmpty() || "Inh".equals(s)) continue block29;
                        row.FunctionA = s;
                        continue block29;
                    }
                    case "B": {
                        row.B = cellValue;
                        continue block29;
                    }
                    case "C": {
                        row.C = cellValue;
                        continue block29;
                    }
                    case "D": {
                        row.D = cellValue;
                        continue block29;
                    }
                    case "E": {
                        row.E = cellValue;
                        String s = VsdxUtils.validateFunction(cell.getAttribute("F"));
                        if (s == null || s.isEmpty() || "Inh".equals(s)) continue block29;
                        row.FunctionE = s;
                    }
                }
            }
        }
    }
}

