/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.adt.InformException;
import inform.agent.Core;
import inform.agent.schemes.SchemeUtils;
import inform.agent.schemes.VisioOldFormatsConverter;
import inform.agent.schemes.converters.vsdx.VsdxAction;
import inform.agent.schemes.converters.vsdx.VsdxCharacterParser;
import inform.agent.schemes.converters.vsdx.VsdxChart;
import inform.agent.schemes.converters.vsdx.VsdxConnectionParser;
import inform.agent.schemes.converters.vsdx.VsdxField;
import inform.agent.schemes.converters.vsdx.VsdxFieldParser;
import inform.agent.schemes.converters.vsdx.VsdxForeignData;
import inform.agent.schemes.converters.vsdx.VsdxGeometry;
import inform.agent.schemes.converters.vsdx.VsdxGeometryParser;
import inform.agent.schemes.converters.vsdx.VsdxGeometryRow;
import inform.agent.schemes.converters.vsdx.VsdxGradientStopsParser;
import inform.agent.schemes.converters.vsdx.VsdxMasterParser;
import inform.agent.schemes.converters.vsdx.VsdxParagraphParser;
import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxProperty;
import inform.agent.schemes.converters.vsdx.VsdxPropertyParser;
import inform.agent.schemes.converters.vsdx.VsdxRowsSectionParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.VsdxShapes;
import inform.agent.schemes.converters.vsdx.VsdxTabsParser;
import inform.agent.schemes.converters.vsdx.VsdxTextParser;
import inform.agent.schemes.converters.vsdx.VsdxUserSectionParser;
import inform.agent.schemes.converters.vsdx.VsdxUtils;
import inform.agent.schemes.converters.vsdx.evaluator.VsdxExpressionEvaluator;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VsdxShapeParser {
    public static final int ELLIPSE_POINTS_COUNT = 60;
    private final VsdxParser vsdxParser;
    private final Element shapeNode;
    private final List<Element> geometryNodes;
    private final VsdxMasterParser masterParser;
    private final List<Element> connectionNodes;
    private final List<Element> fieldNodes;
    private final List<Element> characterNodes;
    private final List<Element> paragraphNodes;
    private final List<Element> tabsNodes;
    private final List<Element> fillGradientNodes;
    private final Element foreignNode;
    private final List<Element> userNodes;
    private final List<Element> propertyNodes;
    private final List<Element> actionsNodes;
    private final Map<String, String> rels;
    private String foreignId;

    VsdxShapeParser(VsdxParser vsdxParser, Element shapeNode, Map<String, String> rels) {
        List<Element> relList;
        this.vsdxParser = vsdxParser;
        this.shapeNode = shapeNode;
        this.rels = rels;
        this.geometryNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "Geometry");
        this.masterParser = shapeNode == null ? null : vsdxParser.getMaster(shapeNode.getAttribute("Master"));
        this.connectionNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "Connection");
        this.fieldNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "Field");
        this.characterNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "Character");
        this.paragraphNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "Paragraph");
        this.tabsNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "Tabs");
        this.fillGradientNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "FillGradient");
        this.propertyNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "Property");
        this.actionsNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "Actions");
        List<Element> foreignNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "ForeignData", null, null);
        Element element = this.foreignNode = foreignNodes == null || foreignNodes.isEmpty() ? null : foreignNodes.get(0);
        if (this.foreignNode != null && (relList = VsdxParser.getElementsByLocalName(this.foreignNode, "Rel")) != null && !relList.isEmpty()) {
            Element relNode = relList.get(0);
            assert (relNode != null);
            this.foreignId = relNode.getAttribute("r:id");
        }
        this.userNodes = shapeNode == null ? null : vsdxParser.getElements(shapeNode, "Section", "N", "User");
    }

    public String getAttribute(String name) {
        assert (this.shapeNode != null);
        return this.shapeNode.getAttribute(name);
    }

    public String getCellValue(String name) {
        assert (this.shapeNode != null);
        String cellValue = this.vsdxParser.getCellValue(this.shapeNode, name);
        if (cellValue != null && !cellValue.isEmpty() && !VsdxUtils.isThemed(cellValue)) {
            return cellValue;
        }
        return null;
    }

    public String getCellFunction(String name) {
        assert (this.shapeNode != null);
        return this.vsdxParser.getCellFunction(this.shapeNode, name);
    }

    private VsdxGeometryParser getGeometryParser(int index) {
        return this.geometryNodes == null || index < 0 || index >= this.geometryNodes.size() ? null : new VsdxGeometryParser(this.vsdxParser, this.geometryNodes.get(index));
    }

    private VsdxConnectionParser getConnectionParser() {
        if (this.connectionNodes == null || this.connectionNodes.isEmpty()) {
            return null;
        }
        assert (this.connectionNodes.size() == 1);
        return new VsdxConnectionParser(this.vsdxParser, this.connectionNodes.get(0));
    }

    private VsdxFieldParser getFieldParser() {
        if (this.fieldNodes == null || this.fieldNodes.isEmpty()) {
            return null;
        }
        assert (this.fieldNodes.size() == 1);
        return new VsdxFieldParser(this.vsdxParser, this.fieldNodes.get(0));
    }

    private VsdxCharacterParser getCharacterParser() {
        if (this.characterNodes == null || this.characterNodes.isEmpty()) {
            return null;
        }
        assert (this.characterNodes.size() == 1);
        return new VsdxCharacterParser(this.vsdxParser, this.characterNodes.get(0));
    }

    private VsdxParagraphParser getParagraphParser() {
        if (this.paragraphNodes == null || this.paragraphNodes.isEmpty()) {
            return null;
        }
        assert (this.paragraphNodes.size() == 1);
        return new VsdxParagraphParser(this.vsdxParser, this.paragraphNodes.get(0));
    }

    private VsdxTabsParser getTabsParser() {
        if (this.tabsNodes == null || this.tabsNodes.isEmpty()) {
            return null;
        }
        assert (this.tabsNodes.size() == 1);
        return new VsdxTabsParser(this.vsdxParser, this.tabsNodes.get(0));
    }

    private VsdxGradientStopsParser getFillGradientParser() {
        if (this.fillGradientNodes == null || this.fillGradientNodes.isEmpty()) {
            return null;
        }
        assert (this.fillGradientNodes.size() == 1);
        return new VsdxGradientStopsParser(this.vsdxParser, this.fillGradientNodes.get(0));
    }

    private VsdxUserSectionParser getUserSectionParser() {
        if (this.userNodes == null || this.userNodes.isEmpty()) {
            return null;
        }
        assert (this.userNodes.size() == 1);
        return new VsdxUserSectionParser(this.vsdxParser, this.userNodes.get(0));
    }

    private VsdxPropertyParser getPropertyParser() {
        if (this.propertyNodes == null || this.propertyNodes.isEmpty()) {
            return null;
        }
        return new VsdxPropertyParser(this.vsdxParser, this.propertyNodes.get(0));
    }

    private VsdxRowsSectionParser getActionsParser() {
        if (this.actionsNodes == null || this.actionsNodes.isEmpty()) {
            return null;
        }
        return new VsdxRowsSectionParser(this.vsdxParser, this.actionsNodes.get(0));
    }

    public VsdxMasterParser getMasterParser() {
        return this.masterParser;
    }

    public void parseShape(VsdxShape shape, boolean isMaster, VsdxMasterParser masterParser) {
        List<Element> shapesNodes;
        VsdxPropertyParser propertySectionParser;
        VsdxUserSectionParser userSectionParser;
        VsdxTabsParser tabsParser;
        VsdxParagraphParser paragraphParser;
        VsdxCharacterParser characterParser;
        List<VsdxField> fields;
        VsdxGradientStopsParser fillGradientStopsParser;
        int cntg;
        String attrValue;
        Object attribute;
        assert (shape != null && this.shapeNode != null);
        if (this.shapeNode.hasAttribute("ID")) {
            shape.ID = this.shapeNode.getAttribute("ID");
        }
        NamedNodeMap attributesMap = this.shapeNode.getAttributes();
        VsdxShape lineStyleShape = null;
        VsdxShape fillStyleShape = null;
        VsdxShape textStyleShape = null;
        block218: for (int i = 0; i < attributesMap.getLength(); ++i) {
            attribute = attributesMap.item(i);
            attrValue = attribute.getNodeValue();
            switch (attribute.getLocalName()) {
                case "LineStyle": {
                    lineStyleShape = new VsdxShape(shape.vsdx, null);
                    lineStyleShape.LineStyle = attrValue;
                    lineStyleShape.applyStyles(true);
                    continue block218;
                }
                case "FillStyle": {
                    fillStyleShape = new VsdxShape(shape.vsdx, null);
                    fillStyleShape.FillStyle = attrValue;
                    fillStyleShape.applyStyles(true);
                    continue block218;
                }
                case "TextStyle": {
                    textStyleShape = new VsdxShape(shape.vsdx, null);
                    textStyleShape.TextStyle = attrValue;
                    textStyleShape.applyStyles(true);
                }
            }
        }
        if (this.shapeNode.hasAttribute("MasterShape")) {
            shape.MasterShape = this.shapeNode.getAttribute("MasterShape");
        }
        if (masterParser != null) {
            String masterID;
            shape.Master = masterID = this.shapeNode.getAttribute("Master");
            assert (masterID != null && !masterID.isEmpty());
            shape.master = this.vsdxParser.parseMasterShapes(shape.vsdx, masterID, masterParser);
            if (shape.master != null) {
                VsdxShape masterShape = null;
                if (shape.MasterShape != null && !shape.MasterShape.isEmpty()) {
                    masterShape = shape.master.shapes.get(shape.MasterShape);
                    assert (masterShape != null);
                } else if (shape.master.shapes != null && shape.master.shapes.size() == 1) {
                    masterShape = shape.master.shapes.get(0);
                }
                if (masterShape != null) {
                    if (masterParser.hasMasterAttribute("BaseID")) {
                        masterShape.BaseID = masterParser.getMasterAttribute("BaseID");
                    }
                    if (masterParser.hasMasterAttribute("UniqueID")) {
                        masterShape.UniqueID = masterParser.getMasterAttribute("UniqueID");
                    }
                    shape.applyMaster(masterShape);
                }
            }
        } else if (this.shapeNode.hasAttribute("MasterShape")) {
            VsdxShape masterShape = shape.findMasterShape(this.shapeNode.getAttribute("MasterShape"), true);
            shape.applyMaster(masterShape);
        }
        if (lineStyleShape != null) {
            shape.applyProperties(lineStyleShape);
        }
        if (fillStyleShape != null) {
            shape.applyProperties(fillStyleShape);
        }
        if (textStyleShape != null) {
            shape.Characters = null;
            shape.Paragraphs = null;
            shape.applyProperties(textStyleShape);
        }
        block219: for (int i = 0; i < attributesMap.getLength(); ++i) {
            attribute = attributesMap.item(i);
            attrValue = attribute.getNodeValue();
            switch (attribute.getLocalName()) {
                case "Del": {
                    shape.Del = attrValue;
                    continue block219;
                }
                case "Type": {
                    shape.Type = attrValue;
                    continue block219;
                }
                case "Name": {
                    shape.Name = attrValue;
                    continue block219;
                }
                case "LineStyle": {
                    shape.LineStyle = attrValue;
                    if (!shape.onlyMaster) continue block219;
                    shape.onlyMaster = false;
                    continue block219;
                }
                case "FillStyle": {
                    shape.FillStyle = attrValue;
                    if (!shape.onlyMaster) continue block219;
                    shape.onlyMaster = false;
                    continue block219;
                }
                case "TextStyle": {
                    shape.TextStyle = attrValue;
                    if (!shape.onlyMaster) continue block219;
                    shape.onlyMaster = false;
                }
            }
        }
        List<Element> shapeCells = VsdxParser.getElementsByLocalName(this.shapeNode, "Cell");
        for (Element cell : shapeCells) {
            if (cell == null) continue;
            String cellValue = cell.getAttribute("V");
            if (cellValue.isEmpty()) {
                cellValue = null;
            }
            String cellFomula = null;
            switch (cell.getAttribute("N")) {
                case "Width": {
                    shape.Width = cellValue;
                    break;
                }
                case "Height": {
                    shape.Height = cellValue;
                    break;
                }
                case "PinX": {
                    shape.PinX = cellValue;
                    cellFomula = cell.getAttribute("F");
                    shape.FPinX = cellFomula == null || cellFomula.isEmpty() ? null : cellFomula;
                    break;
                }
                case "PinY": {
                    shape.PinY = cellValue;
                    cellFomula = cell.getAttribute("F");
                    shape.FPinY = cellFomula == null || cellFomula.isEmpty() ? null : cellFomula;
                    break;
                }
                case "LocPinX": {
                    shape.LocPinX = cellValue;
                    break;
                }
                case "LocPinY": {
                    shape.LocPinY = cellValue;
                    break;
                }
                case "Angle": {
                    shape.Angle = cellValue;
                    break;
                }
                case "LayerMember": {
                    shape.LayerMember = cellValue;
                    break;
                }
                case "QuickStyleLineColor": {
                    shape.QuickStyleLineColor = cellValue;
                    break;
                }
                case "QuickStyleFillColor": {
                    shape.QuickStyleFillColor = cellValue;
                    break;
                }
                case "QuickStyleShadowColor": {
                    shape.QuickStyleShadowColor = cellValue;
                    break;
                }
                case "QuickStyleFontColor": {
                    shape.QuickStyleFontColor = cellValue;
                    break;
                }
                case "QuickStyleLineMatrix": {
                    shape.QuickStyleLineMatrix = cellValue;
                    break;
                }
                case "QuickStyleFillMatrix": {
                    shape.QuickStyleFillMatrix = cellValue;
                    break;
                }
                case "QuickStyleEffectsMatrix": {
                    shape.QuickStyleEffectsMatrix = cellValue;
                    break;
                }
                case "QuickStyleFontMatrix": {
                    shape.QuickStyleFontMatrix = cellValue;
                    break;
                }
                case "QuickStyleVariation": {
                    shape.QuickStyleVariation = cellValue;
                    break;
                }
                case "QuickStyleType": {
                    shape.QuickStyleType = cellValue;
                    break;
                }
                case "ShapeRouteStyle": {
                    shape.ShapeRouteStyle = cellValue;
                    break;
                }
                case "ConLineRouteExt": {
                    shape.ConLineRouteExt = cellValue;
                    break;
                }
                case "ConFixedCode": {
                    shape.ConFixedCode = cellValue;
                    break;
                }
                case "LineWeight": {
                    shape.LineWeight = cellValue;
                    break;
                }
                case "LineColor": {
                    shape.LineColor = cellValue;
                    shape.onlyMaster = false;
                    if (shape.LineColor == null) break;
                    shape.protectAttr("LineColor");
                    break;
                }
                case "FillBkgnd": {
                    shape.FillBkgnd = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "FillForegnd": {
                    shape.FillForegnd = cellValue;
                    shape.onlyMaster = false;
                    if (shape.FillForegnd == null) break;
                    shape.protectAttr("FillForegnd");
                    break;
                }
                case "LinePattern": {
                    shape.LinePattern = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "LineCap": {
                    shape.LineCap = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "FillPattern": {
                    shape.FillPattern = cellValue;
                    shape.onlyMaster = false;
                    if (shape.FillPattern == null) break;
                    shape.protectAttr("FillPattern");
                    break;
                }
                case "DisplayMode": {
                    shape.DisplayMode = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "FlipX": {
                    shape.FlipX = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "FlipY": {
                    shape.FlipY = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "BeginX": {
                    shape.BeginX = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "BeginY": {
                    shape.BeginY = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "EndX": {
                    shape.EndX = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "EndY": {
                    shape.EndY = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "ImgWidth": {
                    shape.ImgWidth = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "ImgHeight": {
                    shape.ImgHeight = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "ImgOffsetX": {
                    shape.ImgOffsetX = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "ImgOffsetY": {
                    shape.ImgOffsetY = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "Transparency": {
                    shape.Transparency = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "BeginArrow": {
                    shape.BeginArrow = cellValue;
                    shape.onlyMaster = false;
                    if (!"254".equals(shape.BeginArrow)) break;
                    String func = cell.getAttribute("F");
                    shape.BeginArrow = func.substring(func.indexOf(40) + 2, func.indexOf(41) - 1);
                    break;
                }
                case "EndArrow": {
                    shape.EndArrow = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "BeginArrowSize": {
                    shape.BeginArrowSize = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "EndArrowSize": {
                    shape.EndArrowSize = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "Rounding": {
                    shape.Rounding = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "FillGradientEnabled": {
                    shape.FillGradientEnabled = cellValue;
                    shape.onlyMaster = false;
                    if (shape.FillGradientEnabled == null) break;
                    shape.protectAttr("FillGradientEnabled");
                    break;
                }
                case "FillGradientDir": {
                    shape.FillGradientDir = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "FillGradientAngle": {
                    shape.FillGradientAngle = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "LineColorTrans": {
                    shape.LineColorTrans = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "FillForegndTrans": {
                    shape.FillForegndTrans = cellValue;
                    shape.onlyMaster = false;
                    break;
                }
                case "HideText": {
                    shape.HideText = cellValue;
                    break;
                }
                case "ObjType": {
                    shape.ObjType = cellValue;
                    break;
                }
                case "TxtPinX": {
                    shape.TxtPinX = cellValue;
                    break;
                }
                case "TxtPinY": {
                    shape.TxtPinY = cellValue;
                    break;
                }
                case "TxtWidth": {
                    shape.TxtWidth = cellValue;
                    break;
                }
                case "TxtHeight": {
                    shape.TxtHeight = cellValue;
                    break;
                }
                case "TxtLocPinX": {
                    shape.TxtLocPinX = cellValue;
                    break;
                }
                case "TxtLocPinY": {
                    shape.TxtLocPinY = cellValue;
                    break;
                }
                case "TxtAngle": {
                    shape.TxtAngle = cellValue;
                    break;
                }
                case "TextBkgnd": {
                    shape.TextBkgnd = cellValue;
                    break;
                }
                case "LeftMargin": {
                    shape.LeftMargin = cellValue;
                    break;
                }
                case "RightMargin": {
                    shape.RightMargin = cellValue;
                    break;
                }
                case "TopMargin": {
                    shape.TopMargin = cellValue;
                    break;
                }
                case "BottomMargin": {
                    shape.BottomMargin = cellValue;
                    break;
                }
                case "VerticalAlign": {
                    shape.VerticalAlign = cellValue;
                    break;
                }
                case "DefaultTabStop": {
                    shape.DefaultTabStop = cellValue;
                    break;
                }
                case "TextDirection": {
                    shape.TextDirection = cellValue;
                    break;
                }
                case "TextBkgndTrans": {
                    shape.TextBkgndTrans = cellValue;
                    break;
                }
                case "Relationships": {
                    ArrayList<String> params = new ArrayList<String>();
                    int startIdx = 0;
                    while ((startIdx = this.parseRelationships(params, cell.getAttribute("F"), startIdx)) > 0) {
                        String[] arr = params.toArray(new String[0]);
                        params.clear();
                        if (arr.length < 1) continue;
                        if (shape.Relationships == null) {
                            shape.Relationships = new ArrayList<String[]>();
                        }
                        this.correctRelationshipsID(arr);
                        shape.Relationships.add(arr);
                    }
                    break;
                }
                case "ShdwForegnd": {
                    shape.ShdwForegnd = cellValue;
                    break;
                }
                case "ShdwForegndTrans": {
                    shape.ShdwForegndTrans = cellValue;
                    break;
                }
                case "ShdwPattern": {
                    shape.ShdwPattern = cellValue;
                    break;
                }
                case "ShapeShdwOffsetX": {
                    shape.ShapeShdwOffsetX = cellValue;
                    break;
                }
                case "ShapeShdwOffsetY": {
                    shape.ShapeShdwOffsetY = cellValue;
                    break;
                }
                case "ShapeShdwType": {
                    shape.ShapeShdwType = cellValue;
                    break;
                }
                case "ShapeShdwObliqueAngle": {
                    shape.ShapeShdwObliqueAngle = cellValue;
                    break;
                }
                case "ShapeShdwScaleFactor": {
                    shape.ShapeShdwScaleFactor = cellValue;
                    break;
                }
                case "ShapeShdwBlur": {
                    shape.ShapeShdwBlur = cellValue;
                    break;
                }
                case "ShapeShdwShow": {
                    shape.ShapeShdwShow = cellValue;
                    break;
                }
                case "ReflectionTrans": {
                    shape.ReflectionTrans = cellValue;
                    break;
                }
                case "ReflectionBlur": {
                    shape.ReflectionBlur = cellValue;
                    break;
                }
                case "ReflectionSize": {
                    shape.ReflectionSize = cellValue;
                    break;
                }
                case "ReflectionDist": {
                    shape.ReflectionDist = cellValue;
                    break;
                }
                case "ThemeIndex": {
                    shape.ThemeIndex = cellValue;
                    break;
                }
                case "ColorSchemeIndex": {
                    shape.ColorSchemeIndex = cellValue;
                    break;
                }
                case "EffectSchemeIndex": {
                    shape.EffectSchemeIndex = cellValue;
                    break;
                }
                case "ConnectorSchemeIndex": {
                    shape.ConnectorSchemeIndex = cellValue;
                    break;
                }
                case "FontSchemeIndex": {
                    shape.FontSchemeIndex = cellValue;
                    break;
                }
                case "GlowColor": {
                    shape.GlowColor = cellValue;
                    break;
                }
                case "GlowColorTrans": {
                    shape.GlowColorTrans = cellValue;
                    break;
                }
                case "GlowSize": {
                    shape.GlowSize = cellValue;
                    break;
                }
                case "SoftEdgesSize": {
                    shape.SoftEdgesSize = cellValue;
                }
            }
        }
        if (!this.vsdxParser.getElements(this.shapeNode, "Section", "N", "Control").isEmpty()) {
            shape.hasControlSection = true;
        }
        if (shape.geometries == null) {
            shape.geometries = new ArrayList<VsdxGeometry>();
        }
        int n = cntg = this.geometryNodes == null ? 0 : this.geometryNodes.size();
        if (cntg > 0 && shape.onlyMaster) {
            shape.onlyMaster = false;
        }
        for (int g = 0; g < cntg; ++g) {
            VsdxGeometryParser geometryParser = this.getGeometryParser(g);
            if (geometryParser == null) continue;
            geometryParser.parse(shape);
        }
        VsdxConnectionParser connectionParser = this.getConnectionParser();
        if (connectionParser != null) {
            shape.connection = connectionParser.parse(shape);
            if (shape.onlyMaster) {
                shape.onlyMaster = false;
            }
        }
        if ((fillGradientStopsParser = this.getFillGradientParser()) != null) {
            shape.fillGradient = fillGradientStopsParser.parse(shape);
            if (shape.onlyMaster) {
                shape.onlyMaster = false;
            }
        }
        List<Element> textNodes = VsdxParser.getElementsByLocalName(this.shapeNode, "Text");
        VsdxFieldParser fieldParser = this.getFieldParser();
        if (fieldParser != null && fieldParser.countRows() > 0 && (fields = fieldParser.parse()) != null) {
            if (shape.Fields == null) {
                shape.Fields = new ArrayList<VsdxField>(fields);
            } else {
                for (VsdxField f : fields) {
                    VsdxField field = shape.findFieldById(f.getIX());
                    if (field == null) {
                        field = new VsdxField(f.getIX());
                        shape.Fields.add(field);
                    }
                    field.applyProperties(f);
                }
            }
        }
        if (!textNodes.isEmpty()) {
            assert (textNodes.size() == 1);
            VsdxTextParser parser = new VsdxTextParser(this.vsdxParser, textNodes.get(0));
            parser.parse(shape);
        }
        if (shape.TextInfo != null) {
            shape.Text = SchemeUtils.correctText(shape.getTextContent());
        }
        if ((characterParser = this.getCharacterParser()) != null && characterParser.countRows() > 0) {
            characterParser.parse(shape);
        }
        if ((paragraphParser = this.getParagraphParser()) != null && paragraphParser.countRows() > 0) {
            paragraphParser.parse(shape);
        }
        if ((tabsParser = this.getTabsParser()) != null && tabsParser.countRows() > 0) {
            tabsParser.parse(shape);
        }
        if ((userSectionParser = this.getUserSectionParser()) != null) {
            userSectionParser.parse(shape);
            if (shape.onlyMaster) {
                shape.onlyMaster = false;
            }
        }
        if ((propertySectionParser = this.getPropertyParser()) != null) {
            propertySectionParser.parse(shape);
        }
        if (this.actionsNodes != null && !this.actionsNodes.isEmpty()) {
            Element actionSection = this.actionsNodes.get(0);
            NodeList rows = actionSection.getChildNodes();
            boolean empty = shape.Actions.isEmpty();
            for (int i = 0; i < rows.getLength(); ++i) {
                VsdxAction action;
                Node item = rows.item(i);
                if (!(item instanceof Element)) continue;
                Element row = (Element)item;
                VsdxAction a = new VsdxAction(row);
                VsdxAction vsdxAction = action = empty ? null : shape.findActionByName(a.getName());
                if (action == null) {
                    action = a;
                    shape.Actions.add(a);
                    continue;
                }
                action.applyProperties(a);
            }
        }
        for (VsdxAction action : shape.Actions) {
            if (action.doesAffectProperties() || !action.isEnabled() || !action.isVisible() || action.isGroup()) continue;
            VsdxProperty actionProperty = new VsdxProperty(action, shape.UserVars);
            VsdxProperty p = shape.findPropertyByName(actionProperty.getName());
            if (p == null) {
                shape.Properties.add(actionProperty);
                continue;
            }
            p.applyProperties(actionProperty);
        }
        if (this.rels != null && this.foreignNode != null && this.foreignId != null && !this.foreignId.isEmpty()) {
            if (shape.onlyMaster) {
                shape.onlyMaster = false;
            }
            if (shape.foreignData == null) {
                shape.foreignData = new VsdxForeignData();
            }
            if (shape.foreignData.attributes == null) {
                shape.foreignData.attributes = new HashMap<String, String>();
            }
            NamedNodeMap attributes = this.foreignNode.getAttributes();
            int cnt = attributes.getLength();
            for (int i = 0; i < cnt; ++i) {
                Node item = attributes.item(i);
                if (!(item instanceof Attr)) continue;
                Attr attr = (Attr)item;
                shape.foreignData.attributes.put(attr.getName(), attr.getValue());
            }
            String fileName = this.rels.get(this.foreignId);
            if (fileName != null && !fileName.isEmpty()) {
                Path path = Paths.get(VsdxParser.PATH_PAGES, fileName);
                path = path.normalize();
                try {
                    if ("Object".equals(shape.foreignData.attributes.get("ForeignType")) && fileName.contains("/embeddings/")) {
                        shape.foreignData.rawFormat = VsdxForeignData.getOleFormat(path);
                        if (shape.foreignData.rawFormat != null) {
                            shape.foreignData.rawData = this.vsdxParser.getFileFromPath(path);
                            if (shape.foreignData.rawFormat == VsdxForeignData.OleFormat.VSD) {
                                VisioOldFormatsConverter converter = new VisioOldFormatsConverter(null);
                                try {
                                    shape.foreignData.rawData = converter.convertOldVisioFormatToNew(shape.foreignData.rawData, VisioOldFormatsConverter.SaveFormat.VSDX);
                                    if (shape.foreignData.rawData == null || shape.foreignData.rawData.length < 10) {
                                        shape.foreignData.rawFormat = null;
                                    }
                                }
                                catch (Exception e) {
                                    shape.foreignData.rawFormat = null;
                                    shape.foreignData.rawData = null;
                                    Core.logger.info(e.getMessage());
                                }
                            } else if (shape.foreignData.rawFormat == VsdxForeignData.OleFormat.XLS) {
                                shape.charts = VsdxChart.parseChartsFromXLS(shape.foreignData.rawData);
                                shape.foreignData.rawFormat = null;
                                shape.foreignData.rawData = null;
                            }
                        }
                        if (shape.foreignData.rawFormat == null) {
                            Map<String, String> r = this.vsdxParser.getRelationships(path.getParent().toString(), path.getFileName().toString() + ".rels");
                            if (r != null && !r.isEmpty()) {
                                assert (r.size() == 1);
                                Iterator<Map.Entry<String, String>> e = r.entrySet().iterator();
                                if (e.hasNext()) {
                                    Map.Entry<String, String> entry = e.next();
                                    path = Paths.get(VsdxParser.PATH_PAGES, entry.getValue());
                                    path = path.normalize();
                                }
                            } else {
                                path = null;
                            }
                        }
                    }
                    if (shape.foreignData.rawData == null && path != null) {
                        shape.foreignData.rawData = this.vsdxParser.getFileFromPath(path);
                    }
                }
                catch (Exception ex) {
                    throw new InformException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0432\u043d\u0435\u0448\u043d\u0438\u0445 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430: " + path, ex);
                }
            }
        }
        if ((shapesNodes = VsdxParser.getElementsByLocalName(this.shapeNode, "Shapes")).isEmpty()) {
            return;
        }
        List<Element> shapeNodes = VsdxParser.getElementsByLocalName(shapesNodes.get(0), "Shape");
        if (shapeNodes.isEmpty()) {
            return;
        }
        if (shape.shapes == null) {
            shape.shapes = new VsdxShapes();
        }
        for (Element node : shapeNodes) {
            if (node == null) continue;
            VsdxShapeParser shapeParser = new VsdxShapeParser(this.vsdxParser, node, this.rels);
            VsdxShape vsdxShape = new VsdxShape(shape.vsdx, shape, shape.page);
            shapeParser.parseShape(vsdxShape, isMaster, shapeParser.getMasterParser());
            shape.shapes.add(vsdxShape);
            if (!shape.onlyMaster || vsdxShape.hasMaster() && vsdxShape.onlyMaster) continue;
            shape.onlyMaster = false;
        }
    }

    public static void correctShape(VsdxShape shape) {
        if (shape.geometries == null) {
            return;
        }
        for (VsdxGeometry geom : shape.geometries) {
            if (geom.rows == null) continue;
            for (VsdxGeometryRow row : geom.rows) {
                if (VsdxShapeParser.useFunctionInsteadOfValue(row.A, row.FunctionA)) {
                    try {
                        row.A = VsdxExpressionEvaluator.evaluateExpression(row.FunctionA, shape);
                    }
                    catch (Exception e) {
                        Core.logger.error(e.getMessage());
                    }
                }
                if (!VsdxShapeParser.useFunctionInsteadOfValue(row.E, row.FunctionE)) continue;
                try {
                    row.E = VsdxExpressionEvaluator.evaluateExpression(row.FunctionE, shape);
                }
                catch (Exception e) {
                    Core.logger.error(e.getMessage());
                }
            }
        }
    }

    private static boolean useFunctionInsteadOfValue(String value, String function) {
        List<String> prohibitedValues = Arrays.asList("", "Inh", "No Formula");
        if (function == null || prohibitedValues.contains(function)) {
            return false;
        }
        try {
            Double.parseDouble(value);
        }
        catch (Exception e) {
            return value == null || "".equals(value) || VsdxExpressionEvaluator.countArguments(value) != VsdxExpressionEvaluator.countArguments(function);
        }
        return false;
    }

    private void correctRelationshipsID(String[] arrID) {
        if (arrID == null) {
            return;
        }
        for (String v : arrID) {
            if (v == null) continue;
            int startIdx = -1;
            int idx = 0;
            while ((startIdx = v.indexOf(".", startIdx + 1)) > 0) {
                idx = startIdx;
            }
            if (idx <= 0) continue;
            arrID[i] = v.substring(idx + 1);
        }
    }

    private int parseRelationships(List<String> params, String formula, int startIndex) {
        assert (params != null);
        params.clear();
        if (formula == null || formula.isEmpty()) {
            return -1;
        }
        int idx = formula.indexOf("DEPENDSON", startIndex);
        if (idx < 0) {
            return -1;
        }
        int level = 0;
        StringBuilder sb = new StringBuilder();
        char[] chars = formula.toCharArray();
        int last = chars.length - 1;
        block5: for (int index = idx += "DEPENDSON".length(); index <= last; ++index) {
            char c = chars[index];
            switch (c) {
                case '(': {
                    ++level;
                    continue block5;
                }
                case ')': {
                    if (--level > 0 && index < last) continue block5;
                }
                case ',': {
                    if (level >= 2) continue block5;
                    String s = sb.toString();
                    sb.setLength(0);
                    if (!s.isEmpty()) {
                        int i1 = s.indexOf("Sheet.");
                        if (i1 >= 0) {
                            int i2 = s.indexOf("!SheetRef", i1 += "Sheet.".length());
                            s = s.substring(i1, i2);
                        } else if (s.contains("!SheetRef")) {
                            s = s.substring(0, s.indexOf("!SheetRef"));
                        }
                        s = s.trim();
                        if (!s.isEmpty()) {
                            params.add(s);
                        }
                    }
                    if (level != 0 && index != last) continue block5;
                    return index;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return -1;
    }
}

