/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx;

import inform.agent.schemes.converters.vsdx.VsdxParser;
import inform.agent.schemes.converters.vsdx.VsdxRowsSectionParser;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.VsdxTabs;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VsdxTabsParser
extends VsdxRowsSectionParser {
    VsdxTabsParser(VsdxParser vsdxParser, Element characterNode) {
        super(vsdxParser, characterNode);
    }

    public void parse(VsdxShape shape) {
        if (shape == null) {
            return;
        }
        Element characterSection = this.getSectionNode();
        if (characterSection == null) {
            return;
        }
        NodeList childNodes = characterSection.getChildNodes();
        if (childNodes == null) {
            return;
        }
        int cnt = childNodes.getLength();
        if (cnt == 0) {
            return;
        }
        VsdxTabs tabs = new VsdxTabs();
        tabs.TabList = new ArrayList();
        int alignmentNameLen = VsdxTabs.ALIGNMENT_NAME.length();
        int positionNameLen = VsdxTabs.POSITION_NAME.length();
        for (int i = 0; i < cnt; ++i) {
            NodeList cells;
            Node item = childNodes.item(i);
            if (item == null || item.getNodeType() != 1 || (cells = item.getChildNodes()) == null) continue;
            int cntj = cells.getLength();
            for (int j = 0; j < cntj; ++j) {
                VsdxTabs.VsdxTab tab;
                String index;
                if (cells.item(j).getNodeType() != 1) continue;
                Element cell = (Element)cells.item(j);
                String cellValue = cell.getAttribute("V");
                String attributeN = cell.getAttribute("N");
                assert (attributeN != null);
                if (attributeN.startsWith(VsdxTabs.POSITION_NAME)) {
                    index = attributeN.substring(positionNameLen);
                    tab = tabs.findVsdxTabByIndex(index);
                    if (tab == null) {
                        tab = new VsdxTabs.VsdxTab();
                        tab.Index = index;
                        tabs.TabList.add(tab);
                    }
                    tab.Position = cellValue;
                    continue;
                }
                if (!attributeN.startsWith(VsdxTabs.ALIGNMENT_NAME)) continue;
                index = attributeN.substring(alignmentNameLen);
                tab = tabs.findVsdxTabByIndex(index);
                if (tab == null) {
                    tab = new VsdxTabs.VsdxTab();
                    tab.Index = index;
                    tabs.TabList.add(tab);
                }
                tab.Alignment = cellValue;
            }
        }
        if (!tabs.TabList.isEmpty()) {
            shape.Tabs = tabs;
        }
    }
}

