/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.evaluator;

import inform.agent.Core;
import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.evaluator.AbstractSyntaxTreeNode;
import inform.agent.schemes.converters.vsdx.evaluator.ExpressionParser;
import inform.agent.schemes.converters.vsdx.evaluator.ExpressionTokenizer;
import inform.agent.schemes.converters.vsdx.evaluator.Token;
import inform.agent.schemes.converters.vsdx.evaluator.resolvers.VariableResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class VsdxExpressionEvaluator {
    private static final HashSet<String> uncomputableFunctions = new HashSet<String>(Arrays.asList("nurbs", "polyline"));

    public static int countArguments(String expression) {
        ExpressionTokenizer et = new ExpressionTokenizer(expression);
        try {
            Token t = et.nextToken();
            Token prevToken = new Token(Token.Type.EOF);
            if (t.type != Token.Type.Function) {
                return -1;
            }
            int currentBrackets = 0;
            int commaCount = 0;
            while (t.type != Token.Type.EOF) {
                if (t.type == Token.Type.OpeningBracket) {
                    ++currentBrackets;
                } else if (t.type == Token.Type.ClosingBracket) {
                    if (prevToken.type == Token.Type.OpeningBracket && currentBrackets == 1) {
                        return 0;
                    }
                    --currentBrackets;
                } else if (t.type == Token.Type.Comma && currentBrackets == 1) {
                    ++commaCount;
                }
                prevToken = t;
                t = et.nextToken();
            }
            return commaCount + 1;
        }
        catch (Exception e) {
            Core.logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0442\u043e\u043a\u0435\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u044f " + expression, e);
            return -1;
        }
    }

    public static String evaluateExpression(String expression, VsdxShape shape) throws Exception {
        AbstractSyntaxTreeNode.AstFunctionCallNode fRoot;
        String functionName;
        ExpressionTokenizer et = new ExpressionTokenizer(expression);
        ExpressionParser ep = new ExpressionParser(et, new VariableResolver(shape));
        AbstractSyntaxTreeNode root = ep.parseExpression();
        if (root instanceof AbstractSyntaxTreeNode.AstFunctionCallNode && VsdxExpressionEvaluator.isUncomputable(functionName = (fRoot = (AbstractSyntaxTreeNode.AstFunctionCallNode)root).getFunctionName().toLowerCase())) {
            ArrayList<String> arguments = new ArrayList<String>();
            for (AbstractSyntaxTreeNode argument : fRoot.getArguments()) {
                arguments.add(VsdxExpressionEvaluator.cutDecimalPlaces(String.valueOf(argument.evaluate())));
            }
            return functionName + "(" + String.join((CharSequence)",", arguments) + ")";
        }
        String res = String.valueOf(root.evaluate());
        return VsdxExpressionEvaluator.cutDecimalPlaces(res);
    }

    private static String cutDecimalPlaces(String number) {
        if (number.endsWith(".0")) {
            return number.substring(0, number.length() - 2);
        }
        return number;
    }

    private static boolean isUncomputable(String functionName) {
        return uncomputableFunctions.contains(functionName.toLowerCase());
    }
}

