/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.themes;

import inform.agent.web.utils.Color;

public class VsdxColorParser {
    public static int[] hslToRgb(double[] hsl) {
        double b;
        double g;
        double r;
        double h = hsl[0];
        double s = hsl[1];
        double l = hsl[2];
        double d = s * (1.0 - Math.abs(2.0 * l - 1.0));
        double m = 255.0 * (l - d / 2.0);
        double x = d * (1.0 - Math.abs(h / 60.0 % 2.0 - 1.0));
        if (h < 60.0) {
            r = 255.0 * d + m;
            g = 255.0 * x + m;
            b = m;
        } else if (h >= 60.0 && h < 120.0) {
            r = 255.0 * x + m;
            g = 255.0 * d + m;
            b = m;
        } else if (h >= 120.0 && h < 180.0) {
            r = m;
            g = 255.0 * d + m;
            b = 255.0 * x + m;
        } else if (h >= 180.0 && h < 240.0) {
            r = m;
            g = 255.0 * x + m;
            b = 255.0 * d + m;
        } else if (h >= 240.0 && h < 300.0) {
            r = 255.0 * x + m;
            g = m;
            b = 255.0 * d + m;
        } else {
            r = 255.0 * d + m;
            g = m;
            b = 255.0 * x + m;
        }
        return new int[]{(int)r, (int)g, (int)b};
    }

    public static double[] rgbToHsl(int[] rgb) {
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        double M = Math.max(r, g);
        M = Math.max(M, b);
        double m = Math.min(r, g);
        m = Math.min(m, b);
        double d = (M - m) / 255.0;
        double L = (M + m) / 510.0;
        double S = 0.0;
        if (L > 0.0) {
            S = d / (1.0 - Math.abs(2.0 * L - 1.0));
        }
        double H = 0.0;
        if (d != 0.0) {
            double body = (r - g / 2.0 - b / 2.0) / Math.sqrt(r * r + g * g + b * b - r * g - r * b - g * b);
            H = Math.toDegrees(Math.acos(body));
        }
        if (b > g) {
            H = 360.0 - H;
        }
        return new double[]{H, S, L};
    }

    public static double[] hexToHsl(String hex) {
        return VsdxColorParser.rgbToHsl(Color.hexToRgb(hex));
    }

    public static boolean isHex(String hex) {
        if (hex == null) {
            return false;
        }
        switch (hex.length()) {
            case 6: {
                break;
            }
            case 7: {
                if (hex.charAt(0) != '#') {
                    return false;
                }
                hex = hex.substring(1);
                break;
            }
            default: {
                return false;
            }
        }
        for (char s : hex.toCharArray()) {
            if (s >= '0' && s <= '9' || s >= 'A' && s <= 'F' || s >= 'a' && s <= 'f') continue;
            return false;
        }
        return true;
    }
}

