/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.converters.vsdx.themes.types.complex;

import inform.agent.schemes.converters.vsdx.VsdxShape;
import inform.agent.schemes.converters.vsdx.themes.VsdxColorProperties;
import inform.agent.schemes.converters.vsdx.themes.types.complex.ColorEffect;
import inform.agent.schemes.converters.vsdx.themes.types.simple.FixedAngle;
import inform.agent.schemes.converters.vsdx.themes.types.simple.Percentage;
import inform.agent.schemes.converters.vsdx.themes.types.simple.PositiveCoordinate;
import inform.agent.schemes.converters.vsdx.themes.types.simple.PositiveFixedAngle;
import inform.agent.schemes.converters.vsdx.themes.types.simple.RectAlignment;

public class OuterShadowEffect
extends ColorEffect {
    private final RectAlignment shadowAlignment;
    private final PositiveFixedAngle shadowDirection;
    private final PositiveCoordinate shadowOffsetDistance;
    private final FixedAngle horizontalSkew;
    private final FixedAngle verticalSkew;
    private final Percentage horizontalScalingFactor;
    private final Percentage verticalScalingFactor;
    private final PositiveCoordinate blurRadius;
    private final boolean rotateWithShape;

    public OuterShadowEffect(RectAlignment shadowAlignment, PositiveFixedAngle shadowDirection, PositiveCoordinate shadowOffsetDistance, FixedAngle horizontalSkew, FixedAngle verticalSkew, Percentage horizontalScalingFactor, Percentage verticalScalingFactor, PositiveCoordinate blurRadius, boolean rotateWithShape, VsdxColorProperties shadowColor) {
        super(shadowColor);
        this.shadowAlignment = shadowAlignment;
        this.shadowDirection = shadowDirection;
        this.shadowOffsetDistance = shadowOffsetDistance;
        this.horizontalSkew = horizontalSkew;
        this.verticalSkew = verticalSkew;
        this.horizontalScalingFactor = horizontalScalingFactor;
        this.verticalScalingFactor = verticalScalingFactor;
        this.blurRadius = blurRadius;
        this.rotateWithShape = rotateWithShape;
    }

    @Override
    public void applyToShape(VsdxShape shape, String resolvedColor) {
        double rads;
        if ("Themed".equals(shape.ShdwForegnd)) {
            shape.ShdwForegnd = this.effectColor.mergeColorWithStyles(resolvedColor);
        }
        if ("Themed".equals(shape.ShdwForegndTrans)) {
            shape.ShdwForegndTrans = String.valueOf(this.effectColor.getAlpha());
        }
        if ("Themed".equals(shape.ShapeShdwBlur)) {
            shape.ShapeShdwBlur = String.valueOf(this.blurRadius.getInches());
        }
        if ("Themed".equals(shape.ShdwPattern)) {
            shape.ShdwPattern = "1";
        }
        if ("Themed".equals(shape.ShapeShdwShow)) {
            shape.ShapeShdwShow = "2";
        }
        if ("Themed".equals(shape.ShapeShdwType)) {
            shape.ShapeShdwType = this.horizontalSkew.isZeroAngle() ? "1" : "2";
        }
        if ("Themed".equals(shape.ShapeShdwObliqueAngle)) {
            if (this.horizontalSkew.isZeroAngle()) {
                shape.ShapeShdwObliqueAngle = "0";
            } else {
                rads = -Math.atan(Math.tan(this.horizontalSkew.getRadians()) / this.verticalScalingFactor.getFraction());
                shape.ShapeShdwObliqueAngle = String.valueOf(rads);
            }
        }
        if ("Themed".equals(shape.ShapeShdwScaleFactor)) {
            if (this.horizontalSkew.isZeroAngle()) {
                shape.ShapeShdwScaleFactor = "1.0";
            } else {
                rads = -Math.atan(Math.tan(this.horizontalSkew.getRadians()) / this.verticalScalingFactor.getFraction());
                double scale = this.verticalScalingFactor.getFraction() / Math.cos(rads);
                shape.ShapeShdwScaleFactor = String.valueOf(scale);
            }
        }
        if ("Themed".equals(shape.ShapeShdwOffsetX)) {
            if (this.shadowDirection.isRightAngle()) {
                shape.ShapeShdwOffsetX = "0";
            } else {
                double distX = Math.cos(this.shadowDirection.getRadians()) * this.shadowOffsetDistance.getInches();
                shape.ShapeShdwOffsetX = String.valueOf(distX);
            }
        }
        if ("Themed".equals(shape.ShapeShdwOffsetY)) {
            if (this.shadowDirection.isZeroAngle()) {
                shape.ShapeShdwOffsetY = "0";
            } else {
                double distY = -Math.sin(this.shadowDirection.getRadians()) * this.shadowOffsetDistance.getInches();
                shape.ShapeShdwOffsetY = String.valueOf(distY);
            }
        }
    }
}

