/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.effects;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.SchemeUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.Objects;

public class Glow {
    public static Glow NO_EFFECT = new Glow(SchemeUtils.Colors.NONE, 0.0, 0);
    private final Color color;
    private final double size;
    private final int transparency;

    public Glow(Color color, double size, int transparency) {
        this.color = Objects.requireNonNull(color);
        this.size = size;
        this.transparency = transparency;
    }

    public boolean isEnabled() {
        return !this.color.equals(SchemeUtils.Colors.NONE) || this.size > 0.0 || this.transparency > 0;
    }

    public synchronized void writeTaggedData(TaggedWriter writer) throws IOException {
        if (!this.color.equals(SchemeUtils.Colors.NONE)) {
            SchemeUtils.writeColor(writer, 12, this.color);
        }
        if (this.size >= 0.0) {
            writer.putDouble(13, this.size);
        }
        if (this.transparency != 0) {
            writer.putInt08(14, (byte)((double)this.transparency / 100.0 * 255.0));
        }
    }
}

