/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.schemes.effects;

import inform.adt.taggedio.TaggedWriter;
import inform.agent.schemes.SchemeUtils;
import java.awt.Color;
import java.io.IOException;

public class Shadow {
    public static final Shadow NO_EFFECT = new Shadow(ShadowType.NONE, SchemeUtils.Colors.BLACK, 0, 0, 0.0, 0.0, 0.0);
    private final ShadowType type;
    private final Color color;
    private final int transparency;
    private final int size;
    private final double blurSize;
    private final double angle;
    private final double offset;
    private final PerspectivePosition perspectivePosition;

    public static Shadow createOuterShadow(Color color, int transparency, int size, double blurSize, double angle, double offset) {
        return new Shadow(ShadowType.OUTER, color, transparency, size, blurSize, angle, offset);
    }

    public static Shadow createInnerShadow(Color color, int transparency, double blurSize, double angle, double offset) {
        return new Shadow(ShadowType.INNER, color, transparency, 0, blurSize, angle, offset);
    }

    public static Shadow createPerspectiveShadow(Color color, int transparency, int size, double blurSize, double angle, double offset, double obliqueAngle) {
        return new Shadow(ShadowType.PERSPECTIVE, color, transparency, size, blurSize, angle, offset, obliqueAngle);
    }

    public boolean isEnabled() {
        return this.transparency != 0 || this.size != 0 || this.blurSize >= 0.0 || this.angle >= 0.0 || this.offset >= 0.0;
    }

    private Shadow(ShadowType type, Color color, int transparency, int size, double blurSize, double angle, double offset) {
        this(type, color, transparency, size, blurSize, angle, offset, 0.0);
    }

    private Shadow(ShadowType type, Color color, int transparency, int size, double blurSize, double angle, double offset, double obliqueAngle) {
        this.type = type;
        this.color = color;
        this.transparency = transparency;
        this.size = size;
        this.blurSize = blurSize;
        this.angle = angle;
        this.offset = offset;
        this.perspectivePosition = type == ShadowType.PERSPECTIVE ? PerspectivePosition.determinePositionByAngle(obliqueAngle) : PerspectivePosition.NONE;
    }

    public synchronized void writeTaggedData(TaggedWriter writer) throws IOException {
        writer.putInt32(5, this.type.value());
        SchemeUtils.writeColor(writer, 6, this.color);
        if (this.transparency != 0) {
            writer.putInt08(7, (byte)((double)this.transparency / 100.0 * 255.0));
        }
        if (this.size != 0) {
            writer.putInt32(8, this.size);
        }
        if (this.blurSize != 0.0) {
            writer.putDouble(9, this.blurSize);
        }
        if (this.angle != 0.0) {
            writer.putDouble(10, this.angle);
        }
        if (this.offset != 0.0) {
            writer.putDouble(11, this.offset);
        }
        if (this.perspectivePosition != PerspectivePosition.NONE) {
            writer.putInt32(17, this.perspectivePosition.value());
        }
    }

    private static enum PerspectivePosition {
        NONE(-1),
        BEHIND_LEFT(0),
        BEHIND_RIGHT(1),
        BELOW(2),
        FRONT_LEFT(3),
        FRONT_RIGHT(4);

        private final int value;

        private PerspectivePosition(int value) {
            this.value = value;
        }

        int value() {
            return this.value;
        }

        static PerspectivePosition determinePositionByAngle(double angle) {
            int normalizedAngle = (int)Math.round(angle);
            if (normalizedAngle < 0) {
                normalizedAngle += 360;
            }
            if (normalizedAngle >= 170 && normalizedAngle <= 190) {
                return BELOW;
            }
            if (normalizedAngle <= 90) {
                return BEHIND_RIGHT;
            }
            if (normalizedAngle <= 180) {
                return FRONT_RIGHT;
            }
            if (normalizedAngle <= 270) {
                return FRONT_LEFT;
            }
            return BEHIND_LEFT;
        }
    }

    private static enum ShadowType {
        NONE(0),
        OUTER(1),
        INNER(2),
        PERSPECTIVE(3);

        private final int value;

        private ShadowType(int value) {
            this.value = value;
        }

        int value() {
            return this.value;
        }
    }
}

