/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.UnsupportedTypeField;
import java.io.IOException;

public class BlobField
extends UnsupportedTypeField {
    private static final String[] availJSPropertiesNames = new String[]{"asBinary", "blobSize"};
    private static final String[] availJSFunctionsNames = new String[]{"loadFromFile", "saveToFile"};

    BlobField(FieldDescriptor desc, RowsetAccessor ra) {
        super(desc, ra);
        for (String s : availJSPropertiesNames) {
            this.defineProperty(s, BlobField.class, 0);
        }
        this.defineFunctionProperties(availJSFunctionsNames, BlobField.class, 0);
    }

    @Override
    public boolean isCompatibleValue(Object value) {
        return value instanceof BinaryObject || value instanceof String;
    }

    @Override
    public BinaryObject getAsBinary() throws Exception {
        if (!this.ra.isCurrentRowAvailable()) {
            return null;
        }
        Object complex = this.ra.getCurrentRow().getComplex(this.getDescriptor().getIndex());
        if (complex instanceof BinaryObject) {
            return (BinaryObject)complex;
        }
        throw new UnsupportedOperationException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    public long getBlobSize() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return 0L;
        }
        return this.ra.getCurrentRow().getBlobLength(this.getDescriptor().getIndex());
    }

    @Override
    public String getAsString() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return "";
        }
        Object complex = this.ra.getCurrentRow().getComplex(this.getDescriptor().getIndex());
        if (complex instanceof BinaryObject) {
            BinaryObject bin = (BinaryObject)complex;
            return new String(bin.getInternalBuffer(), 0, bin.getSize(), TaggedWriter.ANSI);
        }
        throw new UnsupportedOperationException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 (asString) \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f");
    }

    @Override
    public void setAsBinary(BinaryObject value) throws Exception {
        if (this.ra.getCurrentRow().setComplex(this.getDescriptor().getIndex(), value)) {
            this.notifyModified();
        }
    }

    @Override
    public void setAsString(String value) throws InformException {
        if (this.ra.getCurrentRow().setComplex(this.getDescriptor().getIndex(), value)) {
            this.notifyModified();
        }
    }

    Object getObject() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return null;
        }
        return this.ra.getCurrentRow().getComplex(this.getDescriptor().getIndex());
    }

    @Override
    protected void assignNotNullValue(Object value) {
        boolean modified = value instanceof BinaryObject ? this.ra.getCurrentRow().setComplex(this.getDescriptor().getIndex(), value) : this.ra.getCurrentRow().setComplex(this.getDescriptor().getIndex(), ValueCaster.toString(value));
        if (modified) {
            this.notifyModified();
        }
    }

    public void loadFromFile(String pathname) throws IOException, InformException {
        BinaryObject value = new BinaryObject();
        value.loadFromFile(pathname);
        this.assignNotNullValue(value);
    }

    public void saveToFile(String pathname) throws Exception {
        this.getAsBinary().saveToFile(pathname);
    }

    @Override
    public Object getValue() throws Exception {
        return this.getAsBinary();
    }

    @Override
    protected void notifyModified() {
        if (this.desc.hasBlobSizeFields()) {
            long size = this.getBlobSize();
            TableDescriptor td = this.ra.getTableDescriptor();
            for (int c : this.desc.getBlobSizeFields()) {
                FieldDescriptor fd = td.getExistingFieldDescriptor(c);
                if (fd == null) continue;
                this.ra.getCurrentRow().setNumeric(fd.getIndex(), size);
            }
        }
        super.notifyModified();
    }
}

