/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.collections.IntegerHash;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.ScriptableValue;
import inform.common.DateFunction;
import java.util.Date;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Constant
extends ScriptableObject
implements ScriptableValue,
IntegerHash.Entry {
    private final int id;
    private DataType constantType;
    private DataType dataType;
    Object value;
    private boolean isIgnored;
    private String name;
    private boolean actual;
    private boolean modified = false;
    private boolean add_multiple = false;
    private boolean isOrgValueValid = false;
    private boolean orgIsIgnored;
    private Object orgValue;
    private static final String[] jsProps = new String[]{"value", "asDate", "asDateValue", "asString", "asNumber", "asBoolean", "isIgnored", "isInherited"};
    private static final String[] availJSFunctionsNames = new String[]{"clear", "addValue", "toString"};

    Constant(Scriptable parentScope, int id) {
        this.setParentScope(parentScope);
        this.id = id;
        this.value = null;
        this.isIgnored = false;
        this.name = "";
        this.actual = false;
        for (String s : jsProps) {
            this.defineProperty(s, Constant.class, 0);
        }
        this.defineProperty("id", this.getClass(), 1);
        this.defineProperty("name", this.getClass(), 1);
        this.defineProperty("isNull", this.getClass(), 1);
        this.defineFunctionProperties(availJSFunctionsNames, Constant.class, 0);
    }

    void setOrgValue() {
        if (this.isOrgValueValid) {
            return;
        }
        this.orgIsIgnored = this.isIgnored;
        this.orgValue = this.value;
        this.isOrgValueValid = true;
    }

    boolean isActual() {
        return this.actual;
    }

    void setModifiedFlag() {
        if (this.id >= 0) {
            this.modified = true;
        }
    }

    void clearModifiedFlag() {
        if (this.id >= 0) {
            this.modified = false;
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    void setIgnored() {
        this.add_multiple = false;
        this.isIgnored = true;
        if (this.isIgnored) {
            this.value = null;
        }
    }

    public void setActual() {
        this.actual = true;
    }

    public boolean getIsInherited() {
        return !this.actual;
    }

    public void setIsInherited(boolean v) {
        if (v && this.actual && this.isOrgValueValid) {
            this.isIgnored = this.orgIsIgnored;
            this.value = this.orgValue;
        }
        this.actual = !v;
        this.setModifiedFlag();
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int key() {
        return this.id;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getSqlTypeId() {
        if (this.dataType == null) {
            return 0;
        }
        return this.dataType.toSqlDataType().toInteger();
    }

    DataType constantType() {
        return this.constantType != null ? this.constantType : this.dataType;
    }

    void setConstantType(int dataTypeId) {
        this.constantType = this.dataType = DataType.getDataTypeById(dataTypeId);
    }

    void setDataType(int dataTypeId) {
        this.dataType = DataType.getDataTypeById(dataTypeId);
    }

    void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    void updateDataType(DataType type) {
        if (this.dataType != DataType.NONE) {
            this.dataType = type;
        }
    }

    void setFunction(int f) {
        if (f == 0) {
            return;
        }
        DateFunction function = DateFunction.fromID(f);
        if (function == DateFunction.sfNone) {
            return;
        }
        this.dataType = DataType.DATE_TIME;
        this.value = function.getDate();
        this.isIgnored = false;
    }

    @Override
    public Object getRawValue() {
        if (this.isIgnored) {
            return null;
        }
        return this.value;
    }

    @Override
    public boolean getIsIgnored() {
        return this.isIgnored;
    }

    void setIsIgnored(boolean value) {
        this.setIgnored();
        this.actual = true;
        this.setModifiedFlag();
    }

    public boolean getIsNull() {
        return !this.isIgnored && this.value == null;
    }

    public void clear() {
        this.add_multiple = false;
        this.actual = true;
        this.setModifiedFlag();
        this.value = null;
        this.setIsIgnored(false);
    }

    public void setRawValue(Object newValue) {
        this.value = newValue;
        this.add_multiple = false;
        this.isIgnored = false;
    }

    @Override
    public String getClassName() {
        return "Constant";
    }

    public Object getValue() {
        return this.getRawValue();
    }

    public void setValue(Object v) throws InformException {
        this.actual = true;
        this.setModifiedFlag();
        this.add_multiple = false;
        if (v == null) {
            this.setRawValue(null);
        } else {
            this.setRawValue(ValueCaster.getCastedValue(this.dataType, v));
        }
    }

    private void internalAddValue(Object value) {
        Object[] array;
        if (!this.add_multiple) {
            if (value == null) {
                this.clear();
            } else {
                this.setValue(value);
            }
            this.add_multiple = true;
            return;
        }
        boolean isO = this.value instanceof Object[] && !this.isIgnored;
        boolean isN = value instanceof Object[];
        if (!isO && !isN) {
            value = ValueCaster.getCastedValue(this.dataType, value);
            array = this.isIgnored ? new Object[]{value} : new Object[]{this.value, value};
        } else if (!isO && isN) {
            if (this.isIgnored) {
                array = new Object[((Object[])value).length];
                for (int i = 0; i < ((Object[])value).length; ++i) {
                    Object v = ((Object[])value)[i];
                    array[i] = v == null ? null : ValueCaster.getCastedValue(this.dataType, v);
                }
            } else {
                array = new Object[((Object[])value).length + 1];
                array[0] = this.value;
                for (int i = 0; i < ((Object[])value).length; ++i) {
                    Object v = ((Object[])value)[i];
                    array[i + 1] = v == null ? null : ValueCaster.getCastedValue(this.dataType, v);
                }
            }
        } else if (isO && !isN) {
            array = new Object[((Object[])this.value).length + 1];
            for (int i = 0; i < ((Object[])this.value).length; ++i) {
                array[i] = ((Object[])this.value)[i];
            }
            array[array.length - 1] = ValueCaster.getCastedValue(this.dataType, value);
        } else {
            array = new Object[((Object[])value).length + ((Object[])this.value).length];
            for (int i = 0; i < ((Object[])this.value).length; ++i) {
                array[i] = ((Object[])this.value)[i];
            }
            for (int j = 0; j < ((Object[])value).length; ++j) {
                array[i + j] = ValueCaster.getCastedValue(this.dataType, ((Object[])value)[j]);
            }
        }
        this.isIgnored = false;
        this.value = array;
        this.actual = true;
        this.setModifiedFlag();
    }

    public static Object addValue(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        Constant self = (Constant)thisObj;
        for (Object a : args) {
            self.internalAddValue(a);
        }
        return null;
    }

    public Object getAsDate() throws InformException {
        Date d = ValueCaster.toDate(this.getSingleValue());
        Context cx = Context.getCurrentContext();
        Object[] ctorArgs = new Object[]{d.getTime()};
        return cx.newObject(this, "Date", ctorArgs);
    }

    public void setAsDate(Object value) throws InformException {
        this.setValue(value);
    }

    public double getAsDateValue() throws InformException {
        return ValueCaster.toNumber(this.getSingleValue()).doubleValue();
    }

    public void setAsDateValue(Object value) throws InformException {
        this.setValue(value);
    }

    public String getAsString() throws InformException {
        return ValueCaster.toString(this.getSingleValue());
    }

    public void setAsString(Object value) throws InformException {
        this.setValue(value);
    }

    public double getAsNumber() throws InformException {
        return ValueCaster.toNumber(this.getSingleValue()).doubleValue();
    }

    public void setAsNumber(Object value) throws InformException {
        this.setValue(value);
    }

    public boolean getAsBoolean() throws InformException {
        return ValueCaster.toBoolean(this.getSingleValue());
    }

    public void setAsBoolean(Object value) throws InformException {
        this.setValue(value);
    }

    private Object getSingleValue() {
        if (this.isIgnored) {
            return null;
        }
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Object[]) {
            return ((Object[])this.value)[0];
        }
        return this.value;
    }

    public boolean JNI_isArray() {
        if (this.isIgnored) {
            return false;
        }
        if (this.value == null) {
            return false;
        }
        return this.value instanceof Object[];
    }

    public boolean JNI_hasNull() {
        if (this.isIgnored) {
            return false;
        }
        if (this.value == null) {
            return true;
        }
        if (this.value instanceof Object[]) {
            for (Object v : (Object[])this.value) {
                if (v != null) continue;
                return true;
            }
        }
        return false;
    }

    public int[] JNI_getIntArray() throws InformException {
        if (this.isIgnored || this.value == null) {
            return null;
        }
        if (this.value instanceof Object[]) {
            Object[] v = (Object[])this.value;
            int count = v.length;
            if (this.JNI_hasNull()) {
                --count;
            }
            int[] a = new int[count];
            count = 0;
            for (Object o : v) {
                if (o == null) continue;
                a[count++] = ValueCaster.toInt(o);
            }
            return a;
        }
        int[] a = new int[]{ValueCaster.toInt(this.value)};
        return a;
    }

    public double[] JNI_getDoubleArray() throws InformException {
        if (this.isIgnored || this.value == null) {
            return null;
        }
        if (this.value instanceof Object[]) {
            Object[] v = (Object[])this.value;
            int count = v.length;
            if (this.JNI_hasNull()) {
                --count;
            }
            double[] a = new double[count];
            count = 0;
            for (Object o : v) {
                if (o == null) continue;
                a[count++] = ValueCaster.toDouble(o);
            }
            return a;
        }
        double[] a = new double[]{ValueCaster.toDouble(this.value)};
        return a;
    }

    public String[] JNI_getStringArray() throws InformException {
        if (this.isIgnored || this.value == null) {
            return null;
        }
        if (this.value instanceof Object[]) {
            Object[] v = (Object[])this.value;
            int count = v.length;
            if (this.JNI_hasNull()) {
                --count;
            }
            String[] a = new String[count];
            count = 0;
            for (Object o : v) {
                if (o == null) continue;
                a[count++] = ValueCaster.toString(o);
            }
            return a;
        }
        String[] a = new String[]{ValueCaster.toString(this.value)};
        return a;
    }

    public String toString() {
        return "constant " + this.name + " " + this.getAsString();
    }
}

