/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.agent.Core;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.License;
import inform.agent.scripts.NetLibrary;
import inform.agent.scripts.crypto.CryptoCertificate;
import inform.agent.scripts.crypto.CryptoCipher;
import inform.agent.scripts.crypto.CryptoDigest;
import inform.agent.scripts.crypto.CryptoPrivateKey;
import inform.agent.scripts.crypto.CryptoSignature;
import inform.agent.scripts.crypto.CryptoSoapCipher;
import inform.agent.scripts.crypto.CryptoSoapSignature;
import inform.agent.scripts.crypto.CryptoStore;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.agent.scripts.crypto.CryptoXmlCipher;
import inform.agent.scripts.crypto.CryptoXmlSignature;
import inform.common.Base64BinString;
import inform.common.SmartScriptableObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.impl.AsmoLogger;

public class CryptoLibrary
extends SmartScriptableObject {
    public static final String GOST_CIPHER_NAME = "GOST28147";
    Request request;
    private static final String PROTOKOL_TLS = "GostTLS";
    private static final String ALGORITM_TLS = "GostX509";

    public CryptoLibrary(Scriptable scope) {
        this.setParentScope(scope);
        CryptoLibrary.putConstProperty(this, "STORE_HDD", "HDImageStore");
        CryptoLibrary.putConstProperty(this, "STORE_FLOPPY", "FloppyStore");
        CryptoLibrary.putConstProperty(this, "STORE_J6CF", "J6CFStore");
        CryptoLibrary.putConstProperty(this, "STORE_OCF", "OCFStore");
        CryptoLibrary.putConstProperty(this, "STORE_RUTOKEN", "RutokenStore");
        CryptoLibrary.putConstProperty(this, "GOST_DIGEST_NAME", "GOST3411");
        CryptoLibrary.putConstProperty(this, "GOST_DIGEST_2012_256_NAME", "GOST3411_2012_256");
        CryptoLibrary.putConstProperty(this, "GOST_DIGEST_2012_512_NAME", "GOST3411_2012_512");
        CryptoLibrary.putConstProperty(this, "GOST_EL_NAME", "GOST3410EL");
        CryptoLibrary.putConstProperty(this, "GOST_EL_2012_256_NAME", "GOST3410_2012_256");
        CryptoLibrary.putConstProperty(this, "GOST_EL_2012_512_NAME", "GOST3410_2012_512");
        CryptoLibrary.putConstProperty(this, "GOST_CIPHER_NAME", GOST_CIPHER_NAME);
        CryptoLibrary.putConstProperty(this, "URI_GOST_TRANSPORT", "urn:ietf:params:xml:ns:cpxmlsec:algorithms:transport-gost2001");
        CryptoLibrary.putConstProperty(this, "URI_GOST_TRANSPORT_2012_256", "urn:ietf:params:xml:ns:cpxmlsec:algorithms:transport-gost2012-256");
        CryptoLibrary.putConstProperty(this, "URI_GOST_TRANSPORT_2012_512", "urn:ietf:params:xml:ns:cpxmlsec:algorithms:transport-gost2012-512");
        CryptoLibrary.putConstProperty(this, "URI_GOST_CIPHER", "urn:ietf:params:xml:ns:cpxmlsec:algorithms:gost28147");
    }

    @Override
    public String getClassName() {
        return "Crypto";
    }

    @SmartScriptableObject.FunctionTag
    public KeyStoreInfo keyStore(String aStoreType, String aStorePassword, String aKeyPassword) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        return new KeyStoreInfo((Scriptable)this, aStoreType, (Object)aStorePassword, (Object)aKeyPassword);
    }

    @SmartScriptableObject.FunctionTag
    public CertStoreInfo certStore(String aStoreFile, String aStorePassword) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
        return new CertStoreInfo(this, aStoreFile, aStorePassword);
    }

    @SmartScriptableObject.FunctionTag
    public Request createHttpsRequest(KeyStoreInfo keyStore, CertStoreInfo trustStore) {
        return new Request(this, keyStore, trustStore);
    }

    @SmartScriptableObject.FunctionTag
    public CryptoDigest createDigest(String algorithmName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new CryptoDigest(this, algorithmName, "JCP");
    }

    @SmartScriptableObject.FunctionTag
    public CryptoSignature createSignature(String algorithmName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return new CryptoSignature(this, algorithmName, "JCP");
    }

    @SmartScriptableObject.FunctionTag
    public CryptoCipher createCipher(CryptoPrivateKey privateKey, CryptoCertificate certificate, Object algorithmName) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String algName = algorithmName instanceof String ? (String)algorithmName : GOST_CIPHER_NAME;
        return new CryptoCipher(this, privateKey, certificate, algName);
    }

    @SmartScriptableObject.FunctionTag
    public CryptoXmlCipher createXmlCipher(CryptoPrivateKey privateKey, CryptoCertificate certificate, String exchKeyAlgName, Object algorithmName) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String algName = algorithmName instanceof String ? (String)algorithmName : GOST_CIPHER_NAME;
        return new CryptoXmlCipher(this, privateKey, certificate, exchKeyAlgName, algName);
    }

    @SmartScriptableObject.FunctionTag
    public CryptoSoapCipher createSoapCipher(CryptoPrivateKey privateKey, CryptoCertificate certificate, String exchKeyAlgName, Object algorithmName) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String algName = algorithmName instanceof String ? (String)algorithmName : GOST_CIPHER_NAME;
        return new CryptoSoapCipher(this, privateKey, certificate, exchKeyAlgName, algName);
    }

    @SmartScriptableObject.FunctionTag
    public CryptoXmlSignature createXmlSignature() {
        return new CryptoXmlSignature(this);
    }

    @SmartScriptableObject.FunctionTag
    public CryptoSoapSignature createSoapSignature() {
        return new CryptoSoapSignature(this);
    }

    @SmartScriptableObject.FunctionTag
    public CryptoCertificate certificateFromBase64(Object value) throws CertificateException {
        if (value instanceof String) {
            String base64 = (String)value;
            byte[] data = Base64BinString.Decode(base64);
            if (data == null || data.length == 0) {
                return null;
            }
            CertificateFactory instance = CertificateFactory.getInstance("X509");
            Certificate certificate = instance.generateCertificate(new ByteArrayInputStream(data));
            return new CryptoCertificate((Scriptable)this, certificate);
        }
        return null;
    }

    @SmartScriptableObject.FunctionTag
    public CryptoCertificate certificateFromBinary(Object value) throws CertificateException {
        if (value instanceof BinaryObject) {
            BinaryObject bin = (BinaryObject)value;
            byte[] data = bin.toByteArray();
            if (data == null || data.length == 0) {
                return null;
            }
            CertificateFactory instance = CertificateFactory.getInstance("X509");
            Certificate certificate = instance.generateCertificate(new ByteArrayInputStream(data));
            return new CryptoCertificate((Scriptable)this, certificate);
        }
        return null;
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject addCertificateToSignature(BinaryObject sign, BinaryObject cert) throws Exception {
        Collection certCollection;
        byte[] signData = null;
        if (sign != null) {
            signData = Arrays.copyOf(sign.getInternalBuffer(), sign.getSize());
        }
        if (signData == null) {
            return null;
        }
        byte[] certData = null;
        if (cert != null) {
            certData = Arrays.copyOf(cert.getInternalBuffer(), cert.getSize());
        }
        if (certData == null) {
            return null;
        }
        CertificateFactory instance = CertificateFactory.getInstance("X509");
        Certificate certificate = instance.generateCertificate(new ByteArrayInputStream(certData));
        if (certificate == null) {
            return null;
        }
        CMSSignedData cms = new CMSSignedData(signData);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        CMSTypedData signedContent = cms.getSignedContent();
        gen.addCRLs(cms.getCRLs());
        gen.addSigners(cms.getSignerInfos());
        gen.addAttributeCertificates(cms.getAttributeCertificates());
        Store certs = cms.getCertificates();
        gen.addCertificates(certs);
        X509CertificateHolder holder = new X509CertificateHolder(certData);
        boolean addCertificate = true;
        if (certs != null && (certCollection = certs.getMatches(null)) != null) {
            BigInteger serialNumber = holder.getSerialNumber();
            for (X509CertificateHolder next : certCollection) {
                if (next == null || !next.getSerialNumber().equals(serialNumber)) continue;
                addCertificate = false;
                break;
            }
        }
        if (addCertificate) {
            gen.addCertificate(holder);
        }
        CMSSignedData generate = gen.generate((CMSTypedData)new CMSProcessableByteArray(signedContent == null ? null : (byte[])signedContent.getContent()), cms.isDetachedSignature());
        return new BinaryObject(generate.getEncoded());
    }

    @SmartScriptableObject.FunctionTag
    public CryptoSignatureInfo signatureInfo(BinaryObject sign) throws Exception {
        byte[] data = null;
        if (sign != null) {
            data = Arrays.copyOf(sign.getInternalBuffer(), sign.getSize());
        }
        if (data == null) {
            return null;
        }
        CryptoSignatureInfo info = new CryptoSignatureInfo((Scriptable)this);
        info.parse(data);
        return info;
    }

    @SmartScriptableObject.FunctionTag
    public License createLicense(String licKey) {
        License result = new License();
        if (licKey != null && !licKey.isEmpty()) {
            result.setLicenseContent(licKey);
        }
        return result;
    }

    static class ProxyAuthenticator
    extends Authenticator {
        private final String user;
        private final String password;

        public ProxyAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }

    private static class Responce
    extends SmartScriptableObject {
        private final int status;
        private final byte[] content;
        private final HttpURLConnection connection;
        Headers headers = null;

        private Responce(int status, byte[] content, HttpURLConnection connection) {
            this.status = status;
            this.content = content;
            this.connection = connection;
        }

        @Override
        public String getClassName() {
            return "Responce";
        }

        @SmartScriptableObject.PropertyTag
        public int getStatus() {
            return this.status;
        }

        @SmartScriptableObject.PropertyTag
        public boolean getOk() {
            return this.status >= 200 && this.status < 300;
        }

        @SmartScriptableObject.PropertyTag
        public BinaryObject getAsBinary() {
            return new BinaryObject(this.content);
        }

        @SmartScriptableObject.PropertyTag
        public String getAsString() {
            return new String(this.content, Charset.forName("UTF-8"));
        }

        @SmartScriptableObject.FunctionTag
        public String toString(Object codepage) {
            return new String(this.content, Charset.forName(codepage == null ? "UTF-8" : (String)codepage));
        }

        @SmartScriptableObject.FunctionTag
        public String header(String key) {
            return this.connection.getHeaderField(key);
        }

        @SmartScriptableObject.PropertyTag
        public Scriptable getHeaders() {
            if (this.headers != null) {
                return this.headers;
            }
            int index = 0;
            Headers result = new Headers();
            while (true) {
                String key;
                String val;
                String value;
                if ((value = (val = this.connection.getHeaderField(index))) == null) {
                    value = "";
                }
                if ((key = this.connection.getHeaderFieldKey(index)) != null) {
                    result.putConst(key, result, value);
                }
                if (key == null && val == null) break;
                ++index;
            }
            this.headers = result;
            return result;
        }
    }

    private class Request
    extends SmartScriptableObject {
        private Headers headers = new Headers();
        private ByteArrayOutputStream content;
        private final KeyStoreInfo keyStore;
        private final CertStoreInfo trustStore;
        private Charset charset = Charset.forName("UTF-8");

        public Request(Scriptable scope, KeyStoreInfo keyStore, CertStoreInfo trustStore) {
            this.setParentScope(scope);
            this.keyStore = keyStore;
            this.trustStore = trustStore;
            Request.putConstProperty(this, "headers", this.headers);
        }

        @Override
        public String getClassName() {
            return "HttpsRequest";
        }

        @SmartScriptableObject.FunctionTag
        public void setEncoding(Object codepage) {
            this.charset = Charset.forName(codepage == null ? "UTF-8" : (String)codepage);
        }

        @SmartScriptableObject.FunctionTag
        public void write(Object data) throws Exception {
            byte[] value = CryptoUtils.dataAsBytes(data, this.charset);
            if (value == null) {
                return;
            }
            if (this.content == null) {
                this.content = new ByteArrayOutputStream();
            }
            this.content.write(value);
            this.content.flush();
        }

        private void setupConnectionHeaders(HttpURLConnection con) {
            for (Object name : this.headers.getIds()) {
                Object v = this.headers.get(name);
                if (v == null) continue;
                con.setRequestProperty(name.toString(), v.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @SmartScriptableObject.FunctionTag
        public Responce post(String url) throws MalformedURLException, IOException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException {
            HttpURLConnection con = this.initConnection(url);
            con.setRequestMethod("POST");
            this.setupConnectionHeaders(con);
            OutputStream output = null;
            if (this.content == null) return this.initResponce(con);
            con.setDoOutput(true);
            try {
                output = con.getOutputStream();
                output.write(this.content.toByteArray());
                output.flush();
                if (output == null) return this.initResponce(con);
            }
            catch (Throwable throwable) {
                if (output == null) throw throwable;
                try {
                    output.close();
                    throw throwable;
                }
                catch (IOException ex1) {
                    Core.logger.log(AsmoLogger.Level.ERROR, null, ex1);
                }
                throw throwable;
            }
            try {
                output.close();
                return this.initResponce(con);
            }
            catch (IOException ex1) {
                Core.logger.log(AsmoLogger.Level.ERROR, null, ex1);
            }
            return this.initResponce(con);
        }

        @SmartScriptableObject.FunctionTag
        public Responce get(String url) throws MalformedURLException, IOException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException {
            HttpURLConnection con = this.initConnection(url);
            con.setRequestMethod("GET");
            this.setupConnectionHeaders(con);
            return this.initResponce(con);
        }

        private HttpURLConnection initConnection(String url) throws MalformedURLException, IOException, NoSuchAlgorithmException, KeyStoreException, NoSuchProviderException, CertificateException, UnrecoverableKeyException, KeyManagementException {
            HttpURLConnection con = (HttpURLConnection)NetLibrary.openConnection(new URL(url));
            if ((this.keyStore != null || this.trustStore != null) && con instanceof HttpsURLConnection) {
                KeyManagerFactory kmf;
                SSLContext sslContext = SSLContext.getInstance(CryptoLibrary.PROTOKOL_TLS);
                KeyManagerFactory keyManagerFactory = kmf = this.keyStore != null ? this.keyStore.getKeyManagerFactory(CryptoLibrary.ALGORITM_TLS, this.keyStore.keyPassword) : null;
                if (this.trustStore == null) {
                    throw new IllegalArgumentException("\u041d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435 \u0434\u043e\u0432\u0435\u0440\u0435\u043d\u043d\u044b\u0445 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0432");
                }
                TrustManagerFactory tmf = this.trustStore.getTrustManagerFactory(CryptoLibrary.ALGORITM_TLS);
                HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostName, SSLSession sslSession) {
                        String sessionHostName = sslSession.getPeerHost();
                        boolean result = hostName.equals(sessionHostName);
                        if (!result) {
                            Core.logger.log(AsmoLogger.Level.WARN, String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0438\u043c\u0435\u043d\u0438 \u0445\u043e\u0441\u0442\u0430 '%s' \u0434\u043b\u044f \u0443\u0437\u043b\u0430 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f '%s'", hostName, sessionHostName), new Object[0]);
                        }
                        return result;
                    }
                };
                ((HttpsURLConnection)con).setHostnameVerifier(hostnameVerifier);
                sslContext.init(kmf == null ? null : kmf.getKeyManagers(), tmf.getTrustManagers(), null);
                ((HttpsURLConnection)con).setSSLSocketFactory(sslContext.getSocketFactory());
            }
            return con;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Responce initResponce(HttpURLConnection con) throws IOException {
            int responseCode = con.getResponseCode();
            byte[] responceBody = null;
            InputStream inputStream = null;
            try {
                inputStream = responseCode >= 200 && responseCode < 300 ? con.getInputStream() : con.getErrorStream();
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                byte[] arr = new byte[1024];
                if (inputStream != null) {
                    int length;
                    while ((length = inputStream.read(arr)) != -1) {
                        buf.write(arr, 0, length);
                    }
                }
                buf.flush();
                responceBody = buf.toByteArray();
                buf.close();
                if (inputStream == null) return new Responce(responseCode, responceBody, con);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException ex1) {
                    Core.logger.log(AsmoLogger.Level.ERROR, null, ex1);
                }
                throw throwable;
            }
            try {
                inputStream.close();
                return new Responce(responseCode, responceBody, con);
            }
            catch (IOException ex1) {
                Core.logger.log(AsmoLogger.Level.ERROR, null, ex1);
            }
            return new Responce(responseCode, responceBody, con);
        }
    }

    static class Headers
    extends ScriptableObject {
        Headers() {
        }

        @Override
        public String getClassName() {
            return "Headers";
        }
    }

    private static class CertStoreInfo
    extends CryptoStore {
        public CertStoreInfo(Scriptable scope, String storeFile, Object storePassword) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
            super(scope, "CertStore", storeFile, storePassword);
        }

        @Override
        public String getClassName() {
            return "CertStore";
        }
    }

    private static class KeyStoreInfo
    extends CryptoStore {
        private String keyPassword = null;

        public KeyStoreInfo(Scriptable scope, String storeType, Object storePassword, Object keyPassword) throws KeyStoreException, NoSuchProviderException, IOException, NoSuchAlgorithmException, CertificateException {
            super(scope, storeType, null, storePassword);
            this.keyPassword = keyPassword instanceof String && !((String)keyPassword).isEmpty() ? (String)keyPassword : null;
        }

        @Override
        public String getClassName() {
            return "KeyStore";
        }

        @SmartScriptableObject.FunctionTag
        public CryptoPrivateKey getPrivateKey(String aliasName, Object keyPassword) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
            char[] pass = keyPassword instanceof String && !((String)keyPassword).isEmpty() ? ((String)keyPassword).toCharArray() : null;
            PrivateKey pk = (PrivateKey)this.keyStore.getKey(aliasName, pass);
            return pk == null ? null : new CryptoPrivateKey((Scriptable)this, pk);
        }
    }

    private class CryptoSignatureInfo
    extends SmartScriptableObject {
        private byte[] signedData = null;
        private ArrayList<CryptoSignerInfo> signers = new ArrayList();
        ReadOnlyArray certificates;

        public CryptoSignatureInfo(Scriptable scope) {
            this.setParentScope(scope);
        }

        @Override
        public String getClassName() {
            return "SignatureInfo";
        }

        @SmartScriptableObject.PropertyTag
        public BinaryObject getData() {
            return this.signedData == null ? null : new BinaryObject(this.signedData);
        }

        @SmartScriptableObject.PropertyTag
        public int getSignerCount() {
            return this.signers.size();
        }

        @SmartScriptableObject.FunctionTag
        public CryptoSignerInfo signer(int index) {
            if (index < 0 || index >= this.signers.size()) {
                return null;
            }
            return this.signers.get(index);
        }

        @SmartScriptableObject.PropertyTag
        public NativeArray getCertificates() {
            return this.certificates;
        }

        public void parse(byte[] signData) throws Exception {
            Collection certCollection;
            Store certs;
            CMSSignedData cms = new CMSSignedData(signData);
            if (!cms.isDetachedSignature()) {
                Object content = cms.getSignedContent().getContent();
                assert (content instanceof byte[]);
                this.signedData = (byte[])content;
            }
            if ((certs = cms.getCertificates()) != null && (certCollection = certs.getMatches(null)) != null) {
                Iterator it = certCollection.iterator();
                this.certificates = new ReadOnlyArray(0L);
                while (it.hasNext()) {
                    X509CertificateHolder next = (X509CertificateHolder)it.next();
                    if (next == null) continue;
                    this.certificates._put(this.certificates.size(), (Scriptable)this.certificates, (Object)new BinaryObject(next.getEncoded()));
                }
            }
            for (Object next : cms.getSignerInfos()) {
                if (!(next instanceof SignerInformation)) continue;
                CryptoSignerInfo signer = new CryptoSignerInfo(this, cms);
                signer.init((SignerInformation)next);
                this.signers.add(signer);
            }
        }
    }

    private class CryptoSignerInfo
    extends SmartScriptableObject {
        private Store<X509CertificateHolder> certs;
        private byte[] certificate;
        private double signTime = 0.0;
        private String signId = "";
        private ReadOnlyArray signedAttributes;
        private ReadOnlyArray unsignedAttributes;

        public CryptoSignerInfo(Scriptable scope, CMSSignedData cms) {
            this.setParentScope(scope);
            if (cms != null) {
                this.certs = cms.getCertificates();
            }
        }

        @Override
        public String getClassName() {
            return "SignerInfo";
        }

        @SmartScriptableObject.PropertyTag
        public double getSignTime() {
            return this.signTime;
        }

        @SmartScriptableObject.PropertyTag
        public String getSignId() {
            return this.signId;
        }

        @SmartScriptableObject.PropertyTag
        public BinaryObject getCertificate() {
            return this.certificate == null ? null : new BinaryObject(this.certificate);
        }

        @SmartScriptableObject.PropertyTag
        public NativeArray getSignedAttributes() {
            return this.signedAttributes;
        }

        private ReadOnlyArray createAttributes(AttributeTable attributes) throws IOException {
            int size = attributes == null ? 0 : attributes.size();
            ReadOnlyArray result = null;
            if (size > 0) {
                result = new ReadOnlyArray(size);
                for (Object key : attributes.toHashtable().keySet()) {
                    if (!(key instanceof ASN1ObjectIdentifier)) continue;
                    ASN1ObjectIdentifier identifier = (ASN1ObjectIdentifier)key;
                    String id = identifier.getId();
                    assert (id != null);
                    Attribute value = attributes.get(new ASN1ObjectIdentifier(id));
                    assert (value != null);
                    ASN1Encodable[] values = value.getAttributeValues();
                    assert (values != null && values.length == 1);
                    result._put(id, (Scriptable)result, (Object)new BinaryObject(values[0].toASN1Primitive().getEncoded()));
                }
            }
            return result;
        }

        @SmartScriptableObject.PropertyTag
        public NativeArray getUnsignedAttributes() {
            return this.unsignedAttributes;
        }

        public void init(SignerInformation signer) throws Exception {
            Collection certCollection;
            ASN1Primitive primitive;
            Object attValue;
            SignerId sid = signer.getSID();
            String hex = CryptoUtils.bytesToHex(sid.getSerialNumber().toByteArray());
            if (!hex.isEmpty()) {
                this.signId = hex;
            }
            this.signedAttributes = this.createAttributes(signer.getSignedAttributes());
            Object object = attValue = this.signedAttributes == null ? null : this.signedAttributes.get("1.2.840.113549.1.9.5", (Scriptable)this.signedAttributes);
            if (attValue instanceof BinaryObject && (primitive = ASN1Primitive.fromByteArray((byte[])((BinaryObject)attValue).toByteArray())) instanceof ASN1UTCTime) {
                this.signTime = DateTime.fromUnixTime(((ASN1UTCTime)primitive).getDate().getTime());
            }
            if (this.certs != null && (certCollection = this.certs.getMatches((Selector)signer.getSID())) != null && certCollection.iterator().hasNext()) {
                this.certificate = ((X509CertificateHolder)certCollection.iterator().next()).getEncoded();
            }
            this.unsignedAttributes = this.createAttributes(signer.getUnsignedAttributes());
            if (this.certificate == null && this.unsignedAttributes != null) {
                DLSequence sec;
                Enumeration enumObjects;
                ASN1Primitive primitive2;
                Object att = this.unsignedAttributes.get("1.2.840.113549.1.9.16.2.23");
                ASN1Primitive aSN1Primitive = primitive2 = att instanceof BinaryObject ? ASN1Primitive.fromByteArray((byte[])((BinaryObject)att).toByteArray()) : null;
                if (primitive2 instanceof DLSequence && (enumObjects = (sec = (DLSequence)primitive2).getObjects()).hasMoreElements()) {
                    Object nextObject = enumObjects.nextElement();
                    assert (nextObject instanceof ASN1Encodable);
                    ASN1Encodable encodable = (ASN1Encodable)nextObject;
                    this.certificate = encodable.toASN1Primitive().getEncoded();
                }
            }
        }
    }

    private static class ReadOnlyArray
    extends NativeArray {
        ReadOnlyArray(long lengthArg) {
            super(lengthArg);
        }

        void _put(String id, Scriptable start, Object value) {
            super.put(id, start, value);
        }

        void _put(int index, Scriptable start, Object value) {
            super.put(index, start, value);
        }

        @Override
        public void put(String id, Scriptable start, Object value) {
        }

        @Override
        public void put(int index, Scriptable start, Object value) {
        }

        @Override
        public void delete(int index) {
        }
    }
}

