/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.collections.IntegerHash;
import inform.agent.db.Row;
import inform.agent.replication.SelectableDataset;

public class CursorParents {
    final SelectableDataset explicitParent;
    final IntegerHash<Data> implicitParents = new IntegerHash();

    public CursorParents(SelectableDataset explicitParent) {
        this.explicitParent = explicitParent;
    }

    public void add(SelectableDataset dataset) throws InformException {
        if (this.explicitParent != null && dataset.getId() == this.explicitParent.getId() || this.implicitParents.get(dataset.getId()) != null) {
            throw new InformException("\u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0434\u0432\u0430\u0436\u0434\u044b");
        }
        this.implicitParents.add(new Data(dataset));
    }

    public boolean hasExplicitParent() {
        return this.explicitParent != null;
    }

    public boolean selectParent() throws Exception {
        return this.selectDatasource(this.explicitParent);
    }

    public Row getParentRow() throws InformException {
        if (this.explicitParent == null || !this.explicitParent.isCurrentRowAvailable()) {
            return null;
        }
        return this.explicitParent.getCurrentRow();
    }

    public boolean select(SelectableDataset dataset) throws Exception {
        if (this.explicitParent != null && this.explicitParent.getId() == dataset.getId()) {
            return this.selectDatasource(this.explicitParent);
        }
        Data data = this.implicitParents.get(dataset.getId());
        if (data != null) {
            return this.selectDatasource(data.dataset);
        }
        return this.selectDatasource(dataset);
    }

    public Row getRow(SelectableDataset dataset) throws InformException {
        if (this.explicitParent != null && this.explicitParent.getId() == dataset.getId()) {
            return this.explicitParent.getCurrentRow();
        }
        Data data = this.implicitParents.get(dataset.getId());
        if (data != null) {
            return data.dataset.getCurrentRow();
        }
        return dataset.getCurrentRow();
    }

    public SelectableDataset getSelectedDataset(SelectableDataset dataset) throws Exception {
        if (this.explicitParent != null && this.explicitParent.getId() == dataset.getId()) {
            return this.selectDatasource(this.explicitParent) ? this.explicitParent : null;
        }
        Data data = this.implicitParents.get(dataset.getId());
        if (data != null) {
            return this.selectDatasource(data.dataset) ? data.dataset : null;
        }
        return this.selectDatasource(dataset) ? dataset : null;
    }

    private boolean selectDatasource(SelectableDataset dataset) throws Exception {
        if (dataset == null) {
            return false;
        }
        if (!dataset.isSelected()) {
            dataset.executeSelect();
            return dataset.next();
        }
        return dataset.isCurrentRowAvailable();
    }

    static class Data
    implements IntegerHash.Entry {
        final SelectableDataset dataset;

        Data(SelectableDataset dataset) {
            this.dataset = dataset;
        }

        @Override
        public int key() {
            return this.dataset.getId();
        }
    }
}

