/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.Collections;
import inform.adt.collections.ObjectIntegerMap;
import inform.adt.collections.ObjectSet;
import inform.agent.ServerSideHost;
import inform.agent.db.types.DataType;
import inform.agent.web.JSON;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DataTypesLibrary
extends ScriptableObject {
    private static String[] availJSFunctionsNames = new String[]{"makeStruct", "makeStructProfiler"};
    private ServerSideHost ssHost;

    public DataTypesLibrary(Scriptable scope, ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.setParentScope(scope);
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
        for (DataType t : DataType.values()) {
            DataTypesLibrary.putConstProperty(this, t.name(), t.getTypeId());
        }
        DataTypesLibrary.putConstProperty(this, "PRIMARYKEY", DataType.PRIMARY_KEY.getTypeId());
        DataTypesLibrary.putConstProperty(this, "DATETIME", DataType.DATE_TIME.getTypeId());
        DataTypesLibrary.putConstProperty(this, "BIGNUMBER", DataType.BIG_NUMBER.getTypeId());
        DataTypesLibrary.putConstProperty(this, "METATREENODE", DataType.METATREE_NODE.getTypeId());
        DataTypesLibrary.putConstProperty(this, "REFERENCE", DataType.DIRECTORY.getTypeId());
        DataTypesLibrary.putConstProperty(this, "TIMESPAN", DataType.INTERVAL.getTypeId());
    }

    @Override
    public String getClassName() {
        return "DataTypes";
    }

    public String toString() {
        return this.getClassName();
    }

    public Function makeStruct(String typename, NativeArray fieldnames) {
        String[] fields = new String[(int)fieldnames.getLength()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = (String)fieldnames.get(i);
        }
        final Struct.Descriptor descriptor = new Struct.Descriptor(typename, fields);
        return new BaseFunction(this, null){

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return new Struct(descriptor);
            }

            @Override
            public boolean hasInstance(Scriptable instance) {
                return instance instanceof Struct;
            }

            @Override
            public Object getDefaultValue(Class<?> hint) {
                if (hint == String.class) {
                    return this.toString();
                }
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public String toString() {
                StringBuilder result = new StringBuilder();
                result.append("[class ").append(descriptor.typename).append("([");
                Collections.join(descriptor.fieldnames, ',', result);
                return result.append("])]").toString();
            }
        };
    }

    public Function makeStructProfiler() {
        return new BaseFunction(this, null){
            Map<Object, Integer> profile;
            {
                this.profile = new HashMap<Object, Integer>();
                this.defineProperty("profile", this.profile, 5);
            }

            @Override
            public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                return new Delegator((Scriptable)args[0]){
                    final ObjectSet profiler_flags;
                    {
                        this.profiler_flags = new ObjectSet();
                    }

                    @Override
                    public Object get(String name, Scriptable start) {
                        this.profile(name);
                        return super.get(name, start);
                    }

                    @Override
                    public Object get(int index, Scriptable start) {
                        this.profile(index);
                        return super.get(index, start);
                    }

                    @Override
                    public boolean has(String name, Scriptable start) {
                        this.profile(name);
                        return super.has(name, start);
                    }

                    @Override
                    public boolean has(int index, Scriptable start) {
                        this.profile(index);
                        return super.has(index, start);
                    }

                    @Override
                    public void put(String name, Scriptable start, Object value) {
                        this.profile(name);
                        super.put(name, start, value);
                    }

                    @Override
                    public void put(int index, Scriptable start, Object value) {
                        this.profile(index);
                        super.put(index, start, value);
                    }

                    @Override
                    public Scriptable getPrototype() {
                        this.profile("prototype");
                        return super.getPrototype();
                    }

                    @Override
                    public void setPrototype(Scriptable prototype) {
                        this.profile("prototype");
                        super.setPrototype(prototype);
                    }

                    private void profile(Object key) {
                        if (!this.profiler_flags.add(key)) {
                            return;
                        }
                        Integer v = profile.get(key);
                        profile.put(key, v == null ? 1 : v + 1);
                    }
                };
            }

            @Override
            public Object getDefaultValue(Class<?> hint) {
                if (hint == String.class) {
                    return this.toString();
                }
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    private static class Struct
    implements Scriptable {
        final Descriptor descriptor;
        final Object[] values;

        public Struct(Descriptor descriptor) {
            this.descriptor = descriptor;
            this.values = new Object[descriptor.size()];
        }

        @Override
        public String getClassName() {
            return this.descriptor.typename;
        }

        private int name2index(String name) {
            return this.descriptor.name2index(name);
        }

        @Override
        public Object get(String name, Scriptable start) {
            int idx = this.name2index(name);
            if (idx == -1) {
                throw ScriptRuntime.typeError1("msg.prop.not.found", name);
            }
            return this.values[idx];
        }

        @Override
        public Object get(int index, Scriptable start) {
            throw ScriptRuntime.typeError1("msg.prop.not.found", Integer.toString(index));
        }

        @Override
        public boolean has(String name, Scriptable start) {
            return this.name2index(name) != -1;
        }

        @Override
        public boolean has(int index, Scriptable start) {
            return false;
        }

        @Override
        public void put(String name, Scriptable start, Object value) {
            int idx = this.name2index(name);
            if (idx == -1) {
                throw ScriptRuntime.typeError1("msg.prop.not.found", name);
            }
            this.values[idx] = value;
        }

        @Override
        public void put(int index, Scriptable start, Object value) {
            throw ScriptRuntime.typeError1("msg.prop.not.found", Integer.toString(index));
        }

        @Override
        public void delete(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void delete(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Scriptable getPrototype() {
            return null;
        }

        @Override
        public void setPrototype(Scriptable prototype) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Scriptable getParentScope() {
            return null;
        }

        @Override
        public void setParentScope(Scriptable parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] getIds() {
            return this.descriptor.fieldnames;
        }

        @Override
        public Object getDefaultValue(Class<?> hint) {
            if (hint == String.class) {
                return this.toString();
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean hasInstance(Scriptable instance) {
            return false;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("[object ").append(this.getClassName()).append("({");
            for (int i = 0; i < this.descriptor.fieldnames.length; ++i) {
                if (i != 0) {
                    result.append(',');
                }
                result.append(this.descriptor.fieldnames[i]).append(':').append(JSON.toString(this.values[i]));
            }
            return result.append("})]").toString();
        }

        static class Descriptor
        extends ObjectIntegerMap {
            final String typename;
            final String[] fieldnames;

            Descriptor(String typename, String[] fieldnames) {
                this.typename = typename;
                this.fieldnames = fieldnames;
                for (int i = 0; i < fieldnames.length; ++i) {
                    this.put(fieldnames[i], i);
                }
            }

            int name2index(String name) {
                return this.get(name, -1);
            }
        }
    }
}

