/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.LittleEndian;
import inform.adt.NumberConverter;
import inform.adt.ObjectSizer;
import inform.adt.collections.IntegerSet;
import inform.adt.collections.ObjectHash;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.RequestStatistics;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.GeneratedSql;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.LinkField;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.RowsetRandomAccessor;
import inform.agent.db.ScrollableRowset;
import inform.agent.db.SearchParameters;
import inform.agent.db.SelectionKey;
import inform.agent.db.SelectionRowset;
import inform.agent.db.SortDirection;
import inform.agent.db.SortingField;
import inform.agent.db.SqlGenerator;
import inform.agent.db.TableDescriptor;
import inform.agent.db.VirtualRowset;
import inform.agent.db.connect.DatabaseConnection;
import inform.agent.db.connect.DatabaseType;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.filters.RowFilter;
import inform.agent.db.types.ValueCaster;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.mtd.nodes.TableNode;
import inform.agent.replication.SelectableDataset;
import inform.agent.scripts.ActualPoint;
import inform.agent.scripts.ComponentHeader;
import inform.agent.scripts.ComponentsFactory;
import inform.agent.scripts.CursorParents;
import inform.agent.scripts.Dataset;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.DatasourceCursor;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.DatasourceFieldList;
import inform.agent.scripts.Decimal;
import inform.agent.scripts.DirectoryField;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ServerSideComponent;
import inform.agent.scripts.ServerTableExecutor;
import inform.agent.scripts.SqlStatement;
import inform.agent.scripts.Task;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryDescriptor;
import inform.agent.scripts.sql.QuerySortFieldList;
import inform.agent.scripts.stat.DatasourceProfile;
import inform.agent.scripts.util.DatasourceRelation;
import inform.common.Exceptions;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

@ObjectSizer.HintSharedProperties(value={"parentScopeObject", "slots", "firstAdded", "lastAdded", "lastAccess"})
public class Datasource
extends ServerSideComponent
implements RowsetRandomAccessor,
Dataset {
    private static final String MESSAGE_UNREGISTER_BATCHMODE_DATASOURCE_EXCEPTION = "\u041d\u0435\u043b\u044c\u0437\u044f \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c \u043f\u043e\u0442\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0433\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0443 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 %s \u0441 \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u043c\u0438 \u0434\u0430\u043d\u043d\u044b\u043c\u0438";
    private static final int TAG_FS_ROOT_TABLE = 1;
    private static final int TAG_SS_DATASOURCE_TABLE_ID = 40;
    private static final int TAG_SS_DATASOURCE_SEARCH_ID = 41;
    private static final int TAG_SS_DATASOURCE_PARAMS = 42;
    static final int TAG_SS_DATASOURCE_SORT_ASCENDING = 44;
    static final int TAG_SS_DATASOURCE_SORT_DESCENDING = 45;
    static final int TAG_SS_DATASOURCE_SORT_FIELD = 43;
    private static final int TAG_SS_DATASOURCE_SCROLLABLE = 46;
    private static final int TAG_SS_DATASOURCE_KIND = 47;
    private static final int TAG_SS_DATASOURCE_BLOB_RECEIVING = 48;
    private static final int TAG_SS_DATASOURCE_LOCK_RECORDS = 49;
    private static final int TAG_SS_DATASOURCE_RELATIONS = 50;
    private static final int TAG_SS_CHILD_DATASOURCE = 51;
    private static final int TAG_SS_SORTING = 52;
    private static final int TAG_SS_DATALINK = 53;
    private static final int TAG_SS_ACTUAL_POINT_VALUE = 54;
    private static final int TAG_SS_ACTUAL_POINT_PARAM = 55;
    private static final int TAG_SS_DATASOURCE_NULL_SORT_KIND = 57;
    private static final int TAG_SS_SKIP_LOCKED_RECORDS = 58;
    private static final int TAG_SS_DATASOURCE_RETURNED_FIELDS = 59;
    private static final Object S_UNKNOWN = null;
    private static final Object S_SORTED = "\u043e\u0442\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d";
    private final String[] availJSFunctionsNames = new String[]{"toString", "execute", "next", "prev", "sort", "setSortColumns", "filterKey", "markDelete", "reset", "filterRange", "clearFilter", "append", "edit", "close", "locate", "locateByID", "findLinkField", "fieldByID", "fieldByName", "findFieldByName", "tryExecute", "compact", "select", "createCursor", "reuseRecord", "generateRecordID", "sqlRepresentation"};
    private final DatasourceFieldList fields = new DatasourceFieldList();
    private final ParametersList parameters = new ParametersList();
    private double searchId;
    private int searchNodeType = -1;
    private Rowset.Kind kind = Rowset.Kind.FORWARD_ONLY;
    private boolean lockRecords = false;
    private boolean skipLockedRecords = false;
    private String errorMessage = null;
    private IntegerSet returnedFields = null;
    private Rowset rows;
    private TableDescriptor tableDesc;
    private final ArrayList<SortingField> sorting = new ArrayList();
    private boolean sortingHasStringFields;
    private int blobReceiving = 0;
    private Object wellSorted = S_UNKNOWN;
    private boolean internStrings;
    private int dataLinkId = 0;
    private LinkDescriptor linkDescriptor = null;
    private final DatasourceProfile profile;
    private int fetchLimit = -1;
    private int nullSortKind = 0;
    final BitSet disabledGenerators = new BitSet();
    public final SSContext.Component ssContext;
    private boolean batchMode = false;
    private List<Row> insertedRows;
    private PreparedStatement batchInsertStatement;
    private ObjectHash<SelectionRowset> selectionCache = null;
    private final ExecuteContext executeContext = new ExecuteContext();
    private DatasourceRelation relation = null;
    private SelectionRowset selectionRowset = null;
    @ObjectSizer.HintShared
    private Datasource parentDatasource = null;
    private ActualPoint actualPoint = null;

    private void initScriptPropertys() throws InformException {
        this.parameters.setParentScope(this);
        Datasource.putConstProperty(this, "parameters", this.parameters);
        this.defineProperty("forwardOnly", this.getClass(), 0);
        this.defineProperty("recordID", Datasource.class, 1);
        this.defineProperty("recordCount", Datasource.class, 1);
        this.defineProperty("recordLoaded", Datasource.class, 1);
        this.defineProperty("lockRecords", this.getClass(), 0);
        this.defineProperty("skipLockedRecords", this.getClass(), 0);
        this.defineProperty("errorText", Datasource.class, 1);
        this.defineProperty("fetchLimit", Datasource.class, 0);
        this.defineProperty("batchMode", Datasource.class, 0);
        this.defineFunctionProperties(this.availJSFunctionsNames, this.getClass(), 0);
        Datasource.putConstProperty(this, "queryID", this.searchId);
        if (this.tableDesc != null) {
            Datasource.putConstProperty(this, "tableID", this.tableDesc.getNodeId());
            Datasource.putConstProperty(this, "rawName", this.getRawName());
            Datasource.putConstProperty(this, "rawTableName", this.getTableRawName());
            Datasource.putConstProperty(this, "fields", this.fields.values().toArray());
            Datasource.putConstProperty(this, "database", this.getTask().getDatabase(this.tableDesc.getDbId()));
        }
    }

    Datasource(SSContext parentContext, Task task, Scriptable parentScope, ComponentHeader header, TaggedReader reader) throws IOException, InformException {
        super(task, parentScope, header);
        this.ssContext = parentContext == null ? null : new SSContext.Component(parentContext, 4);
        this.load(reader);
        if (this.ssContext != null) {
            this.ssContext.id = this.getId();
            this.ssContext.script = this.getName();
        }
        for (SortingField sf : this.sorting) {
            DatasourceField field;
            int fieldId = sf.getField().getId();
            if (fieldId == -1 || (field = this.fields.get(fieldId)) == null) continue;
            field.sorting = true;
        }
        this.initScriptPropertys();
        this.profile = this.tableDesc != null ? task.addDatasourceProfile(this.getId(), this.tableDesc.getNodeId(), this.searchId, task.nodeId()) : null;
    }

    public Datasource(SSContext parentContext, Task task, double tableId, double searchId) throws IOException, InformException {
        super(task, "dynamic_datasource", 0);
        Node tableNode;
        SSContext.Component component = this.ssContext = parentContext == null ? null : new SSContext.Component(parentContext, 4);
        if (this.ssContext != null) {
            this.ssContext.id = this.getId();
        }
        this.searchId = searchId;
        if (searchId != 0.0) {
            double rootTableId = this.loadFilterNode(searchId);
            if ((Double.isNaN(tableId) || tableId == 0.0) && !Double.isNaN(rootTableId)) {
                tableId = rootTableId;
            }
        }
        if (!((tableNode = MtdEngine.getValidNode(tableId)) instanceof TableNode)) {
            throw new InformException("\u0423\u0437\u0435\u043b " + tableNode.toLogString() + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0435\u0439");
        }
        this.tableDesc = ((TableNode)tableNode).getDescriptor();
        for (FieldDescriptor fd : this.tableDesc.getFields()) {
            DatasourceField field = DatasourceField.createInstance(this.ssContext, this, fd, task, this);
            if (field == null) continue;
            this.fields.put(field);
        }
        if (searchId != 0.0) {
            this.loadExtraFields(searchId);
        }
        this.initScriptPropertys();
        this.profile = this.tableDesc != null ? task.addDatasourceProfile(this.getId(), this.tableDesc.getNodeId(), searchId, task.nodeId()) : null;
    }

    private String getTableRawName() {
        return this.tableDesc.getRawName();
    }

    private String getRawName() throws InformException {
        if (this.tableDesc.getRawName() == null) {
            return null;
        }
        if (this.tableDesc.getRawName().contains(".")) {
            return this.tableDesc.getRawName();
        }
        String scheme = this.tableDesc.getDatabaseDescriptor().getScheme();
        return scheme == null ? this.tableDesc.getRawName() : String.format("%s.%s", scheme, this.tableDesc.getRawName());
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.tableDesc;
    }

    @Override
    public DatasourceRelation getRelation() {
        return this.relation;
    }

    @Override
    public boolean hasRelation() {
        return this.relation != null && !this.relation.isEmpty() || this.parentDatasource != null && this.dataLinkId != 0;
    }

    private void loadExtraFields(double nodeId) throws IOException {
    }

    private double loadFilterNode(double nodeId) throws IOException, InformException {
        Node info = MtdEngine.getValidNode(nodeId);
        TaggedReader reader = new TaggedReader(MtdEngine.getNodeContent(nodeId));
        if (info.getType() == 48) {
            return this.loadSSTable(reader);
        }
        return this.loadSearch(reader);
    }

    private double loadSearch(TaggedReader reader) throws IOException, InformException {
        int tag;
        double rootTableId = Double.NaN;
        do {
            tag = reader.getNextTag();
            switch (tag) {
                case 1: {
                    reader.skip();
                    rootTableId = reader.getDouble(151);
                    break;
                }
                case 153: {
                    this.parameters.load(this.getTask().getConstants(), new TaggedReader(reader.getSubStream()), Core.serverTimeZoneHost);
                }
            }
        } while (tag != 0);
        return rootTableId;
    }

    private double loadSSTable(TaggedReader reader) throws IOException, InformException {
        int tag;
        double rootTableId = Double.NaN;
        do {
            tag = reader.getNextTag();
            block0 : switch (tag) {
                case 6: {
                    reader.skip();
                    rootTableId = reader.getDouble(151);
                    break;
                }
                case 152: {
                    TaggedReader stream = new TaggedReader(reader.getSubStream());
                    while (stream.getNextTag() != 0) {
                        if (stream.getCurrentTag() != 153) continue;
                        this.parameters.load(this.getTask().getConstants(), new TaggedReader(stream.getSubStream()), Core.serverTimeZoneHost);
                        break block0;
                    }
                    break block0;
                }
            }
        } while (tag != 0);
        return rootTableId;
    }

    @Override
    public void notifySortingFieldModified(Object field) {
        assert (field != null);
        this.wellSorted = field;
    }

    private void mustBeWellSorted() throws InformException {
        if (this.wellSorted == S_UNKNOWN) {
            if (this.sortingHasStringFields && this.rows instanceof ScrollableRowset && !((ScrollableRowset)this.rows).wellSorted(this.sorting)) {
                this.rows.sort(this.sorting);
            }
            this.wellSorted = S_SORTED;
            return;
        }
        if (this.wellSorted != S_SORTED) {
            String cause = this.wellSorted instanceof DatasourceField ? "\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f " + ((DatasourceField)this.wellSorted).desc.getRawName() : this.wellSorted.toString();
            throw new InformException(String.format("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 %s (\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0430 \u0438\u0437-\u0437\u0430 %s)", this, cause));
        }
    }

    public boolean locateRecord(Object ... args) throws InformException {
        if (this.rows == null) {
            this.throwNoDataAvailable();
        }
        this.mustBeWellSorted();
        return Datasource.locateRecord(this, this.rows, this.fields, this.sorting, args);
    }

    static boolean locateRecord(Datasource datasource, Rowset rows, DatasourceFieldList fields, ArrayList<SortingField> sorting, Object ... args) throws InformException {
        assert (rows != null);
        if (args.length % 2 != 0) {
            throw new InformException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c [field, value, field, value, ...]");
        }
        if (datasource.profile != null) {
            datasource.profile.addAccessCount();
        }
        RowFilter[] locatingFilters = new RowFilter[args.length / 2];
        for (int i = 0; i < args.length; i += 2) {
            int sIdx = i / 2;
            SortingField sf = sIdx >= sorting.size() ? null : sorting.get(sIdx);
            DatasourceField filterField = sf == null ? null : fields.get(sf.getField().getId());
            FieldDescriptor filterDescriptor = null;
            if (filterField != null) {
                filterDescriptor = filterField.getDescriptor();
            } else if (sf != null && sf.getField().getId() == -1) {
                filterDescriptor = sf.getField();
            }
            if (filterDescriptor == null || filterField != args[i]) {
                throw new InformException("\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u043e\u043b\u0435\u0439 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c \u0441\u043e \u0441\u043f\u0438\u0441\u043a\u043e\u043c \u043f\u043e\u043b\u0435\u0439 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438");
            }
            Object value = args[i + 1];
            locatingFilters[sIdx] = RowFilter.create(rows, datasource.nullSortKind, filterDescriptor, value, value, sf.getDirection() == SortDirection.ASCENDING);
        }
        rows.setRecordIndex(-1);
        return rows.locate(locatingFilters);
    }

    private void throwNotPositionedError() throws InformException {
        throw new InformException(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a %s \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d \u043d\u0430 \u0437\u0430\u043f\u0438\u0441\u0438.", this.toString()));
    }

    private void throwNoDataAvailable() throws InformException {
        throw new InformException(String.format("\u0412\u044b\u0431\u043e\u0440\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 %s \u043d\u0435 \u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0430.", this.toString()));
    }

    @Override
    public Row getCurrentRow() throws InformException {
        Row curRow = null;
        if (this.rows != null) {
            curRow = this.rows.getCurrentRow();
            if (curRow == null) {
                this.throwNotPositionedError();
            }
        } else {
            this.throwNoDataAvailable();
        }
        return curRow;
    }

    @Override
    protected void afterLoad() throws InformException {
        super.afterLoad();
        if (this.relation != null) {
            this.relation.afterLoad(this.getTask());
            if (this.relation.isEmpty()) {
                this.relation = null;
            }
        }
    }

    @Override
    protected void readTag(int tag, TaggedReader reader) throws IOException, InformException {
        double tableId = 0.0;
        block0 : switch (tag) {
            case 40: {
                reader.skip();
                this.tableDesc = TableDescriptor.get(reader.getDouble());
                for (FieldDescriptor fd : this.tableDesc.getFields()) {
                    DatasourceField field = DatasourceField.createInstance(this.ssContext, this, fd, this.getTask(), this);
                    if (field == null) continue;
                    this.fields.put(field);
                }
                break;
            }
            case 41: {
                reader.skip();
                this.searchId = reader.getDouble(151);
                tableId = this.loadFilterNode(this.searchId);
                this.tableDesc = TableDescriptor.get(tableId);
                this.loadExtraFields(this.searchId);
                break;
            }
            case 42: {
                reader.skip();
                this.parameters.loadParametersBindings(this.getTask().getParameters(), this.getTask().getConstants(), new TaggedReader(reader.getSubStream()));
                break;
            }
            case 43: {
                int fieldId = reader.getInt();
                SortDirection sortDirection = SortDirection.ASCENDING;
                switch (reader.getNextTag()) {
                    case 44: {
                        sortDirection = SortDirection.ASCENDING;
                        break;
                    }
                    case 45: {
                        sortDirection = SortDirection.DESCENDING;
                    }
                }
                FieldDescriptor fieldToSort = this.tableDesc.getFieldDescriptor(fieldId);
                if (fieldToSort == null) break;
                SortingField sf = new SortingField(fieldToSort, sortDirection, this.tableDesc.getDatabaseDescriptor().getDatabaseType().caps(), this.nullSortKind);
                this.sortingHasStringFields |= sf.stringField;
                this.sorting.add(sf);
                break;
            }
            case 57: {
                this.nullSortKind = reader.getInt();
                break;
            }
            case 46: {
                this.kind = Rowset.Kind.SCROLLABLE;
                break;
            }
            case 47: {
                this.kind = Rowset.Kind.fromInt(reader.getInt());
                break;
            }
            case 48: {
                this.blobReceiving = reader.getInt();
                break;
            }
            case 49: {
                this.lockRecords = true;
                break;
            }
            case 58: {
                this.skipLockedRecords = true;
                break;
            }
            case 50: {
                this.relation = new DatasourceRelation(this);
                this.relation.load(reader.getSubStreamReader());
                break;
            }
            case 51: {
                ServerSideComponent child = ComponentsFactory.readAndCreateComponent(this.ssContext, this.getTask(), this.getParentScope(), 51, reader);
                if (child == null) break;
                if (child instanceof Datasource) {
                    ((Datasource)child).setParentDatasource(this);
                }
                this.task.getComponents().add(child);
                ScriptableObject.putConstProperty(this.getParentScope(), child.getName(), child);
                break;
            }
            case 52: {
                this.sorting.clear();
                this.sortingHasStringFields = false;
                TaggedReader stream = reader.getSubStreamReader();
                int[] fieldPath = null;
                SortDirection direction = SortDirection.ASCENDING;
                while (stream.next()) {
                    block23 : switch (stream.getCurrentTag()) {
                        case 43: {
                            fieldPath = LittleEndian.toIntArray(stream.getRaw());
                            switch (stream.getNextTag()) {
                                case 44: {
                                    direction = SortDirection.ASCENDING;
                                    break block23;
                                }
                                case 45: {
                                    direction = SortDirection.DESCENDING;
                                }
                            }
                        }
                    }
                    if (fieldPath == null || fieldPath.length <= 0) continue;
                    FieldDescriptor fieldToSort = this.tableDesc.getFieldDescriptor(fieldPath[0]);
                    if (fieldToSort == null) break block0;
                    SortingField sf = new SortingField(this.tableDesc, this.nullSortKind, fieldToSort, direction, fieldPath);
                    this.sortingHasStringFields |= sf.stringField;
                    this.sorting.add(sf);
                }
                break;
            }
            case 53: {
                this.dataLinkId = reader.getInt();
                break;
            }
            case 54: {
                this.actualPoint = new ActualPoint();
                this.actualPoint.setValue(reader.getDouble());
                break;
            }
            case 55: {
                int paramId = reader.getInt();
                Parameter value = this.task.getParameters().get(paramId);
                if (value == null) break;
                this.actualPoint = new ActualPoint();
                this.actualPoint.setBindValue(value);
                break;
            }
            case 59: {
                this.returnedFields = new IntegerSet();
                TaggedReader stream = reader.getStreamReader();
                while (stream.next()) {
                    this.returnedFields.add(stream.getInt());
                }
                break;
            }
        }
    }

    @Override
    public String getClassName() {
        return "Datasource";
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.fields.contains(name)) {
            return super.get(name, start);
        }
        return this.fields.get(name);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.fields.contains(name)) {
            if (value instanceof DatasourceField) {
                this.fields.get(name).assignField((DatasourceField)value);
            } else if (value instanceof SqlStatement.ResultField) {
                this.fields.get(name).assign(value);
            } else if (value instanceof Decimal) {
                DatasourceField f = this.fields.get(name);
                if (f == null) {
                    super.put(name, start, value);
                } else {
                    f.assign(value);
                }
            }
        } else {
            super.put(name, start, value);
        }
    }

    public String toString() {
        return String.format("%s %s(table:%s query:%s) %s", this.getClassName(), this.getName(), NumberConverter.doubleToString(this.tableDesc.getNodeId()), NumberConverter.doubleToString(this.searchId), this.getTask().toString());
    }

    public boolean isVirtual() {
        return this.kind == Rowset.Kind.VIRTUAL || this.searchNodeType == 48;
    }

    public int getRecordCount() {
        if (this.rows != null) {
            return this.rows.getRecordCount();
        }
        return -1;
    }

    private DatabaseConnection prepareStatistics() throws Exception {
        double nodeId = 0.0;
        DatabaseConnection conn = null;
        if (this.tableDesc != null) {
            double dbId = this.tableDesc.getDbId();
            nodeId = this.tableDesc.getNodeId();
            conn = this.getTask().getDBManager().getConnection(dbId, "stat::execute::" + nodeId);
        }
        if (conn != null) {
            conn.getDescriptor().statistics.pickDatasource(nodeId);
        }
        return conn;
    }

    private void closeStatistics(DatabaseConnection conn) {
        if (conn != null) {
            conn.getDescriptor().statistics.pickDatasource(0.0);
        }
    }

    public void execute() throws Exception {
        DatabaseConnection conn = this.prepareStatistics();
        this.errorMessage = null;
        try {
            this.executeContext.kind = this.kind;
            this.executeContext.sorting = this.sorting;
            this.executeContext.linkRelation = this.adjustDatalink();
            this.parameters.applyDatasourceBindings(this.getTask(), null);
            this.internalExecute();
        }
        catch (SQLException ex) {
            this.errorMessage = ex.getMessage();
            throw InformException.wrap(ex);
        }
        finally {
            this.closeStatistics(conn);
        }
    }

    public boolean tryExecute() throws Exception {
        this.errorMessage = null;
        try {
            this.executeContext.kind = this.kind;
            this.executeContext.linkRelation = null;
            this.executeContext.sorting = this.sorting;
            this.parameters.applyDatasourceBindings(this.getTask(), null);
            this.internalExecute();
            return true;
        }
        catch (SQLException ex) {
            Core.logger.error(null, ex);
            this.errorMessage = Exceptions.extractSqlException(ex);
            return false;
        }
    }

    public void select() throws Exception {
        DatabaseConnection conn = this.prepareStatistics();
        try {
            this.executeSelect();
        }
        finally {
            this.closeStatistics(conn);
        }
    }

    @Override
    public boolean isSelected() {
        if (this.isCurrentRowAvailable()) {
            return true;
        }
        return this.selectionRowset != null && this.selectionRowset.get() != null;
    }

    @Override
    public Rowset executeSelect() throws Exception {
        this.internalSelect();
        if (this.rows != null) {
            this.rows.reset();
            this.rows.clearFilter();
            if (this.rows != null && this.relation != null && !this.relation.isEmpty()) {
                this.relation.createFilter(this.rows);
            }
        }
        return this.rows;
    }

    private byte[] adjustDatalink() throws Exception {
        if (this.dataLinkId == 0 || this.parentDatasource == null) {
            return null;
        }
        if (this.linkDescriptor == null) {
            this.linkDescriptor = this.parentDatasource.tableDesc.getLinkList().getLink(this.dataLinkId);
            if (this.linkDescriptor == null) {
                throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u0432\u044f\u0437\u0438(" + this.dataLinkId + ") \u0432 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435 " + this.toString());
            }
        }
        if (!this.parentDatasource.isCurrentRowAvailable()) {
            return null;
        }
        Row row = this.parentDatasource.getCurrentRow();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        for (LinkField field : this.linkDescriptor.getFields()) {
            out.putInt32(10, field.getFieldId());
            block0 : switch (field.getLinkType()) {
                case 2: {
                    DatasourceField parentField = this.parentDatasource.findfieldById(field.getLinkField());
                    if (parentField == null) {
                        out.putEmpty(12);
                        break;
                    }
                    LinkDescriptor.generateRelationFieldValue(out, parentField);
                    break;
                }
                case 3: {
                    out.putDouble(14, row.getId());
                    break;
                }
                case 1: {
                    switch (field.getConstType()) {
                        case INTEGER: 
                        case BOOLEAN: {
                            out.putInt32(13, (int)field.getNumberValue());
                            break block0;
                        }
                        case FLOAT: 
                        case INTERVAL: 
                        case DIRECTORY: 
                        case METATREE_NODE: {
                            out.putDouble(14, field.getNumberValue());
                            break block0;
                        }
                        case DATE_TIME: {
                            out.putDouble(16, field.getNumberValue());
                            break block0;
                        }
                        case STRING: 
                        case BIG_NUMBER: {
                            out.putAnsi(15, field.getStringValue());
                            break block0;
                        }
                    }
                    out.putEmpty(12);
                    break;
                }
                case 4: {
                    out.putEmpty(12);
                }
            }
        }
        out.flush();
        return data.toByteArray();
    }

    private byte[] adjustDatalink(CursorParents parents) throws Exception {
        if (this.dataLinkId == 0 || this.parentDatasource == null) {
            return null;
        }
        if (this.linkDescriptor == null) {
            this.linkDescriptor = this.parentDatasource.tableDesc.getLinkList().getLink(this.dataLinkId);
            if (this.linkDescriptor == null) {
                throw new InformException("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u0432\u044f\u0437\u0438(" + this.dataLinkId + ") \u0432 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0435 " + this.toString());
            }
        }
        if (!parents.selectParent()) {
            return null;
        }
        Row row = parents.getParentRow();
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        TaggedWriter out = new TaggedWriter(data);
        for (LinkField field : this.linkDescriptor.getFields()) {
            out.putInt32(10, field.getFieldId());
            block0 : switch (field.getLinkType()) {
                case 2: {
                    DatasetField parentField = parents.explicitParent.findfieldById(field.getLinkField());
                    if (parentField == null || parentField.getIsNull()) {
                        out.putEmpty(12);
                        break;
                    }
                    switch (parentField.getDataType()) {
                        case INTEGER: 
                        case BOOLEAN: {
                            out.putInt32(13, (int)parentField.getAsNumber());
                            break block0;
                        }
                        case FLOAT: 
                        case INTERVAL: 
                        case DIRECTORY: 
                        case METATREE_NODE: {
                            out.putDouble(14, parentField.getAsNumber());
                            break block0;
                        }
                        case DATE_TIME: {
                            out.putDouble(14, parentField.getAsNumber());
                            break block0;
                        }
                        case STRING: 
                        case BIG_NUMBER: {
                            out.putAnsi(15, parentField.getAsString());
                            break block0;
                        }
                    }
                    out.putEmpty(12);
                    break;
                }
                case 3: {
                    out.putDouble(14, row.getId());
                    break;
                }
                case 1: {
                    switch (field.getConstType()) {
                        case INTEGER: 
                        case BOOLEAN: {
                            out.putInt32(13, (int)field.getNumberValue());
                            break block0;
                        }
                        case FLOAT: 
                        case INTERVAL: 
                        case DIRECTORY: 
                        case METATREE_NODE: {
                            out.putDouble(14, field.getNumberValue());
                            break block0;
                        }
                        case DATE_TIME: {
                            out.putDouble(16, field.getNumberValue());
                            break block0;
                        }
                        case STRING: 
                        case BIG_NUMBER: {
                            out.putAnsi(15, field.getStringValue());
                            break block0;
                        }
                    }
                    out.putEmpty(12);
                    break;
                }
                case 4: {
                    out.putEmpty(12);
                }
            }
        }
        out.flush();
        return data.toByteArray();
    }

    private void internalSelect() throws Exception {
        Rowset rowset;
        if (this.selectionCache == null) {
            this.selectionCache = new ObjectHash();
        }
        if (this.dataLinkId != 0 && this.parentDatasource != null) {
            if (!this.parentDatasource.isSelected()) {
                this.parentDatasource.executeSelect();
            }
            if (!this.parentDatasource.isCurrentRowAvailable()) {
                return;
            }
        }
        byte[] linkRelation = this.adjustDatalink();
        this.parameters.applyDatasourceBindings(this.getTask(), null);
        SelectionKey selectionKey = SelectionKey.build(this.parameters, linkRelation);
        if (this.selectionRowset != null && this.selectionRowset.get() != null && selectionKey.equals(this.selectionRowset.key())) {
            return;
        }
        SelectionRowset selection = this.selectionCache.get(selectionKey);
        if (selection != null && (rowset = (Rowset)selection.get()) != null) {
            if (this.rows != null && rowset != this.rows) {
                this.rows.close();
                this.rows = null;
            }
            this.getTask().getHost().idle();
            this.rows = rowset;
            this.rows.setBatchMode(this.batchMode);
            this.selectionRowset = selection;
            return;
        }
        this.executeContext.kind = this.kind == Rowset.Kind.FORWARD_ONLY ? Rowset.Kind.SCROLLABLE : this.kind;
        this.executeContext.linkRelation = linkRelation;
        this.executeContext.sorting = this.relation == null || this.relation.isEmpty() ? this.sorting : this.relation.createSortKey(this.sorting);
        if (this.rows != null && this.executeContext.kind == Rowset.Kind.VIRTUAL && this.searchId == 0.0) {
            if (!this.executeContext.sorting.isEmpty()) {
                this.rows.sort(this.executeContext.sorting);
            }
            this.wellSorted = S_SORTED;
            this.task.getHost().idle();
        } else {
            this.internalExecute();
        }
        if (this.rows != null) {
            selection = new SelectionRowset(this.rows, selectionKey);
            this.selectionCache.add(selection);
        }
        this.selectionRowset = selection;
    }

    private DatasourceCursor internalCreateCursor(CursorParents parents) throws Exception {
        if (this.searchId == 0.0 && this.isVirtual()) {
            return new DatasourceCursor(this, this.rows, this.sorting, this.sortingHasStringFields);
        }
        if (this.selectionCache == null) {
            this.selectionCache = new ObjectHash();
        }
        if (this.dataLinkId != 0 && parents.hasExplicitParent() && !parents.selectParent()) {
            return new DatasourceCursor(this, null, this.sorting, this.sortingHasStringFields);
        }
        byte[] linkRelation = this.adjustDatalink(parents);
        this.parameters.applyDatasourceBindings(this.task, parents);
        SelectionKey selectionKey = SelectionKey.build(this.parameters, linkRelation);
        Rowset cursorRows = null;
        SelectionRowset selection = this.selectionCache.get(selectionKey);
        if (selection != null) {
            cursorRows = (Rowset)selection.get();
        }
        ExecuteContext executeContext = new ExecuteContext();
        if (cursorRows == null) {
            executeContext.kind = this.kind == Rowset.Kind.FORWARD_ONLY ? Rowset.Kind.SCROLLABLE : this.kind;
            executeContext.linkRelation = linkRelation;
            executeContext.sorting = this.relation == null || this.relation.isEmpty() ? this.sorting : this.relation.createSortKey(this.sorting);
            cursorRows = this.internalCreateRowset(executeContext);
            if (executeContext.sortingGeneration == GeneratedSql.Sorting.FAILED) {
                cursorRows.sort(executeContext.sorting);
            }
        }
        if (cursorRows != null) {
            this.selectionCache.add(new SelectionRowset(cursorRows, selectionKey));
        }
        return new DatasourceCursor(this, cursorRows, executeContext.sorting, this.sortingHasStringFields);
    }

    public static Object createCursor(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        if (thisObj == null || !(thisObj instanceof Datasource)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        Datasource ds = (Datasource)thisObj;
        ds.task.getHost().idle();
        DatabaseConnection conn = ds.prepareStatistics();
        SelectableDataset explicitParent = ds.parentDatasource;
        if (ds.parentDatasource != null) {
            for (Object obj : args) {
                if (!(obj instanceof SelectableDataset)) {
                    throw new InformException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u0443\u0440\u0441\u043e\u0440\u043e\u043c \u0438\u043b\u0438 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445");
                }
                SelectableDataset dataset = (SelectableDataset)obj;
                if (dataset.getId() != ds.parentDatasource.getId()) continue;
                explicitParent = dataset;
                break;
            }
        }
        CursorParents parents = new CursorParents(explicitParent);
        for (Object obj : args) {
            SelectableDataset dataset = (SelectableDataset)obj;
            if (dataset.getId() == ds.parentDatasource.getId()) continue;
            parents.add(dataset);
        }
        DatasourceCursor result = ds.internalCreateCursor(parents);
        ds.closeStatistics(conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rowset internalCreateRowset(ExecuteContext executeContext) throws IOException, InformException, SQLException, IllegalAccessException, InstantiationException, InvocationTargetException {
        ServerSideHost ssh = this.task.getHost();
        RequestStatistics.Value old = ssh.rqstat();
        try {
            RequestStatistics.Value n = new RequestStatistics.Value();
            n.reset(-1, ssh.getUserID(), this.searchId != 0.0 ? this.searchId : this.tableDesc.getNodeId());
            n.ownerId = this.task.nodeId();
            ssh.rqstat(n);
            long st = System.currentTimeMillis();
            try {
                Rowset rowset = this._internalCreateRowset(executeContext);
                n.apply(System.currentTimeMillis() - st);
                return rowset;
            }
            catch (Throwable throwable) {
                n.apply(System.currentTimeMillis() - st);
                throw throwable;
            }
        }
        finally {
            ssh.rqstat(old);
        }
    }

    private GeneratedSql createGeneratedSql(ExecuteContext executeContext, double databaseId, int databaseType) throws InformException {
        return this.createGeneratedSql(executeContext, databaseId, databaseType, -1);
    }

    private GeneratedSql createGeneratedSql(ExecuteContext executeContext, double databaseId, int databaseType, int methodCode) throws InformException {
        ArrayList<SortingField> sorting = executeContext.sorting;
        if (this.searchId != 0.0 && this.searchNodeType < 0) {
            Node nodeInfo = MtdEngine.getNode(this.searchId);
            if (nodeInfo == null) {
                throw new InformException("\u0423\u0437\u0435\u043b \u043f\u043e\u0438\u0441\u043a\u0430(" + NumberConverter.doubleToString(this.searchId) + ") \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            switch (nodeInfo.getType()) {
                case 19: 
                case 48: 
                case 49: {
                    this.searchNodeType = nodeInfo.getType();
                    break;
                }
                default: {
                    throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 \u043f\u043e\u0438\u0441\u043a\u0430(" + NumberConverter.doubleToString(this.searchId) + ")");
                }
            }
        }
        GeneratedSql sql = null;
        if (this.searchId != 0.0 && this.searchNodeType == 49) {
            try {
                QueryDescriptor descriptor = new QueryDescriptor(this.parameters, this.task.getHost(), this.task.getConstantsContent(), this.getTitle(), this.getId(), new QuerySortFieldList(sorting), this.nullSortKind);
                if (this.returnedFields != null && !this.returnedFields.empty()) {
                    descriptor.setReturnedFields(this.returnedFields);
                }
                descriptor.setBlobReceiving(this.blobReceiving);
                descriptor.setFetchLimit(this.fetchLimit);
                sql = Query.generateSqlText(this.searchId, this.task.getHost(), descriptor, null);
            }
            catch (Exception e) {
                throw InformException.wrap(e);
            }
        }
        try {
            SqlGenerator.Method generationMethod = SqlGenerator.Method.DEFAULT;
            SqlGenerator sqlGen = new SqlGenerator(this.task.getHost(), this.task.getHost());
            sqlGen.setDatabaseId(databaseId);
            sqlGen.setTableId(this.tableDesc.getNodeId());
            sqlGen.setRelation(executeContext.linkRelation);
            sqlGen.setConstantsContent(this.task.getConstantsContent(), this.task.getHost());
            if (this.searchId != 0.0) {
                sqlGen.setSearchId(this.searchId);
                byte[] searchContent = MtdEngine.getNodeContent(this.searchId);
                generationMethod = methodCode >= 0 ? SqlGenerator.Method.fromInt(methodCode) : SqlGenerator.extractSearchGenerationMethod(searchContent);
                sqlGen.setSearchContent(searchContent);
                SearchParameters params = sqlGen.getParameters();
                for (Parameter p : this.parameters.values()) {
                    params.addParameter(p.getId());
                    if (p.getIsIgnored()) {
                        params.setIgnored();
                        continue;
                    }
                    SearchParameters.addParamValue(p, params);
                }
            } else if (this.actualPoint != null && this.actualPoint.isAssigned()) {
                sqlGen.setActualPoint(this.actualPoint.getValue());
            }
            if (sorting != null) {
                for (SortingField f : sorting) {
                    f.transferTo(sqlGen);
                }
            }
            sqlGen.setGenerateFileBlobs(true);
            sqlGen.setBlobReceiving(this.blobReceiving);
            sqlGen.setFetchLimit(this.fetchLimit);
            sqlGen.setNullSortKind(this.nullSortKind);
            if (this.returnedFields != null && !this.returnedFields.empty()) {
                sqlGen.setReturnedFields(this.returnedFields);
            }
            sql = sqlGen.getGeneratedSql(generationMethod, databaseType);
        }
        catch (Exception e) {
            throw InformException.wrap(e);
        }
        if (sql.isHasError()) {
            throw new InformException(sql.getError() + " \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a: " + this.toString()).detail(sql.getErrorDetailing());
        }
        sql.setTableId(this.tableDesc.getNodeId());
        sql.setSearchId(this.searchId);
        sql.setScriptName(this.getName());
        sql.setUid(this.getId());
        sql.setOwnerId(this.task.getHost().getNodeID());
        sql.setUserId(this.task.getHost().getUserID());
        sql.setLockRecords(this.lockRecords, this.skipLockedRecords);
        if (this.lockRecords && sql.isDisabledLockRecords()) {
            throw new InformException("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u043f\u0440\u0435\u0434\u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u0434\u043b\u044f \u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u043e\u043a \u0437\u0430\u043f\u0438\u0441\u0435\u0439").detail(this.toString());
        }
        return sql;
    }

    private Rowset _internalCreateRowset(ExecuteContext executeContext) throws IOException, InformException, SQLException, IllegalAccessException, InvocationTargetException, InstantiationException {
        executeContext.sortingGeneration = GeneratedSql.Sorting.DEFAULT;
        Rowset rows = null;
        ArrayList<SortingField> sorting = executeContext.sorting;
        Rowset.Kind kind = executeContext.kind;
        if (this.profile != null) {
            this.profile.addRequestCount();
        }
        if (this.searchId != 0.0) {
            if (this.searchNodeType < 0) {
                Node nodeInfo = MtdEngine.getNode(this.searchId);
                if (nodeInfo == null) {
                    throw new InformException("\u0423\u0437\u0435\u043b \u043f\u043e\u0438\u0441\u043a\u0430(" + NumberConverter.doubleToString(this.searchId) + ") \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                }
                switch (nodeInfo.getType()) {
                    case 19: 
                    case 48: 
                    case 49: {
                        this.searchNodeType = nodeInfo.getType();
                        break;
                    }
                    default: {
                        throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0443\u0437\u043b\u0430 \u043f\u043e\u0438\u0441\u043a\u0430(" + NumberConverter.doubleToString(this.searchId) + ")");
                    }
                }
            }
            if (this.ssContext != null) {
                this.ssContext.nodeId = this.searchId;
            }
        } else if (this.ssContext != null) {
            this.ssContext.nodeId = this.tableDesc.getNodeId();
        }
        if (this.ssContext != null) {
            this.ssContext.tableId = this.tableDesc.getNodeId();
        }
        if (this.searchId != 0.0 && this.searchNodeType == 48) {
            kind = Rowset.Kind.VIRTUAL;
            ServerTableExecutor executor = new ServerTableExecutor(this.ssContext, this.searchId, this.task.getHost(), this.task.getDBManager(), this.task, this.nullSortKind);
            executor.setConstantsContent(this.task.getConstantsContent());
            SearchParameters params = new SearchParameters();
            for (Parameter p : this.parameters.values()) {
                params.addParameter(p.getId());
                if (p.getIsIgnored()) {
                    params.setIgnored();
                    continue;
                }
                SearchParameters.addParamValue(p, params);
            }
            executor.setBindedParametersContent(params.getData());
            rows = executor.execute();
            rows.setBatchMode(this.batchMode);
            if (rows instanceof ScrollableRowset && !sorting.isEmpty()) {
                executeContext.sortingGeneration = GeneratedSql.Sorting.FAILED;
            }
            rows.setDisabledGenerators(this.disabledGenerators);
            return rows;
        }
        GeneratedSql sql = this.createGeneratedSql(executeContext, 0.0, -500);
        if (sql.getSortingGeneration() == GeneratedSql.Sorting.FAILED && kind == Rowset.Kind.FORWARD_ONLY) {
            kind = Rowset.Kind.SCROLLABLE;
        }
        long start = System.currentTimeMillis();
        rows = this.task.getDBManager().createRowset(this.ssContext, this.tableDesc, sql, kind, this.blobReceiving, this.nullSortKind, "JS:DataSource::internalExecute", this.internStrings, this.profile);
        long duration = System.currentTimeMillis() - start;
        if (duration > 30000L) {
            Core.logger.warn("! long time({}) sql request {}", (Object)duration, (Object)this.toString());
        }
        executeContext.sortingGeneration = sql.getSortingGeneration();
        this.task.getHost().idle();
        rows.setDisabledGenerators(this.disabledGenerators);
        return rows;
    }

    private void internalExecute() throws IOException, SQLException, InterruptedException, InformException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this.selectionRowset = null;
        if (this.rows != null) {
            this.rows.close();
            this.rows = null;
        }
        this.wellSorted = S_UNKNOWN;
        this.task.getHost().idle();
        ArrayList<SortingField> sorting = this.executeContext.sorting;
        if (this.searchId == 0.0 && this.isVirtual()) {
            this.rows = new VirtualRowset(this.ssContext, this.getTask().getDBManager(), this.tableDesc, this.blobReceiving);
            this.rows.setBatchMode(this.batchMode);
            this.rows.setDisabledGenerators(this.disabledGenerators);
            this.wellSorted = S_SORTED;
            this.task.getHost().idle();
            return;
        }
        this.rows = this.internalCreateRowset(this.executeContext);
        this.rows.setBatchMode(this.batchMode);
        if (this.executeContext.sortingGeneration == GeneratedSql.Sorting.FAILED) {
            this.rows.sort(sorting);
            this.wellSorted = S_SORTED;
        }
        this.getTask().getHost().idle();
    }

    @Override
    public boolean next() throws Exception {
        this.getTask().getHost().idle();
        if (this.rows == null) {
            return false;
        }
        DatabaseConnection conn = this.prepareStatistics();
        boolean result = this.rows.next();
        this.closeStatistics(conn);
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
        return result;
    }

    @Override
    public Dataset getParentDataset() {
        return this.parentDatasource;
    }

    @Override
    public int getDataLinkId() {
        return this.dataLinkId;
    }

    public boolean prev() throws Exception, InformException, InterruptedException {
        this.getTask().getHost().idle();
        if (this.kind == Rowset.Kind.FORWARD_ONLY) {
            throw new InformException("\u0412\u043a\u043b\u044e\u0447\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u043e\u0439 \u0432\u044b\u0431\u043e\u0440\u043a\u0438");
        }
        if (this.rows == null) {
            return false;
        }
        DatabaseConnection conn = this.prepareStatistics();
        boolean result = this.rows.prev();
        this.closeStatistics(conn);
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
        return result;
    }

    public void doSetSortColumns(DatasourceField ... args) throws InformException {
        this.sorting.clear();
        this.sorting.ensureCapacity(args.length);
        this.sortingHasStringFields = false;
        for (DatasourceField f : this.fields.values()) {
            f.sorting = false;
        }
        for (DatasourceField f : args) {
            if (f == null) continue;
            SortingField sf = null;
            if (f.getParentScope() instanceof DirectoryField) {
                int[] fieldPath = null;
                ArrayList<Integer> fieldPathList = new ArrayList<Integer>();
                DatasourceField ref = f;
                while (ref.getParentScope() instanceof DirectoryField) {
                    fieldPathList.add(ref.getDescriptor().getId());
                    ref = (DatasourceField)ref.getParentScope();
                }
                fieldPathList.add(ref.getDescriptor().getId());
                fieldPath = new int[fieldPathList.size()];
                int i = fieldPathList.size() - 1;
                for (Integer n : fieldPathList) {
                    fieldPath[i--] = n;
                }
                if (fieldPath != null && fieldPath.length > 0) {
                    FieldDescriptor fieldToSort = this.tableDesc.getFieldDescriptor(fieldPath[0]);
                    if (fieldToSort == null) continue;
                    sf = new SortingField(this.tableDesc, this.nullSortKind, fieldToSort, f.sortDirection, fieldPath);
                }
            } else {
                sf = new SortingField(f.getDescriptor(), f.sortDirection, this.tableDesc.getDatabaseDescriptor().getDatabaseType().caps(), this.nullSortKind);
            }
            if (sf == null) continue;
            this.sortingHasStringFields |= sf.stringField;
            this.sorting.add(sf);
            f.sorting = true;
        }
        this.wellSorted = "\u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 setSortColumns";
    }

    static void checkValueType(DatasourceField field, Object value, String funcName) throws InformException {
        if (value != null && !field.isCompatibleValue(value)) {
            throw new InformException(funcName + field + " \u043d\u0435 \u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e \u0441 " + value.getClass() + " \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: " + value);
        }
    }

    public void doFilterKey(Object ... args) throws InformException {
        if (this.rows == null) {
            this.throwNoDataAvailable();
        }
        this.mustBeWellSorted();
        this.rows.clearFilter();
        this.rows.reset();
        if (args.length % 2 != 0) {
            throw new InformException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b filterKey \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c (field, value [, field, value, ...])");
        }
        for (int i = 0; i < args.length; i += 2) {
            DatasourceField filterField;
            int sIdx = i / 2;
            SortingField sf = sIdx >= this.sorting.size() ? null : this.sorting.get(sIdx);
            DatasourceField datasourceField = filterField = sf == null ? null : this.fields.get(sf.getField().getId());
            if (filterField == null || filterField != args[i]) {
                throw new InformException("\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u043e\u043b\u0435\u0439 \u0434\u043b\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c \u0441\u043e \u0441\u043f\u0438\u0441\u043a\u043e\u043c \u043f\u043e\u043b\u0435\u0439 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438");
            }
            Object value = args[i + 1];
            Datasource.checkValueType(filterField, value, "filterKey ");
            this.rows.filter(RowFilter.create(this.rows, this.nullSortKind, filterField.getDescriptor(), value, value, sf.getDirection() == SortDirection.ASCENDING));
        }
    }

    public void markDelete() throws InformException {
        Row r;
        if (this.rows == null) {
            this.throwNoDataAvailable();
        }
        if ((r = this.rows.getCurrentRow()) == null) {
            this.throwNotPositionedError();
        } else {
            r.markDelete();
        }
    }

    public void compact() throws Exception {
        if (this.rows == null || this.executeContext.kind == Rowset.Kind.FORWARD_ONLY) {
            return;
        }
        this.rows.compact();
        this.rows.clearFilter();
        if (this.rows != null && this.relation != null && !this.relation.isEmpty()) {
            this.relation.createFilter(this.rows);
        }
    }

    public void reset() throws InformException {
        if (this.executeContext.kind != null ? this.executeContext.kind == Rowset.Kind.FORWARD_ONLY : this.kind == Rowset.Kind.FORWARD_ONLY) {
            throw new InformException(String.format("\u0418\u0441\u0442\u043e\u0447\u043d\u0438\u043a %s \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043d\u0430 \u043e\u0434\u043d\u043e\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043d\u0443\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 \u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e reset", this.getName()));
        }
        if (this.rows == null) {
            this.throwNoDataAvailable();
        }
        this.rows.reset();
    }

    public void doFilterRange(Object ... args) throws InformException {
        if (this.rows == null) {
            this.throwNoDataAvailable();
        }
        this.mustBeWellSorted();
        Datasource.doFilterRange(this.rows, this.nullSortKind, this.fields, this.sorting, args);
    }

    static void doFilterRange(Rowset rows, int nullSortKind, DatasourceFieldList fields, ArrayList<SortingField> sorting, Object ... args) throws InformException {
        assert (rows != null);
        rows.clearFilter();
        rows.reset();
        if (args.length % 3 != 0) {
            throw new InformException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b filterRange \u0434\u043e\u043b\u0436\u0435\u043d\u044b \u0431\u044b\u0442\u044c (field, rangeStart, rangeEnd [, field, rangeStart, rangeEnd, ...])");
        }
        for (int i = 0; i < args.length; i += 3) {
            DatasourceField filterField;
            int sIdx = i / 3;
            SortingField sf = sIdx >= sorting.size() ? null : sorting.get(sIdx);
            DatasourceField datasourceField = filterField = sf == null ? null : fields.get(sf.getField().getId());
            if (filterField == null || filterField != args[i]) {
                throw new InformException("\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u043e\u043b\u0435\u0439 \u0434\u043b\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c \u0441\u043e \u0441\u043f\u0438\u0441\u043a\u043e\u043c \u043f\u043e\u043b\u0435\u0439 \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438");
            }
            Object rangeStart = args[i + 1];
            Object rangeEnd = args[i + 2];
            Datasource.checkValueType(filterField, rangeStart, "filterRange start ");
            Datasource.checkValueType(filterField, rangeEnd, "filterRange end ");
            rows.filter(RowFilter.create(rows, nullSortKind, filterField.getDescriptor(), rangeStart, rangeEnd, sf.getDirection() == SortDirection.ASCENDING));
        }
    }

    private static Object checkNumericValue(Object obj) {
        if (obj instanceof Integer) {
            return String.valueOf((Integer)obj);
        }
        if (obj instanceof Double) {
            return NumberConverter.doubleToString((Double)obj);
        }
        return obj;
    }

    public boolean getForwardOnly() {
        return this.kind == Rowset.Kind.FORWARD_ONLY;
    }

    public void setForwardOnly(boolean isForwardOnly) {
        if (this.kind == Rowset.Kind.VIRTUAL) {
            return;
        }
        this.kind = isForwardOnly ? Rowset.Kind.FORWARD_ONLY : Rowset.Kind.SCROLLABLE;
    }

    public int getFetchLimit() {
        return this.fetchLimit;
    }

    public void setFetchLimit(int fetchLimit) {
        this.fetchLimit = fetchLimit;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getInternStrings() {
        return this.internStrings;
    }

    public void setInternStrings(boolean v) {
        this.internStrings = v;
    }

    public String getErrorText() {
        return this.errorMessage;
    }

    public boolean getLockRecords() {
        return this.lockRecords;
    }

    public void setLockRecords(boolean lockRecords) {
        this.lockRecords = lockRecords;
    }

    public boolean getSkipLockedRecords() {
        return this.skipLockedRecords;
    }

    public void SkipLockedRecords(boolean skipLockedRecords) {
        this.skipLockedRecords = skipLockedRecords;
    }

    @Override
    public double getRecordID() throws InformException {
        if (this.rows == null) {
            return 0.0;
        }
        if (this.rows.getCurrentRow() == null) {
            return 0.0;
        }
        return this.rows.getCurrentRow().getId();
    }

    public void clearFilter() {
        if (this.rows != null) {
            this.rows.clearFilter();
        }
    }

    public DatasourceField fieldByName(String name) throws InformException {
        DatasourceField field = this.fields.get(name);
        if (field == null) {
            throw new InformException("\u041f\u043e\u043b\u0435 " + name + " \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 " + this.toString() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
        }
        return field;
    }

    public DatasourceField fieldByID(int id) throws InformException {
        DatasourceField field = this.fields.get(id);
        return field;
    }

    @Override
    public DatasourceField findfieldById(int fieldId) {
        return this.fields.get(fieldId);
    }

    @Override
    public void enableFieldValueGenerator(int fieldIndex, boolean value) {
        this.disabledGenerators.set(fieldIndex, !value);
    }

    public DatasourceField findFieldByName(String name) {
        return this.fields.get(name);
    }

    @Override
    public DatasetField findFieldPath(int[] path) throws InformException {
        if (path == null || path.length == 0) {
            return null;
        }
        DatasourceField field = this.findfieldById(path[0]);
        for (int i = 1; i < path.length && field != null; ++i) {
            int fieldId = path[i];
            if (!(field instanceof DirectoryField)) {
                field = null;
                break;
            }
            field = ((DirectoryField)field).getDirectoryField(fieldId);
        }
        return field;
    }

    public static Object append(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        Datasource self = (Datasource)thisObj;
        self.task.getHost().idle();
        if (self.rows == null) {
            self.rows = self.getTask().getDBManager().createEmptyRowset(self.ssContext, self.tableDesc, self.kind, self.blobReceiving, self.internStrings);
            self.rows.setDisabledGenerators(self.disabledGenerators);
            self.rows.setBatchMode(self.batchMode);
        }
        double rowId = args.length == 1 ? ValueCaster.toDouble(args[0]) : Core.generateId();
        self.rows.appendRow(rowId);
        if (self.batchMode) {
            assert (self.insertedRows != null);
            self.insertedRows.add(self.rows.getCurrentRow());
        }
        self.wellSorted = "\u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 append";
        return Undefined.instance;
    }

    public void edit(double rowId) throws InformException {
        if (this.rows == null) {
            this.rows = this.getTask().getDBManager().createEmptyRowset(this.ssContext, this.tableDesc, this.kind, this.blobReceiving, this.internStrings);
            this.rows.setDisabledGenerators(this.disabledGenerators);
            this.rows.setBatchMode(this.batchMode);
        }
        this.rows.editRow(rowId);
        this.wellSorted = "\u0432\u044b\u0437\u043e\u0432\u0430 \u043c\u0435\u0442\u043e\u0434\u0430 edit";
    }

    public void reuseRecord() throws InformException {
        this.getCurrentRow();
        this.rows.reuseRow();
    }

    public double generateRecordID() throws InformException {
        double id = Core.generateId();
        return id;
    }

    public static Object sqlRepresentation(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        Datasource self = (Datasource)thisObj;
        self.task.getHost().idle();
        double databaseId = 0.0;
        int methodCode = -1;
        int databaseType = -500;
        if (args.length >= 1) {
            databaseId = ValueCaster.toDouble(args[0]);
        }
        if (args.length >= 2) {
            methodCode = ValueCaster.toInt(args[1]);
        }
        if (args.length >= 3 && (databaseType = ValueCaster.toInt(args[2])) >= 0) {
            DatabaseType.get(databaseType);
        }
        ExecuteContext executeContext = new ExecuteContext();
        try {
            executeContext.kind = self.kind;
            executeContext.sorting = self.sorting;
            executeContext.linkRelation = self.adjustDatalink();
            self.parameters.applyDatasourceBindings(self.getTask(), null);
        }
        catch (Exception e) {
            throw InformException.wrap(e);
        }
        GeneratedSql sql = self.createGeneratedSql(executeContext, databaseId, databaseType, methodCode);
        if (sql == null) {
            return "";
        }
        return sql.formatInsensitiveSql(false);
    }

    public void close() throws InformException {
        this.internalClose();
        this.getTask().detach(this);
        if (this.batchInsertStatement != null) {
            this.batchInsertStatement.close();
        }
        this.batchInsertStatement = null;
    }

    void internalClose() throws InformException {
        if (this.rows != null) {
            this.rows.close();
        }
        this.rows = null;
        this.selectionRowset = null;
        if (this.selectionCache != null) {
            this.selectionCache.clear();
        }
        for (DatasourceField f : this.fields.values()) {
            if (!(f instanceof DirectoryField)) continue;
            ((DirectoryField)f).detachDirectoryRowset();
        }
    }

    @Override
    public AbstractConnectionManager getDBManager() {
        return this.getTask().getDBManager();
    }

    @Override
    public boolean isCurrentRowAvailable() {
        return this.rows != null && this.rows.getCurrentRow() != null;
    }

    public static Object locate(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (thisObj == null || !(thisObj instanceof Datasource)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        Datasource ds = (Datasource)thisObj;
        return ds.locateRecord(args);
    }

    public static Object filterKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (thisObj == null || !(thisObj instanceof Datasource)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        Datasource ds = (Datasource)thisObj;
        ds.doFilterKey(args);
        return null;
    }

    public static Object filterRange(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (thisObj == null || !(thisObj instanceof Datasource)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        Datasource ds = (Datasource)thisObj;
        ds.doFilterRange(args);
        return null;
    }

    public static Object setSortColumns(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (thisObj == null || !(thisObj instanceof Datasource)) {
            throw new InformException("this \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        DatasourceField[] fields = new DatasourceField[args.length];
        DatasourceField field = null;
        int i = 0;
        for (Object arg : args) {
            if (arg instanceof DatasourceField) {
                field = (DatasourceField)arg;
                field.sortDirection = SortDirection.ASCENDING;
                fields[i] = field;
                ++i;
                continue;
            }
            if (field == null || !(arg instanceof Boolean)) continue;
            boolean isAscending = (Boolean)arg;
            if (!isAscending) {
                field.sortDirection = SortDirection.DESCENDING;
            }
            field = null;
        }
        Datasource ds = (Datasource)thisObj;
        ds.doSetSortColumns(fields);
        return null;
    }

    static void doSort(RowsetAccessor ra, Rowset rows, TableDescriptor tableDesc, DatasourceFieldList fields, ArrayList<SortingField> sorting, Object ... args) throws InformException {
        if (args.length > 0) {
            for (DatasourceField f : fields.values()) {
                f.sorting = false;
            }
            sorting.clear();
            for (int i = 0; i < args.length; i += 2) {
                DatasourceField f;
                f = (DatasourceField)args[i];
                if (f.getRowsetAccessor() != ra) {
                    throw new InformException("\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e \u043f\u043e\u043b\u044f\u043c \u0438\u0437 \u044d\u0442\u043e\u0433\u043e \u0436\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430");
                }
                f.sorting = true;
                sorting.add(new SortingField(f.getDescriptor(), (Boolean)args[i + 1] != false ? SortDirection.ASCENDING : SortDirection.DESCENDING, tableDesc.getDatabaseDescriptor().getDatabaseType().caps(), ra.getNullSortKind()));
            }
        }
        if (sorting.isEmpty()) {
            throw new InformException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u043e\u043b\u044f \u0434\u043b\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438");
        }
        rows.sort(sorting);
    }

    public static void sort(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws InformException {
        if (args.length % 2 != 0) {
            throw new InformException("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c [field, bool, field, bool, ...]");
        }
        Datasource ds = (Datasource)thisObj;
        if (ds.rows == null) {
            ds.throwNoDataAvailable();
        }
        Datasource.doSort(ds, ds.rows, ds.tableDesc, ds.fields, ds.sorting, args);
        ds.wellSorted = S_SORTED;
    }

    public boolean isLoaded() {
        return this.rows != null;
    }

    public DatasourceField findLinkField(double tableID) throws InformException {
        return this.fields.findLink(tableID);
    }

    public boolean locateByID(double rowID) throws InformException {
        if (this.rows == null) {
            this.throwNoDataAvailable();
        }
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
        return this.rows.setRecord(rowID);
    }

    @Override
    public ServerSideHost getHost() {
        return this.getTask().getHost();
    }

    public boolean getRecordLoaded() throws InformException {
        if (this.rows == null || this.rows.getCurrentRow() == null) {
            this.throwNoDataAvailable();
        }
        return this.rows.getCurrentRow().isRowLoaded();
    }

    public Object getFields() {
        return Context.javaToJS(this.fields.values().toArray(), this);
    }

    @Override
    public String getTitle() {
        try {
            if (this._title == null) {
                Node info;
                if (this.searchId != 0.0) {
                    info = MtdEngine.getValidNode(this.searchId);
                    this._title = info.getName();
                }
                if (this._title == null && this.tableDesc != null) {
                    info = MtdEngine.getValidNode(this.searchId);
                    this._title = info.getName();
                }
                if (this._title == null) {
                    this._title = "";
                }
            }
        }
        catch (InformException ex) {
            Core.logger.error(null, ex);
        }
        return this._title;
    }

    @Override
    public boolean canRandomAccess() {
        return this.rows instanceof ScrollableRowset;
    }

    @Override
    public Row getRow(int recordIndex) {
        return this.rows == null ? null : (Row)this.rows.get(recordIndex);
    }

    @Override
    public int getRowsCount() {
        return this.rows == null ? 0 : this.rows.size();
    }

    @Override
    public int getCurrentRowIndex() {
        return this.rows == null ? 0 : this.rows.getRecordIndex();
    }

    @Override
    public int getNullSortKind() {
        return this.nullSortKind;
    }

    public TableDescriptor table() {
        return this.tableDesc;
    }

    @Override
    public boolean internStrings() {
        return this.internStrings;
    }

    public int getBlobReceiving() {
        return this.blobReceiving;
    }

    @Override
    public ActualPoint getPeriodicBind() {
        return this.actualPoint;
    }

    @SmartScriptableObject.PropertyTag
    public double getActualPoint() {
        if (this.actualPoint != null && this.actualPoint.isAssigned()) {
            return this.actualPoint.getValue();
        }
        return DateTime.currentDateTime();
    }

    public void setActualPoint(double v) {
        if (this.actualPoint == null) {
            this.actualPoint = new ActualPoint();
        }
        this.actualPoint.setValue(v);
    }

    private void setParentDatasource(Datasource parentDatasource) {
        this.parentDatasource = parentDatasource;
    }

    public boolean getBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean value) {
        for (FieldDescriptor fd : this.getTableDescriptor().getFields()) {
            if (!fd.isHasDefValue()) continue;
            value = false;
            break;
        }
        if (value) {
            if (this.insertedRows == null) {
                this.insertedRows = new ArrayList<Row>();
            }
            this.getDBManager().registerBatchModeDatasource(this);
        } else {
            if (this.insertedRows != null && !this.insertedRows.isEmpty()) {
                throw new InformException(String.format(MESSAGE_UNREGISTER_BATCHMODE_DATASOURCE_EXCEPTION, this.getName()));
            }
            this.insertedRows = null;
            this.getDBManager().unregisterBatchModeDatasource(this);
        }
        if (this.rows != null) {
            this.rows.setBatchMode(value);
        }
        this.batchMode = value;
    }

    public PreparedStatement getBatchInsertStatement() {
        return this.batchInsertStatement;
    }

    public void setBatchInsertStatement(PreparedStatement batchInsertStatement) {
        this.batchInsertStatement = batchInsertStatement;
    }

    public List<Row> getInsertedRows() {
        return this.insertedRows;
    }

    private static class ExecuteContext {
        ArrayList<SortingField> sorting;
        Rowset.Kind kind;
        byte[] linkRelation;
        GeneratedSql.Sorting sortingGeneration;

        private ExecuteContext() {
        }
    }
}

