/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.collections.IntegerHash;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.SortDirection;
import inform.agent.db.types.DataType;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.BlobFileField;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.DateField;
import inform.agent.scripts.DirectoryField;
import inform.agent.scripts.GeometryField;
import inform.agent.scripts.NumericField;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.SqlStatement;
import inform.agent.scripts.StringField;
import inform.agent.scripts.Task;
import inform.agent.scripts.UnsupportedTypeField;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public abstract class DatasourceField
extends ScriptableObject
implements DatasetField,
IntegerHash.Entry {
    private static final String[] availJSFunctionsNames = new String[]{"toString", "clear", "assign"};
    private static final String[] availJSPropertiesNames = new String[]{"asDate", "asDateValue", "asString", "asNumber", "asBoolean", "value", "generatorEnabled"};
    private static final String[] availJSReadOnlyPropertiesNames = new String[]{"isNull", "isModified"};
    protected RowsetAccessor ra;
    protected FieldDescriptor desc;
    boolean sorting;
    public SortDirection sortDirection = SortDirection.ASCENDING;
    boolean generatorEnabled = true;

    protected DatasourceField(FieldDescriptor desc, RowsetAccessor ra) {
        this.desc = desc;
        this.ra = ra;
        for (String s : availJSPropertiesNames) {
            this.defineProperty(s, DatasourceField.class, 0);
        }
        DatasourceField.putConstProperty(this, "caption", desc.getCaption());
        DatasourceField.putConstProperty(this, "dataType", desc.getType().getTypeId());
        DatasourceField.putConstProperty(this, "id", desc.getId());
        DatasourceField.putConstProperty(this, "name", desc.getIdent());
        DatasourceField.putConstProperty(this, "rawName", desc.getRawName());
        DatasourceField.putConstProperty(this, "referenceTableID", desc.getReferenceId());
        DatasourceField.putConstProperty(this, "referenceFieldID", desc.getRefFieldId());
        for (String s : availJSReadOnlyPropertiesNames) {
            this.defineProperty(s, DatasourceField.class, 1);
        }
        this.defineFunctionProperties(availJSFunctionsNames, DatasourceField.class, 0);
    }

    protected void notifyModified() {
        if (this.sorting) {
            this.ra.notifySortingFieldModified(this);
        }
    }

    public RowsetAccessor getRowsetAccessor() {
        return this.ra;
    }

    public static DatasourceField createInstance(SSContext parentContext, Scriptable scope, FieldDescriptor fieldDescriptor, Task task, RowsetAccessor ra) throws InformException {
        DatasourceField result;
        switch (fieldDescriptor.getType()) {
            case BOOLEAN: 
            case FLOAT: 
            case METATREE_NODE: 
            case PRIMARY_KEY: 
            case INTERVAL: 
            case INTEGER: {
                result = new NumericField(fieldDescriptor, ra);
                break;
            }
            case BIG_NUMBER: 
            case STRING: 
            case UNICODE: {
                result = new StringField(fieldDescriptor, ra);
                break;
            }
            case DATE_TIME: {
                result = new DateField(fieldDescriptor, ra);
                break;
            }
            case DIRECTORY: {
                result = new DirectoryField(parentContext, fieldDescriptor, task, ra);
                break;
            }
            case BLOB: {
                result = new BlobField(fieldDescriptor, ra);
                break;
            }
            case FILE: {
                result = new BlobFileField(fieldDescriptor, ra);
                break;
            }
            case GEOMETRY: {
                result = new GeometryField(fieldDescriptor, ra);
                break;
            }
            default: {
                result = new UnsupportedTypeField(fieldDescriptor, ra);
            }
        }
        result.setParentScope(scope);
        return result;
    }

    @Override
    public DataType getDataType() {
        return this.desc.getType();
    }

    public FieldDescriptor getDescriptor() {
        return this.desc;
    }

    public abstract boolean isCompatibleValue(Object var1);

    @Override
    public boolean getIsNull() {
        if (!this.ra.isCurrentRowAvailable()) {
            return true;
        }
        return this.ra.getCurrentRow().getNullFlag(this.desc.getIndex());
    }

    public boolean getIsModified() throws Exception {
        if (!this.ra.isCurrentRowAvailable()) {
            return false;
        }
        return this.ra.getCurrentRow().getModFlag(this.desc.getIndex());
    }

    public abstract Scriptable getAsDate() throws Exception;

    public abstract void setAsDate(Scriptable var1) throws InformException;

    public abstract double getAsDateValue();

    public abstract void setAsDateValue(double var1) throws Exception;

    @Override
    public abstract String getAsString();

    public abstract void setAsString(String var1) throws Exception;

    @Override
    public abstract double getAsNumber();

    public abstract void setAsNumber(Double var1) throws Exception;

    public abstract boolean getAsBoolean();

    public abstract void setAsBoolean(boolean var1) throws Exception;

    @Override
    public BinaryObject getAsBinary() throws Exception {
        throw new UnsupportedOperationException("getAsBinary \u043f\u043e\u043b\u0435 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c");
    }

    public void setAsBinary(BinaryObject value) throws Exception {
        throw new UnsupportedOperationException("setAsBinary \u043f\u043e\u043b\u0435 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c");
    }

    public final void assign(Object value) {
        if (value instanceof DatasourceField) {
            this.assignField((DatasourceField)value);
            return;
        }
        if (value instanceof SqlStatement.ResultField) {
            value = ((SqlStatement.ResultField)value).getValue();
        }
        if (value == null) {
            this.clear();
        } else {
            this.assignNotNullValue(value);
        }
    }

    protected abstract void assignNotNullValue(Object var1);

    @Override
    public Object getAvailableValue() throws Exception {
        if (this.ra.isCurrentRowAvailable()) {
            return this.getValue();
        }
        return null;
    }

    @Override
    public Object getValue() throws Exception {
        if (this.getIsNull()) {
            return null;
        }
        switch (this.desc.getType()) {
            case BOOLEAN: 
            case FLOAT: 
            case METATREE_NODE: 
            case PRIMARY_KEY: 
            case INTERVAL: 
            case INTEGER: 
            case DIRECTORY: {
                return this.getAsNumber();
            }
            case BIG_NUMBER: 
            case STRING: 
            case UNICODE: {
                return this.getAsString();
            }
            case DATE_TIME: {
                return this.getAsDateValue();
            }
        }
        return null;
    }

    public void setValue(Object value) throws Exception {
        this.assign(value);
    }

    public void clear() throws InformException {
        Row r = this.ra.getCurrentRow();
        if (!r.setNullFlag(this.desc.getIndex())) {
            return;
        }
        this.notifyModified();
    }

    public final boolean getGeneratorEnabled() {
        return this.generatorEnabled;
    }

    public final void setGeneratorEnabled(boolean value) {
        if (value) {
            this.generatorEnabled = true;
            return;
        }
        FieldDescriptor.AutoValueGenerator avg = this.desc.getAutoValueGenerator();
        switch (avg) {
            case NONE: {
                return;
            }
            case MAX_VALUE: 
            case ORACLE_SEQUENCE: 
            case ORACLE_PROC: {
                break;
            }
            default: {
                throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0433\u0435\u043d\u0440\u0430\u0442\u043e\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u044f");
            }
        }
        this.generatorEnabled = value;
        this.ra.enableFieldValueGenerator(this.desc.getIndex(), value);
    }

    @Override
    public String getClassName() {
        return "DatasourceField";
    }

    public String toString() {
        return "field " + this.desc.getIdent() + " " + this.ra.toString();
    }

    void assignField(DatasourceField field) {
        Row destRow = this.ra.getCurrentRow();
        Row srcRow = field.ra.getCurrentRow();
        boolean modified = this.desc.getType().isNumeric() ? (srcRow.getNullFlag(field.desc.getIndex()) ? destRow.setNullFlag(this.desc.getIndex()) : destRow.setNumeric(this.desc.getIndex(), srcRow.getNumeric(field.desc.getIndex()))) : destRow.setComplex(this.desc.getIndex(), srcRow.getComplex(field.desc.getIndex()));
        if (modified) {
            this.notifyModified();
        }
    }

    void checkNumberValue(double value) {
        if (Double.isInfinite(value)) {
            throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0438\u0441\u0432\u043e\u0438\u0442\u044c \u043f\u043e\u043b\u044e \u0431\u0435\u0441\u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e");
        }
        if (Double.isNaN(value)) {
            throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0438\u0441\u0432\u043e\u0438\u0442\u044c \u043f\u043e\u043b\u044e \u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e(NaN)");
        }
    }

    @Override
    public int key() {
        return this.desc.getId();
    }
}

