/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.Strings;
import inform.adt.collections.IntegerHash;
import inform.agent.scripts.DatasourceField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class DatasourceFieldList {
    private IntegerHash<DatasourceField> fieldsByID = new IntegerHash();
    private HashMap<String, DatasourceField> fieldsByName = new HashMap();
    private ArrayList<DatasourceField> fieldsList = new ArrayList();

    DatasourceField findLink(double tableID) {
        for (DatasourceField f : this.fieldsList) {
            if (f.getDescriptor().getReferenceId() != tableID) continue;
            return f;
        }
        return null;
    }

    public DatasourceField get(String name) {
        return this.fieldsByName.get(name);
    }

    public DatasourceField get(int id) {
        return this.fieldsByID.get(id);
    }

    boolean contains(String name) {
        return this.fieldsByName.containsKey(name);
    }

    public void put(DatasourceField field) {
        if (!Strings.isVoid(field.getDescriptor().getIdent())) {
            this.fieldsByName.put(field.getDescriptor().getIdent(), field);
        }
        this.fieldsByID.add(field);
        this.fieldsList.add(field);
    }

    public Collection<DatasourceField> values() {
        return this.fieldsList;
    }

    public DatasourceField getByIndex(int index) {
        return this.fieldsList.get(index);
    }

    public int size() {
        return this.fieldsList.size();
    }
}

