/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatManager;
import java.util.Date;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

class DateField
extends DatasourceField {
    Format format = FormatManager.createFormat(this.getDescriptor().getFormat(), DataType.DATE_TIME, new byte[0]);

    DateField(FieldDescriptor desc, RowsetAccessor ra) throws InformException {
        super(desc, ra);
    }

    @Override
    public double getAsDateValue() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return 0.0;
        }
        return this.ra.getCurrentRow().getNumeric(this.getDescriptor().getIndex());
    }

    @Override
    public void setAsDateValue(double value) throws InformException {
        this.checkNumberValue(value);
        if (this.ra.getCurrentRow().setNumeric(this.getDescriptor().getIndex(), value)) {
            this.notifyModified();
        }
    }

    @Override
    public String getAsString() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return "";
        }
        int index = this.getDescriptor().getIndex();
        Row row = this.ra.getCurrentRow();
        if (this.format == null || row.getNullFlag(index)) {
            return "";
        }
        return this.format.format(row.getNumeric(index));
    }

    @Override
    public void setAsString(String value) throws InformException {
        if (this.ra.getCurrentRow().setNumeric(this.getDescriptor().getIndex(), ValueCaster.toNumber(value).doubleValue())) {
            this.notifyModified();
        }
    }

    @Override
    public double getAsNumber() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return 0.0;
        }
        return this.getAsDateValue();
    }

    @Override
    public void setAsNumber(Double value) throws InformException {
        this.checkNumberValue(value);
        this.setAsDateValue(value);
    }

    @Override
    public Scriptable getAsDate() throws InformException {
        double dateValue = this.ra.isCurrentRowAvailable() ? this.ra.getCurrentRow().getNumeric(this.getDescriptor().getIndex()) : 0.0;
        Object[] ctorArgs = new Object[]{DateTime.toUnixTime(dateValue)};
        return Context.getCurrentContext().newObject(this, "Date", ctorArgs);
    }

    @Override
    public void setAsDate(Scriptable value) throws InformException {
        Date d = (Date)Context.jsToJava(value, Date.class);
        if (this.ra.getCurrentRow().setNumeric(this.getDescriptor().getIndex(), ValueCaster.toNumber(d).doubleValue())) {
            this.notifyModified();
        }
    }

    @Override
    public boolean getAsBoolean() throws InformException {
        return this.ra.isCurrentRowAvailable() ? this.ra.getCurrentRow().getNumeric(this.getDescriptor().getIndex()) != 0.0 : false;
    }

    @Override
    public void setAsBoolean(boolean value) throws InformException {
        if (this.ra.getCurrentRow().setNumeric(this.getDescriptor().getIndex(), value ? 1.0 : 0.0)) {
            this.notifyModified();
        }
    }

    @Override
    protected void assignNotNullValue(Object value) {
        this.setAsDateValue(ValueCaster.toDouble(value));
    }

    @Override
    public boolean isCompatibleValue(Object value) {
        return value instanceof Number;
    }
}

