/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.Strings;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DateLibrary
extends ScriptableObject {
    private static final String[] availJSFunctionsNames = new String[]{"beginOfMonth", "beginOfQuart", "beginOfWeek", "beginOfYear", "currentDate", "currentDateTime", "currentTime", "date", "dateValue", "dateOf", "dateToString", "dayOf", "dayOfWeek", "dayOfYear", "daysBetween", "monthsBetween", "daysInMonth", "daysInYear", "endOfMonth", "endOfQuart", "endOfWeek", "endOfYear", "format", "hourOf", "incDay", "incMonth", "incYear", "isLeapYear", "minuteOf", "monthOf", "stringToDate", "stringToDateTime", "stringToTime", "time", "timeOf", "toString", "weekOfYear", "yearOf", "value", "valueToDate", "quartOf", "tenDaysOf", "beginOfTenDays", "endOfTenDays", "incTenDays", "daysInTenDays", "halfYearOf", "beginOfHalfYear", "endOfHalfYear", "incHalfYear", "daysInHalfYear", "incHour"};
    private DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private DateFormat parseDateFormat1 = new SimpleDateFormat("dd/MM/yyyy");
    private DateFormat parseDateFormat2 = new SimpleDateFormat("dd.MM.yyyy");
    private DateFormat parseDateFormat3 = new SimpleDateFormat("dd-MM-yyyy");
    private DateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private String dd_MM_yyyy_hh_mm_ss = "dd/MM/yyyy HH:mm:ss";
    private String dd_MM_yyyy_hh_mm = "dd/MM/yyyy HH:mm";
    private String hh_mm_ss = "HH:mm:ss";
    private String hh_mm = "HH:mm";
    private DateFormat dateTimeFormat1 = new SimpleDateFormat(this.dd_MM_yyyy_hh_mm_ss);
    private DateFormat dateTimeFormat2 = new SimpleDateFormat(this.dd_MM_yyyy_hh_mm);

    private static Calendar createCalendar(Object[] args) {
        if (args.length < 3 || args.length > 7) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b date()");
        }
        int year = ((Number)args[0]).intValue();
        int month = ((Number)args[1]).intValue() - 1;
        int day = ((Number)args[2]).intValue();
        GregorianCalendar cal = new GregorianCalendar(year, month, day);
        if (args.length > 3) {
            cal.set(11, ((Number)args[3]).intValue());
            if (args.length > 4) {
                cal.set(12, ((Number)args[4]).intValue());
                if (args.length > 5) {
                    cal.set(13, ((Number)args[5]).intValue());
                    if (args.length > 6) {
                        cal.set(14, ((Number)args[6]).intValue());
                    }
                }
            }
        }
        return cal;
    }

    public DateLibrary(Scriptable scope) {
        this.setParentScope(scope);
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    @Override
    public String getClassName() {
        return "Dates";
    }

    public String toString(double date) {
        if (date == 0.0) {
            return "";
        }
        Calendar c = DateTime.toCalendar(date);
        DateTime.fromUnixTime(0L);
        int y = c.get(1);
        int m = c.get(2) + 1;
        int d = c.get(5);
        int hh = c.get(11);
        int mm = c.get(12);
        int ss = c.get(13);
        int ms = c.get(14);
        if ((hh | mm | ss | ms) == 0) {
            return String.format("%02d.%02d.%04d", d, m, y);
        }
        return String.format("%02d.%02d.%04d %02d:%02d:%02d:%03d", d, m, y, hh, mm, ss, ms);
    }

    public static Object date(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return DateTime.fromUnixTime(DateLibrary.createCalendar(args).getTimeInMillis());
    }

    public static Object dateValue(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return DateLibrary.date(cx, thisObj, args, funObj);
    }

    private static int getTenDay(Calendar cal) {
        int dayOfMonth = cal.get(5);
        if (dayOfMonth < 11) {
            return 1;
        }
        if (dayOfMonth < 21) {
            return 2;
        }
        return 3;
    }

    private static int getDaysInTenDays(Calendar cal) {
        int tenDay = DateLibrary.getTenDay(cal);
        if (tenDay == 3) {
            return cal.getActualMaximum(5) - 20;
        }
        return 10;
    }

    private static Calendar getBeginOfTenDays(Calendar cal) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeInMillis(cal.getTimeInMillis());
        int tenDay = DateLibrary.getTenDay(cal);
        result.set(14, ((Calendar)result).getActualMinimum(14));
        result.set(13, ((Calendar)result).getActualMinimum(13));
        result.set(12, ((Calendar)result).getActualMinimum(12));
        result.set(10, ((Calendar)result).getActualMinimum(10));
        result.set(5, (tenDay - 1) * 10 + 1);
        return result;
    }

    private static Calendar getEndOfTenDays(Calendar cal) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeInMillis(cal.getTimeInMillis());
        int tenDay = DateLibrary.getTenDay(cal);
        if (tenDay == 3) {
            result.set(5, cal.getActualMaximum(5));
        } else {
            result.set(5, tenDay * 10);
        }
        result.set(14, ((Calendar)result).getActualMaximum(14));
        result.set(13, ((Calendar)result).getActualMaximum(13));
        result.set(12, ((Calendar)result).getActualMaximum(12));
        result.set(10, ((Calendar)result).getActualMaximum(10));
        return result;
    }

    public static int tenDaysOf(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 0) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            return DateLibrary.getTenDay(cal);
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    public static double beginOfTenDays(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 0) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            return DateTime.fromUnixTime(DateLibrary.getBeginOfTenDays(cal).getTimeInMillis());
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    public static double endOfTenDays(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 0) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            long seconds = DateLibrary.getEndOfTenDays(cal).getTimeInMillis() / 1000L;
            return DateTime.fromUnixTime(seconds * 1000L);
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    public static double incTenDays(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 1) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            double delta = ((Number)args[1]).doubleValue();
            Calendar result = delta > 0.0 ? DateLibrary.getBeginOfTenDays(cal) : DateLibrary.getEndOfTenDays(cal);
            int daysOfTenDay = delta > 0.0 ? cal.get(5) - result.get(5) : result.get(5) - cal.get(5);
            int i = 0;
            while (true) {
                double d = i;
                double d2 = delta > 0.0 ? delta : -delta;
                if (!(d < d2)) break;
                int days = DateLibrary.getDaysInTenDays(result);
                result.add(5, delta > 0.0 ? days : -days);
                ++i;
            }
            result.add(5, delta > 0.0 ? daysOfTenDay : -daysOfTenDay);
            return DateTime.fromUnixTime(result.getTimeInMillis());
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    public static int daysInTenDays(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 0) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            return DateLibrary.getDaysInTenDays(cal);
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    private static int getHalfYear(Calendar cal) {
        return cal.get(2) < 6 ? 1 : 2;
    }

    private static Calendar getBeginOfHalfYear(Calendar cal) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeInMillis(cal.getTimeInMillis());
        result.set(14, ((Calendar)result).getActualMinimum(14));
        result.set(13, ((Calendar)result).getActualMinimum(13));
        result.set(12, ((Calendar)result).getActualMinimum(12));
        result.set(10, ((Calendar)result).getActualMinimum(10));
        int halfYear = DateLibrary.getHalfYear(cal);
        result.set(2, halfYear == 1 ? ((Calendar)result).getActualMinimum(2) : 6);
        result.set(5, ((Calendar)result).getActualMinimum(5));
        return result;
    }

    private static Calendar getEndOfHalfYear(Calendar cal) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeInMillis(cal.getTimeInMillis());
        result.set(14, ((Calendar)result).getActualMaximum(14));
        result.set(13, ((Calendar)result).getActualMaximum(13));
        result.set(12, ((Calendar)result).getActualMaximum(12));
        result.set(10, ((Calendar)result).getActualMaximum(10));
        int halfYear = DateLibrary.getHalfYear(cal);
        result.set(2, halfYear == 1 ? 5 : ((Calendar)result).getActualMaximum(2));
        result.set(5, ((Calendar)result).getActualMaximum(5));
        return result;
    }

    private static int getDaysInHalfYear(Calendar cal) {
        if (DateLibrary.getHalfYear(cal) == 2) {
            return 184;
        }
        return DateLibrary.isLeapYear(cal.get(1)) ? 182 : 181;
    }

    public static int halfYearOf(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 0) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            return DateLibrary.getHalfYear(cal);
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    public static double beginOfHalfYear(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 0) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            return DateTime.fromUnixTime(DateLibrary.getBeginOfHalfYear(cal).getTimeInMillis());
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    public static double endOfHalfYear(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 0) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            long seconds = DateLibrary.getEndOfHalfYear(cal).getTimeInMillis() / 1000L;
            return DateTime.fromUnixTime(seconds * 1000L);
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    public static int daysInHalfYear(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 0) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            return DateLibrary.getDaysInHalfYear(cal);
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    public static double incHalfYear(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        GregorianCalendar cal = null;
        if (args.length > 1) {
            cal = new GregorianCalendar();
            cal.setTimeInMillis(DateTime.toUnixTime((Double)args[0]));
            int delta = ((Number)args[1]).intValue();
            if (delta == 0) {
                return DateTime.fromUnixTime(cal.getTimeInMillis());
            }
            Calendar result = null;
            result = delta > 0 ? DateLibrary.getBeginOfHalfYear(cal) : DateLibrary.getEndOfHalfYear(cal);
            int daysOfHalfYear = delta > 0 ? cal.get(6) - result.get(6) : result.get(6) - cal.get(6);
            for (int i = 0; i < (delta > 0 ? delta : -delta); ++i) {
                int days = DateLibrary.getDaysInHalfYear(result);
                result.add(6, delta > 0 ? days : -days);
            }
            result.add(6, delta > 0 ? daysOfHalfYear : -daysOfHalfYear);
            return DateTime.fromUnixTime(result.getTimeInMillis());
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
    }

    public static Object daysInMonth(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        double xDate;
        GregorianCalendar cal = new GregorianCalendar();
        if (args.length == 1) {
            xDate = (Double)args[0];
        } else if (args.length == 2) {
            int xYear = ((Number)args[1]).intValue();
            int xMonth = ((Number)args[0]).intValue();
            xDate = DateTime.create(xYear, xMonth, 1);
        } else {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b");
        }
        cal.setTimeInMillis(DateTime.toUnixTime(xDate));
        return ((Calendar)cal).getActualMaximum(5);
    }

    public double currentDate() {
        return Math.floor(this.currentDateTime());
    }

    public double currentDateTime() {
        return DateTime.fromUnixTime(System.currentTimeMillis());
    }

    public double currentTime() {
        double d = this.currentDateTime();
        return d - Math.floor(d);
    }

    public static double incDay(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 0 || args.length > 2) {
            throw new IllegalArgumentException("incDay()");
        }
        double d = ((Number)args[0]).doubleValue();
        int amount = 1;
        if (args.length == 2) {
            amount = ((Number)args[1]).intValue();
        }
        return d + (double)amount;
    }

    public static double incMonth(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 0 || args.length > 2) {
            throw new IllegalArgumentException("incMonth()");
        }
        double d = ((Number)args[0]).doubleValue();
        int amount = 1;
        if (args.length == 2) {
            amount = ((Number)args[1]).intValue();
        }
        Calendar cal = DateTime.toCalendar(d);
        cal.add(2, amount);
        return DateTime.fromUnixTime(cal.getTimeInMillis());
    }

    public static double incYear(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 0 || args.length > 2) {
            throw new IllegalArgumentException("incYear()");
        }
        double d = ((Number)args[0]).doubleValue();
        int amount = 1;
        if (args.length == 2) {
            amount = ((Number)args[1]).intValue();
        }
        Calendar cal = DateTime.toCalendar(d);
        cal.add(1, amount);
        return DateTime.fromUnixTime(cal.getTimeInMillis());
    }

    public int daysBetween(double date1, double date2) {
        return (int)date2 - (int)date1;
    }

    public int monthsBetween(double date1, double date2) {
        if (date1 > date2) {
            double d = date1;
            date1 = date2;
            date2 = d;
        }
        Calendar cal1 = DateTime.toCalendar(date1);
        int year1 = cal1.get(1);
        int month1 = cal1.get(2);
        int day1 = cal1.get(5);
        Calendar cal2 = DateTime.toCalendar(date2);
        int year2 = cal2.get(1);
        int month2 = cal2.get(2);
        int day2 = cal2.get(5);
        int result = 12 * (year2 - year1) + (month2 - month1);
        if (day1 > day2) {
            --result;
        }
        return result;
    }

    public int daysInYear(double date) {
        double xDate = date;
        if (date <= 2200.0) {
            xDate = DateTime.create((int)date, 2, 1);
        }
        Calendar cal = DateTime.toCalendar(xDate);
        return cal.getActualMaximum(6);
    }

    public static boolean isLeapYear(double year) {
        GregorianCalendar cal = new GregorianCalendar((int)Math.round(year), 1, 1, 0, 0, 0);
        return DateTime.isLeapYear(cal.get(1));
    }

    public double beginOfMonth(double date) {
        Calendar cal = DateTime.toCalendar(date);
        cal.set(14, cal.getActualMinimum(14));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(11, cal.getActualMinimum(11));
        cal.set(5, cal.getActualMinimum(5));
        return DateTime.fromUnixTime(cal.getTimeInMillis());
    }

    public double endOfMonth(double date) {
        Calendar cal = DateTime.toCalendar(date);
        cal.set(14, cal.getActualMaximum(14));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(11, cal.getActualMaximum(11));
        cal.set(5, cal.getActualMaximum(5));
        long seconds = cal.getTimeInMillis() / 1000L;
        return DateTime.fromUnixTime(seconds * 1000L);
    }

    public double beginOfYear(double date) {
        Calendar cal = DateTime.toCalendar(date);
        cal.set(14, cal.getActualMinimum(14));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(11, cal.getActualMinimum(11));
        cal.set(5, cal.getActualMinimum(5));
        cal.set(2, cal.getActualMinimum(2));
        return DateTime.fromUnixTime(cal.getTimeInMillis());
    }

    public double endOfYear(double date) {
        Calendar cal = DateTime.toCalendar(date);
        cal.set(2, cal.getActualMaximum(2));
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        long seconds = cal.getTimeInMillis() / 1000L;
        return DateTime.fromUnixTime(seconds * 1000L);
    }

    public double beginOfWeek(double date) {
        Calendar cal = DateTime.toCalendar(date);
        int dow = cal.get(7);
        int delta = -6;
        if (dow != 1) {
            delta = 2 - dow;
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(7, delta);
        return DateTime.fromUnixTime(cal.getTimeInMillis());
    }

    public double endOfWeek(double date) {
        Calendar cal = DateTime.toCalendar(date);
        int dow = cal.get(7);
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        if (dow != 1) {
            cal.add(7, 7 - dow + 1);
        }
        long seconds = cal.getTimeInMillis() / 1000L;
        return DateTime.fromUnixTime(seconds * 1000L);
    }

    public static double incHour(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 0 || args.length > 2) {
            throw new IllegalArgumentException("incHour()");
        }
        double d = ((Number)args[0]).doubleValue();
        int amount = 1;
        if (args.length == 2) {
            amount = ((Number)args[1]).intValue();
        }
        long date = DateTime.toMillis(d);
        double r = DateTime.fromMillis(date += (long)amount * 60L * 60L * 1000L);
        return r;
    }

    public int yearOf(double date) {
        Calendar cal = DateTime.toCalendar(date);
        return cal.get(1);
    }

    public int monthOf(double date) {
        Calendar cal = DateTime.toCalendar(date);
        return cal.get(2) + 1;
    }

    public int dayOf(double date) {
        Calendar cal = DateTime.toCalendar(date);
        return cal.get(5);
    }

    public int hourOf(double date) {
        Calendar cal = DateTime.toCalendar(date);
        return cal.get(11);
    }

    public int minuteOf(double date) {
        Calendar cal = DateTime.toCalendar(date);
        return cal.get(12);
    }

    public int weekOfYear(double date) {
        Calendar cal = DateTime.toCalendar(date);
        cal.setFirstDayOfWeek(2);
        cal.setMinimalDaysInFirstWeek(4);
        return cal.get(3);
    }

    public int dayOfYear(double date) {
        Calendar cal = DateTime.toCalendar(date);
        return cal.get(6);
    }

    public double value(Object v) throws ParseException {
        if (v instanceof String) {
            String dateStr = (String)v;
            String dateTimeStr = dateStr.replace(".", "/");
            if (dateTimeStr.length() == this.dd_MM_yyyy_hh_mm_ss.length()) {
                return DateTime.fromUnixTime(this.dateTimeFormat1.parse(dateTimeStr).getTime());
            }
            if (dateTimeStr.length() == this.dd_MM_yyyy_hh_mm.length()) {
                return DateTime.fromUnixTime(this.dateTimeFormat2.parse(dateTimeStr).getTime());
            }
            if (dateStr.contains(".")) {
                return DateTime.fromUnixTime(this.parseDateFormat2.parse(dateStr).getTime());
            }
            if (dateStr.contains("/")) {
                return DateTime.fromUnixTime(this.parseDateFormat1.parse(dateStr).getTime());
            }
            if (dateStr.contains("-")) {
                return DateTime.fromUnixTime(this.parseDateFormat3.parse(dateStr).getTime());
            }
            throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u0430\u0442\u0430/\u0432\u0440\u0435\u043c\u044f");
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        Date d = (Date)Context.jsToJava(v, ScriptRuntime.DateClass);
        return DateTime.fromUnixTime(d.getTime());
    }

    public Object valueToDate(double value) {
        Object[] ctorArgs = new Object[]{DateTime.toUnixTime(value)};
        return Context.getCurrentContext().newObject(this, "Date", ctorArgs);
    }

    public int dayOfWeek(double date) {
        return ((int)date - 2) % 7 + 1;
    }

    public double time(int hour, int minute, int second, int msec) {
        return (double)(msec + second * 1000 + minute * 60 * 1000 + hour * 60 * 60 * 1000) / 8.64E7;
    }

    public double beginOfQuart(double date) {
        Calendar cal = DateTime.toCalendar(Math.floor(date));
        int month = cal.get(2);
        int tail = month % 3;
        cal.set(2, month - tail);
        cal.set(5, cal.getActualMinimum(5));
        return DateTime.fromUnixTime(cal.getTimeInMillis());
    }

    public double endOfQuart(double date) {
        Calendar cal = DateTime.toCalendar(Math.floor(date));
        int month = cal.get(2);
        int tail = month % 3;
        cal.set(2, month - tail + 2);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        long seconds = cal.getTimeInMillis() / 1000L;
        return DateTime.fromUnixTime(seconds * 1000L);
    }

    public double dateOf(double date) {
        return Math.floor(date);
    }

    public double timeOf(double date) {
        double t = date - this.dateOf(date);
        double tms = Math.rint(t * 8.64E7);
        t = tms / 8.64E7;
        return t;
    }

    private int[] parseDateParts(String inStr) {
        int[] r = new int[7];
        int n = 0;
        for (int i = 0; i < inStr.length(); ++i) {
            char ch = inStr.charAt(i);
            if (ch < '0' || ch > '9') continue;
            r[n] = r[n] * 10 + ch - 48;
        }
        return null;
    }

    public double stringToDate(String dateStr) throws ParseException {
        if (!Strings.isVoid(dateStr)) {
            if (dateStr.contains(".")) {
                return DateTime.fromUnixTime(this.parseDateFormat2.parse(dateStr).getTime());
            }
            if (dateStr.contains("/")) {
                return DateTime.fromUnixTime(this.parseDateFormat1.parse(dateStr).getTime());
            }
            if (dateStr.contains("-")) {
                return DateTime.fromUnixTime(this.parseDateFormat3.parse(dateStr).getTime());
            }
        }
        return DateTime.fromUnixTime(this.dateFormat.parse(dateStr).getTime());
    }

    public double stringToTime(String timeStr) throws ParseException {
        String xPattern = this.hh_mm_ss;
        if (timeStr.length() == this.hh_mm.length()) {
            xPattern = this.hh_mm;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(xPattern);
        Date date = formatter.parse(timeStr);
        double d = DateTime.fromUnixTime(date.getTime());
        return d - Math.floor(d);
    }

    public double stringToDateTime(String dateTimeStr) throws ParseException, InformException {
        double d;
        String xDateTimeStr = dateTimeStr.replace(".", "/");
        if (dateTimeStr.length() == this.dd_MM_yyyy_hh_mm_ss.length()) {
            Date date = this.dateTimeFormat1.parse(xDateTimeStr);
            d = DateTime.fromUnixTime(date.getTime());
        } else if (dateTimeStr.length() == this.dd_MM_yyyy_hh_mm.length()) {
            Date date = this.dateTimeFormat2.parse(xDateTimeStr);
            d = DateTime.fromUnixTime(date.getTime());
        } else {
            throw new InformException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u0430\u0442\u0430/\u0432\u0440\u0435\u043c\u044f");
        }
        return d;
    }

    public String dateToString(double date) {
        date = Math.floor(date);
        return this.dateFormat.format(new Date(DateTime.toUnixTime(date)));
    }

    public String format(String pattern, double date) {
        return new SimpleDateFormat(pattern, new Locale("ru", "RU")).format(new Date(DateTime.toUnixTime(date)));
    }

    public double quartOf(double date) {
        Calendar cal = DateTime.toCalendar(date);
        return cal.get(2) / 3 + 1;
    }
}

