/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.ObjectSizer;
import inform.adt.collections.DoubleSet;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.DirectoryRowset;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.ForwardOnlyRowset;
import inform.agent.db.Row;
import inform.agent.db.Rowset;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.RowsetRandomAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.connect.PreparedStatement;
import inform.agent.db.utils.DirectoryRowsetCacheKey;
import inform.agent.scripts.ActualPoint;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.DatasourceFieldList;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.Task;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryGeneratedSql;
import inform.agent.scripts.stat.DirectoryProfile;
import java.util.Iterator;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Directory
extends ScriptableObject
implements RowsetAccessor {
    private static final int FETCH_SIZE = 128;
    private static final int FULLOAD_LIMIT = 4096;
    @ObjectSizer.HintShared
    private Task task;
    private RowsetAccessor ra;
    private final int fieldIndex;
    private final String name;
    private TableDescriptor tableDesc;
    private DatasourceFieldList fields = new DatasourceFieldList();
    private DirectoryRowset touchedRows;
    private final ActualPoint actualPoint;
    private DirectoryProfile profile = null;
    public final SSContext ssContext;

    Directory(SSContext ssContext, Scriptable scope, Task task, RowsetAccessor ra, FieldDescriptor field, TableDescriptor tableDesc) throws InformException {
        this.task = task;
        this.ra = ra;
        this.fieldIndex = field.getIndex();
        this.name = field.getIdent();
        this.tableDesc = tableDesc;
        this.actualPoint = ra.getPeriodicBind();
        this.ssContext = ssContext;
        for (FieldDescriptor f : tableDesc.getFields()) {
            this.fields.put(DatasourceField.createInstance(ssContext, scope, f, task, this));
        }
        this.profile = task.addDirectory(tableDesc.getNodeId(), task.nodeId());
    }

    @Override
    public String getClassName() {
        return "Directory";
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return this.tableDesc;
    }

    @Override
    public int getNullSortKind() {
        return this.ra == null ? 0 : this.ra.getNullSortKind();
    }

    @Override
    public DatasourceField findfieldById(int fieldId) {
        return this.fields.get(fieldId);
    }

    @Override
    public void enableFieldValueGenerator(int fieldIndex, boolean value) {
    }

    @Override
    public void notifySortingFieldModified(Object field) {
    }

    private double rowId() throws InformException {
        if (this.ra.isCurrentRowAvailable()) {
            return this.ra.getCurrentRow().getNumeric(this.fieldIndex);
        }
        return 0.0;
    }

    private Row getCurrentRowInternal() throws InformException {
        if (this.profile != null) {
            this.profile.addAccessCount();
        }
        double rowId = this.rowId();
        DirectoryRowset rows = this.rows();
        Row result = (Row)rows.get(rowId);
        if (result == null && !rows.isFullyFilled()) {
            try {
                RowsetRandomAccessor rra;
                RowsetRandomAccessor rowsetRandomAccessor = rra = this.ra instanceof RowsetRandomAccessor ? (RowsetRandomAccessor)this.ra : null;
                if (rra != null && rra.canRandomAccess()) {
                    double id;
                    Row r;
                    DoubleSet ids = new DoubleSet();
                    ids.add(rowId);
                    int ri = rra.getCurrentRowIndex();
                    if (ri < 0) {
                        ri = 0;
                    }
                    for (int idx = ri; idx < rra.getRowsCount() && ((r = rra.getRow(idx)).getNullFlag(this.fieldIndex) || rows.get(id = r.getNumeric(this.fieldIndex)) != null || !ids.add(id) || ids.size() != 128); ++idx) {
                    }
                    this.prefetch(rows, ids.toArray());
                } else {
                    this.prefetch(rows, rowId);
                }
                result = (Row)rows.get(rowId);
            }
            catch (Throwable ex) {
                throw InformException.wrap(ex);
            }
        }
        if (result instanceof NoRow) {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prefetch(DirectoryRowset rows, double ... ids) throws Exception {
        long startTime = System.currentTimeMillis();
        Query query = new Query(this.getHost(), this.getNullSortKind());
        query.createParameterizedTableCondition(this.tableDesc.getNodeId());
        if (rows.cacheKey.hasActualPoint) {
            query.getRootNode().setActualPoint(rows.cacheKey.actualPoint);
        }
        if (ids.length == 0) {
            query.setFetchLimit(4097);
        }
        String sqlText = query.generateSqlText(null, null);
        if (ids.length != 0) {
            FieldDescriptor recordId = this.tableDesc.getRecordIdField();
            String recordIdRawName = recordId != null ? recordId.getRawName() : "ID";
            StringBuilder _sqlText = new StringBuilder("SELECT T.* FROM (");
            _sqlText.append(sqlText);
            _sqlText.append(")T WHERE T.").append(recordIdRawName).append(" IN (");
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    _sqlText.append(',');
                }
                _sqlText.append('?');
            }
            _sqlText.append(')');
            sqlText = _sqlText.toString();
        }
        try (PreparedStatement stmt = this.getDBManager().getConnection(this.tableDesc.getDbId(), "JS:Directory::getCurrentRowInternal").prepareStatement("Directory.loadData", sqlText);){
            stmt.setQueryTimeout();
            QueryGeneratedSql.appendParametersTo(query.getSqlParameters(), stmt);
            if (ids.length != 0) {
                int offs = stmt.getParamValuesCount() + 1;
                int idx = 0;
                for (double i : ids) {
                    stmt.setDouble(offs + idx++, i);
                }
            }
            int count = 0;
            ForwardOnlyRowset rowset = new ForwardOnlyRowset(this.ssContext, this.getDBManager(), this.tableDesc, stmt, 0, true, this.ra.internStrings());
            while (((Rowset)rowset).next()) {
                rows.add(rowset.getCurrentRow());
                if (++count <= 4096) continue;
                boolean bl = false;
                ((Rowset)rowset).close();
                if (this.profile != null) {
                    this.profile.addRequestTime(System.currentTimeMillis() - startTime);
                    this.profile.addRequestCount();
                    this.profile.addRecordCount(count);
                }
                return bl;
            }
            try {
                for (double i : ids) {
                    if (rows.get(i) != null) continue;
                    rows.add(new NoRow(i));
                }
                boolean bl = true;
                ((Rowset)rowset).close();
                if (this.profile != null) {
                    this.profile.addRequestTime(System.currentTimeMillis() - startTime);
                    this.profile.addRequestCount();
                    this.profile.addRecordCount(count);
                }
                return bl;
            }
            catch (Throwable throwable) {
                ((Rowset)rowset).close();
                if (this.profile != null) {
                    this.profile.addRequestTime(System.currentTimeMillis() - startTime);
                    this.profile.addRequestCount();
                    this.profile.addRecordCount(count);
                }
                throw throwable;
            }
        }
    }

    @Override
    public Row getCurrentRow() throws InformException {
        Row result = this.getCurrentRowInternal();
        if (result == null) {
            throw new InformException(String.format("\u0417\u0430\u043f\u0438\u0441\u044c [%.0f] \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 [id:%.0f, name:%s] \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", this.rowId(), this.tableDesc.getNodeId(), this.name));
        }
        return result;
    }

    public DatasourceField getFieldById(int fieldId) {
        return this.fields.get(fieldId);
    }

    public DatasourceField getFieldByName(String name) {
        return this.fields.get(name);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (!this.fields.contains(name)) {
            return super.get(name, start);
        }
        return this.fields.get(name);
    }

    @Override
    public AbstractConnectionManager getDBManager() {
        return this.ra.getDBManager();
    }

    @Override
    public boolean isCurrentRowAvailable() throws InformException {
        return this.getCurrentRowInternal() != null;
    }

    private DirectoryRowset rows() {
        boolean hasActualPoint;
        boolean bl = hasActualPoint = this.tableDesc.isHasPeriodicStorage() && this.actualPoint != null && this.actualPoint.isAssigned();
        if (hasActualPoint) {
            double ap = this.actualPoint.getValue();
            if (this.touchedRows == null || !this.touchedRows.cacheKey.isEqual(ap, this.tableDesc)) {
                this.touchedRows = this.task.getDirectoryRowset(new DirectoryRowsetCacheKey(ap, this.tableDesc));
            }
        } else if (this.touchedRows == null || !this.touchedRows.cacheKey.isEqual(this.tableDesc)) {
            this.touchedRows = this.task.getDirectoryRowset(new DirectoryRowsetCacheKey(this.tableDesc));
        }
        return this.touchedRows;
    }

    @Override
    public ServerSideHost getHost() {
        return this.ra.getHost();
    }

    public void detach() {
        this.touchedRows = null;
    }

    @Override
    public boolean internStrings() {
        return this.ra.internStrings();
    }

    @Override
    public ActualPoint getPeriodicBind() {
        return this.actualPoint;
    }

    private final class NoRow
    extends Row {
        NoRow(double id) {
            this.id = id;
        }

        @Override
        public boolean isRowLoaded() {
            return true;
        }

        @Override
        public double getNumeric(int index) {
            return 0.0;
        }

        @Override
        public void markDelete() {
        }

        @Override
        public boolean setNumeric(int index, double value) {
            return false;
        }

        @Override
        public long getBlobLength(int index) {
            return 0L;
        }

        @Override
        public Object getComplex(int index) {
            return null;
        }

        @Override
        public boolean setComplex(int index, Object value) {
            return false;
        }

        @Override
        public boolean getNullFlag(int index) {
            return true;
        }

        @Override
        public boolean setNullFlag(int index) {
            return false;
        }

        @Override
        public boolean getModFlag(int index) {
            return false;
        }

        @Override
        public TableDescriptor getTableDescriptor() {
            return Directory.this.tableDesc;
        }

        @Override
        public boolean isToBeDeleted() {
            return false;
        }

        @Override
        public boolean isMarkDelete() {
            return false;
        }

        @Override
        public boolean isNew() {
            return false;
        }

        @Override
        public boolean isModified() {
            return false;
        }

        @Override
        public Iterator<FieldDescriptor> getChangedFieldsIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isChangedFieldsEquals(DoubleSet changedFields) {
            return false;
        }

        @Override
        public void saved() {
        }

        @Override
        public void internalTransferTo(Rowset rowset) {
        }

        @Override
        public void reuse(TableDescriptor tableDescriptor) {
        }
    }
}

