/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.ObjectSizer;
import inform.agent.Core;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.Directory;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.Task;
import org.mozilla.javascript.Scriptable;

public class DirectoryField
extends DatasourceField {
    @ObjectSizer.HintShared
    private Task task;
    private TableDescriptor referenceTable;
    private FieldDescriptor referenceField;
    private Directory dir;
    public final SSContext.Component ssContext;
    private static final String[] availableJSMethods = new String[]{"fieldByName"};

    DirectoryField(SSContext parentContext, FieldDescriptor fieldDesc, Task task, RowsetAccessor ra) throws InformException {
        super(fieldDesc, ra);
        this.defineFunctionProperties(availableJSMethods, DirectoryField.class, 0);
        this.ssContext = parentContext == null ? null : new SSContext.Component(parentContext, 8);
        this.task = task;
        if (this.ssContext != null) {
            this.ssContext.tableId = this.ssContext.nodeId = this.getDescriptor().getReferenceId();
        }
    }

    @Override
    public Scriptable getAsDate() throws InformException {
        throw new UnsupportedOperationException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0442\u0438\u043f\u0430 \u0414\u0430\u0442\u0430/\u0412\u0440\u0435\u043c\u044f \u0434\u043b\u044f \u043f\u043e\u043b\u044f \u0442\u0438\u043f\u0430 \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public void setAsDate(Scriptable value) throws InformException {
        throw new UnsupportedOperationException("\u041f\u0440\u0438\u0441\u0432\u043e\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0442\u0438\u043f\u0430 \u0414\u0430\u0442\u0430/\u0412\u0440\u0435\u043c\u044f \u0434\u043b\u044f \u043f\u043e\u043b\u044f \u0442\u0438\u043f\u0430 \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public double getAsDateValue() throws InformException {
        throw new UnsupportedOperationException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0442\u0438\u043f\u0430 \u0414\u0430\u0442\u0430/\u0412\u0440\u0435\u043c\u044f \u0432 \u0432\u0438\u0434\u0435 \u0447\u0438\u0441\u043b\u0430 \u0434\u043b\u044f \u043f\u043e\u043b\u044f \u0442\u0438\u043f\u0430 \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public void setAsDateValue(double value) throws InformException {
        throw new UnsupportedOperationException("\u041f\u0440\u0438\u0441\u0432\u043e\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0442\u0438\u043f\u0430 \u0414\u0430\u0442\u0430/\u0412\u0440\u0435\u043c\u044f \u0432 \u0432\u0438\u0434\u0435 \u0447\u0438\u0441\u043b\u0430 \u0434\u043b\u044f \u043f\u043e\u043b\u044f \u0442\u0438\u043f\u0430 \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public String getAsString() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return "";
        }
        Row row = this.ra.getCurrentRow();
        if (row == null) {
            return "";
        }
        int index = this.getDescriptor().getIndex();
        return row.getNullFlag(index) ? "" : NumberConverter.doubleToString(row.getNumeric(index));
    }

    @Override
    public void setAsString(String value) throws InformException {
        throw new UnsupportedOperationException("\u041f\u0440\u0438\u0441\u0432\u043e\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0442\u0438\u043f\u0430 \u0421\u0442\u0440\u043e\u043a\u0430 \u0434\u043b\u044f \u043f\u043e\u043b\u044f \u0442\u0438\u043f\u0430 \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public double getAsNumber() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return 0.0;
        }
        return this.ra.getCurrentRow().getNumeric(this.getDescriptor().getIndex());
    }

    @Override
    public void setAsNumber(Double value) throws Exception {
        Row r = this.ra.getCurrentRow();
        if (r.setNumeric(this.getDescriptor().getIndex(), value)) {
            this.notifyModified();
        }
    }

    @Override
    public Object get(String name, Scriptable start) {
        try {
            if (name.equals("directory")) {
                if (this.dir == null) {
                    this.loadDirectory();
                }
                return this.dir;
            }
            Object result = NOT_FOUND;
            result = super.get(name, start);
            if (result == NOT_FOUND && !name.equals("Function")) {
                if (this.dir == null) {
                    this.loadDirectory();
                }
                if ((result = this.dir.get(name, start)) == NOT_FOUND && name.equals("_name")) {
                    result = this.dir.get("name", start);
                }
            }
            return result;
        }
        catch (InformException ex) {
            Core.logger.error(null, ex);
            return NOT_FOUND;
        }
    }

    public DatasourceField getDirectoryField(int fieldId) throws InformException {
        if (this.dir == null) {
            this.loadDirectory();
        }
        return this.dir.getFieldById(fieldId);
    }

    private void loadDirectory() throws InformException {
        if (this.ssContext != null && this.ssContext.parent != null && this.ssContext.parent instanceof SSContext.Component) {
            SSContext.Component parentContext = (SSContext.Component)this.ssContext.parent;
            this.ssContext.id = parentContext.id;
            this.ssContext.script = parentContext.script + "." + this.desc.getIdent();
        }
        this.referenceTable = TableDescriptor.get(this.getDescriptor().getReferenceId());
        this.referenceField = this.referenceTable.getFieldDescriptor(this.getDescriptor().getRefFieldId());
        assert (this.referenceField != null);
        this.dir = new Directory(this.ssContext, this, this.task, this.ra, this.getDescriptor(), this.referenceTable);
    }

    @Override
    public boolean getAsBoolean() throws InformException {
        throw new UnsupportedOperationException("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0434\u043b\u044f \u043f\u043e\u043b\u044f \u0442\u0438\u043f\u0430 \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    public void setAsBoolean(boolean value) throws InformException {
        throw new UnsupportedOperationException("\u041f\u0440\u0438\u0441\u0432\u043e\u0435\u043d\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0434\u043b\u044f \u043f\u043e\u043b\u044f \u0442\u0438\u043f\u0430 \u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
    }

    @Override
    protected void assignNotNullValue(Object value) {
        double val = ValueCaster.toNumber(value).doubleValue();
        this.checkNumberValue(val);
        if (this.ra.getCurrentRow().setNumeric(this.getDescriptor().getIndex(), val)) {
            this.notifyModified();
        }
    }

    @Override
    public boolean isCompatibleValue(Object value) {
        return value instanceof Number;
    }

    public void detachDirectoryRowset() {
        if (this.dir != null) {
            this.dir.detach();
        }
    }

    public Object fieldByName(String name) throws InformException {
        DatasourceField field;
        if (this.dir == null) {
            this.loadDirectory();
        }
        if ((field = this.dir.getFieldByName(name)) == null) {
            throw new InformException("\u041f\u043e\u043b\u0435 " + name + " \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e\u043c \u043f\u043e\u043b\u0435 " + this.desc.getIdent() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
        }
        return field;
    }
}

