/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.collections.DoubleIntegerMap;
import inform.adt.taggedio.TaggedReader;
import inform.agent.document.HTMLParser;
import inform.agent.mtd.MtdEngine;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.FileSystemLibrary;
import inform.agent.scripts.MailAttachment;
import inform.agent.scripts.MailMessage;
import inform.agent.web.DocumentGenerator;
import jakarta.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DocumentsLibrary
extends ScriptableObject {
    private static final String[] availJSFunctionsNames = new String[]{"convertToPlainText", "convertFromHtml"};
    private boolean fSpace = false;
    private String buffer = "";
    private final int maxLen = Integer.MAX_VALUE;

    public DocumentsLibrary(Scriptable scope) {
        this.setParentScope(scope);
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    @Override
    public String getClassName() {
        return "DocumentsLibrary";
    }

    private String TextItemPresentation(byte[] content, int tag) throws IOException {
        Object Result2 = "";
        boolean isLast = false;
        TaggedReader reader = new TaggedReader(content);
        while (reader.getNextTag() != 0) {
            if (reader.getCurrentTag() == tag) {
                Result2 = reader.getAnsi();
                continue;
            }
            if (reader.getCurrentTag() != 4) continue;
            isLast = true;
        }
        Result2 = ((String)Result2).trim();
        if (isLast) {
            Result2 = "\n" + (String)Result2;
        }
        return Result2;
    }

    private boolean ItemsVisitor(int tag, byte[] bytes) throws IOException {
        String tmpstr = "";
        if (!this.fSpace) {
            this.buffer = this.buffer + " ";
        }
        this.fSpace = true;
        switch (tag) {
            case 1: {
                tmpstr = this.TextItemPresentation(bytes, 1);
                break;
            }
            case 4: {
                tmpstr = this.TextItemPresentation(bytes, 4);
                break;
            }
            case 9: {
                tmpstr = this.TextItemPresentation(bytes, 4);
            }
        }
        if (tmpstr.length() > 0) {
            if (this.buffer.length() >= 0x7FFFFFFC) {
                this.buffer = this.buffer + "...";
                return true;
            }
            this.buffer = this.buffer + tmpstr;
            this.fSpace = false;
        }
        return false;
    }

    public String convertToPlainText(Object Obj) throws IOException {
        if (Obj instanceof BinaryObject) {
            TaggedReader reader = new TaggedReader(BinaryObject.toInputStream((BinaryObject)Obj));
            this.fSpace = true;
            this.buffer = "";
            while (reader.getNextTag() != 0) {
                block0 : switch (reader.getCurrentTag()) {
                    case 1: {
                        reader.skip();
                        TaggedReader docrdr = reader.getStreamReader(202);
                        while (docrdr.getNextTag() != 0) {
                            int tag = docrdr.getCurrentTag();
                            byte[] bytes = docrdr.getRaw();
                            if (docrdr.getNextTag() == 202) {
                                bytes = docrdr.getRaw();
                            } else {
                                docrdr.tagback();
                            }
                            if (!this.ItemsVisitor(tag, bytes)) continue;
                            break block0;
                        }
                        break;
                    }
                }
            }
            return this.buffer.replaceFirst("\n", "");
        }
        return "";
    }

    public BinaryObject convertFromHtml(Object obj) throws Throwable {
        if (obj instanceof String || obj instanceof ConsString) {
            byte[] content = HTMLParser.getInstance().parse(obj.toString(), null);
            return new BinaryObject(content);
        }
        throw new InformException("convertFromHtml: \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f html-\u0441\u0442\u0440\u043e\u043a\u043e\u0439");
    }

    static MailMessage convertToMailMessage(BinaryObject obj) throws IOException {
        final MailMessage result = new MailMessage(null);
        DocumentGenerator g = new DocumentGenerator("mail"){
            DoubleIntegerMap node2img;
            int cidgen;
            {
                super(styleKey);
                this.node2img = new DoubleIntegerMap();
                this.cidgen = 0;
            }

            protected int internalWriteImageBytes(byte[] content) {
                try {
                    MailAttachment ma = result.getAttachments().add();
                    ma.loadFromBytes(content);
                    String cid = "image-" + ++this.cidgen;
                    MimeBodyPart c = ma.getContent();
                    c.setFileName(cid + "." + FileSystemLibrary.getFileType(content));
                    c.setContentID(cid);
                    return this.cidgen;
                }
                catch (Exception e) {
                    throw InformException.wrap(e);
                }
            }

            @Override
            protected String generateImageFromBytes(byte[] content) {
                return "cid:image-" + this.internalWriteImageBytes(content);
            }

            @Override
            protected String generateImageFromNode(double nodeId) {
                int img;
                if (this.node2img.contains(nodeId)) {
                    img = this.node2img.lget();
                } else {
                    img = this.internalWriteImageBytes(MtdEngine.getNodeContent(nodeId));
                    this.node2img.put(nodeId, img);
                }
                return "cid:image-" + img;
            }
        };
        StringWriter buff = new StringWriter();
        PrintWriter pw = new PrintWriter(buff);
        g.generate(new TaggedReader(BinaryObject.toInputStream(obj), obj.getSize()), pw, null);
        pw.flush();
        result.setTextHtml(buff.toString());
        return result;
    }
}

