/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.agent.RequestHeader;
import inform.agent.ServerSideHost;
import inform.agent.db.GeneratedSql;
import inform.agent.db.LinkDescriptor;
import inform.agent.db.request.GetTableRecordsRef;
import inform.agent.mtd.AccessMask;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.GetSqlQueryNodeRequest;
import inform.agent.scripts.QueryNodeRequestException;
import inform.agent.scripts.sql.ExpressionFilterQuery;
import inform.agent.scripts.sql.Query;
import inform.agent.scripts.sql.QueryGeneratedSql;
import inform.agent.scripts.sql.QueryKind;
import inform.agent.scripts.util.QueryPostProcess;
import java.io.IOException;
import org.mozilla.javascript.Context;

public class ExecuteQueryNodeRequest
extends GetSqlQueryNodeRequest {
    private static final int NO_DATA = 1;
    protected final GetTableRecordsRef.Params params = new GetTableRecordsRef.Params();
    double userNodeId = 0.0;
    double tableNodeId = 0.0;
    double ownerNodeId = 0.0;
    int ownerDatasourceId = 0;
    byte[] expressionFilter = null;

    public ExecuteQueryNodeRequest(RequestHeader rq) {
        super(rq);
    }

    public StringBuilder getLogInfo() {
        StringBuilder logInfo = new StringBuilder();
        logInfo.append("rq: ").append(506).append(" u: ").append(NumberConverter.doubleToString(this.userNodeId)).append(" t: ").append(NumberConverter.doubleToString(this.tableNodeId));
        logInfo.append(" q: ").append(NumberConverter.doubleToString(this.getNodeID()));
        if (this.ownerNodeId != 0.0) {
            logInfo.append(" o:").append((long)this.ownerNodeId);
        }
        if (this.ownerDatasourceId != 0) {
            logInfo.append(" uid:").append(this.ownerDatasourceId);
        }
        return logInfo;
    }

    @Override
    protected void execute(Context context) throws Exception {
        if (this.params.fetchLimit == 0) {
            return;
        }
        this.params.nullSortKind = this.nullSortType;
        this.query.setBlobReceiving(this.params.blobReceiving);
        this.userNodeId = this.getUserID();
        Node node = MtdEngine.getNode(this.tableNodeId);
        if (node == null) {
            return;
        }
        if (AccessMask.accessDenied(0x4000000, this.security().accessMask(node))) {
            return;
        }
        if (this.expressionFilter != null && this.expressionFilter.length != 0) {
            ExpressionFilterQuery filterQuery = new ExpressionFilterQuery((ServerSideHost)this, this.query);
            filterQuery.load(new TaggedReader(this.expressionFilter));
            this.query.setExpressionFilter(filterQuery);
        }
        String sqlText = this.query.generateSqlText(context, null);
        try {
            QueryGeneratedSql generatedSql = new QueryGeneratedSql(this.query, sqlText, this.query.getSqlParameters());
            if (this.query.getFetchLimit() > 0) {
                this.params.fetchLimit = this.query.getFetchLimit();
            }
            QueryPostProcess qpp = null;
            this.sendTableData(generatedSql, qpp);
        }
        catch (Throwable ex) {
            StringBuilder detailing = this.getLogInfo();
            detailing.append("SQL \u0442\u0435\u043a\u0441\u0442: <").append(sqlText).append(">\n");
            throw InformException.detail(ex, detailing.toString());
        }
    }

    private void sendTableData(GeneratedSql generatedSql, QueryPostProcess qpp) throws Exception {
        assert (this.params.fetchLimit > 0);
        this.params.tableDescriptor = this.query.getResultMetadata().getDescriptor();
        this.params.needRealId = this.query.getResultKind() == Query.ResultKind.EDITABLE;
        this.params.overrideDatabaseID = this.query.overriderDatabaseID;
        this.params.bomStringMpde = this.rq.client.isClientLevel(6);
        GetTableRecordsRef.executeSql(this.ssContext, this, generatedSql, this.dbManager, this.params);
    }

    @Override
    protected void loadTag(int tag, TaggedReader reader) throws IOException, InformException, QueryNodeRequestException {
        switch (tag) {
            case 5: {
                this.tableNodeId = reader.getDouble();
                break;
            }
            case 12: {
                this.query.addSortField(reader);
                break;
            }
            case 22: {
                if (this.query.getQueryKind() == QueryKind.SQL) {
                    this.query.throwError("\u0421\u0432\u044f\u0437\u044c \u0438 \u0441\u0432\u044f\u0437\u044c \u043f\u043e \u043f\u043e\u043b\u044f\u043c \u0441 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u043c \u0441 \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u043c \u0432 \u0432\u0438\u0434\u0435 SQL \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u044e\u0442\u0441\u044f");
                }
                TaggedReader stream = reader.getStreamReader();
                LinkDescriptor relations = new LinkDescriptor();
                relations.loadRelations(stream);
                this.query.setTableRelations(relations);
                break;
            }
            case 23: {
                int limit = reader.getInt();
                if (limit >= 0) {
                    this.params.fetchLimit = limit;
                }
                if (this.params.fetchLimit == 0) {
                    throw new QueryNodeRequestException(1);
                }
                this.query.setFetchLimit(limit);
                break;
            }
            case 48: {
                this.query.setPagedFetch();
                break;
            }
            case 39: {
                this.params.blobReceiving = reader.getInt();
                break;
            }
            case 41: {
                this.rqstat.ownerId = this.ownerNodeId = reader.getDouble();
                this.ssContext.ownerId = this.ownerNodeId;
                break;
            }
            case 42: {
                this.rqstat.ownerDatasourceId = this.ownerDatasourceId = reader.getInt();
                this.ssContext.uid = this.ownerDatasourceId;
                break;
            }
            case 46: {
                this.expressionFilter = reader.getRaw();
                break;
            }
            default: {
                super.loadTag(tag, reader);
            }
        }
    }
}

