/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.ServerSideHost;
import inform.agent.db.types.DataType;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatManager;
import inform.common.SmartScriptableObject;
import org.mozilla.javascript.Scriptable;

public class FormatLibrary
extends SmartScriptableObject {
    private final ServerSideHost ssHost;

    FormatLibrary(Scriptable scope, ServerSideHost ssHost) {
        this.ssHost = ssHost;
        this.setParentScope(scope);
        for (FormatManager.FormatType f : FormatManager.FormatType.values()) {
            FormatLibrary.putConstProperty(this, f.name(), f.getFormatId());
        }
    }

    @Override
    public String getClassName() {
        return "Formats";
    }

    @SmartScriptableObject.FunctionTag
    public Format createFormat(int id) throws InformException {
        return FormatManager.createFormat(id, DataType.NONE, null, true);
    }

    @SmartScriptableObject.FunctionTag
    public Format createStdFormat(int typeId) throws InformException {
        return FormatManager.getStdFormat(DataType.getDataTypeById(typeId));
    }
}

