/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.types.Geometry;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.libs.SdoLibrary;
import java.io.IOException;
import java.sql.SQLException;
import org.mozilla.javascript.Scriptable;

public class GeometryField
extends DatasourceField {
    protected GeometryField(FieldDescriptor desc, RowsetAccessor ra) {
        super(desc, ra);
        this.defineProperty("asGeometry", GeometryField.class, 0);
    }

    @Override
    public double getAsDateValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsDateValue(double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAsString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsString(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getAsNumber() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsNumber(Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Scriptable getAsDate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsDate(Scriptable value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getAsBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsBoolean(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void assignNotNullValue(Object value) {
        this.setAsGeometry(value);
    }

    @Override
    public boolean isCompatibleValue(Object value) {
        return value instanceof Geometry || value instanceof SdoLibrary.GeoObject;
    }

    Object getObject() {
        if (!this.ra.isCurrentRowAvailable()) {
            return null;
        }
        return this.ra.getCurrentRow().getComplex(this.getDescriptor().getIndex());
    }

    @Override
    public Object getValue() throws Exception {
        if (this.getIsNull()) {
            return null;
        }
        switch (this.desc.getType()) {
            case GEOMETRY: {
                return this.getObject();
            }
        }
        return super.getValue();
    }

    public Object getAsGeometry() throws SQLException, IOException {
        Geometry g = (Geometry)this.getObject();
        return g == null ? null : SdoLibrary.createGeometryObject(g.toWKB());
    }

    public void setAsGeometry(Object value) {
        boolean modified;
        if (value == null) {
            modified = this.ra.getCurrentRow().setComplex(this.getDescriptor().getIndex(), value);
        } else if (value instanceof SdoLibrary.GeoObject) {
            try {
                modified = this.ra.getCurrentRow().setComplex(this.getDescriptor().getIndex(), ((SdoLibrary.GeoObject)value).toGeometry());
            }
            catch (Throwable t) {
                throw InformException.wrap(t);
            }
        } else {
            modified = false;
        }
        if (modified) {
            this.notifyModified();
        }
    }
}

