/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.agent.db.FieldDescriptor;
import inform.agent.db.Row;
import inform.agent.db.RowsetAccessor;
import inform.agent.db.TableDescriptor;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.DatasourceField;
import java.util.Date;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class NumericField
extends DatasourceField {
    private final boolean isReadonlyPrimaryKey;

    private static boolean isReadonlyPrimaryKey(FieldDescriptor desc, RowsetAccessor ra) {
        if (desc.isPrimaryKey()) {
            TableDescriptor table = ra.getTableDescriptor();
            return table.getKind() != TableDescriptor.Kind.INTERNAL && table.getRecordIdField() != null;
        }
        return false;
    }

    protected NumericField(FieldDescriptor desc, RowsetAccessor ra) {
        super(desc, ra);
        this.isReadonlyPrimaryKey = NumericField.isReadonlyPrimaryKey(desc, ra);
    }

    @Override
    public double getAsDateValue() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return 0.0;
        }
        return this.ra.getCurrentRow().getNumeric(this.getDescriptor().getIndex());
    }

    @Override
    public void setAsDateValue(double value) throws InformException {
        this.setAsNumber(value);
    }

    @Override
    public String getAsString() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return "";
        }
        int index = this.getDescriptor().getIndex();
        Row row = this.ra.getCurrentRow();
        return row.getNullFlag(index) ? "" : NumberConverter.doubleToString(row.getNumeric(index));
    }

    @Override
    public void setAsString(String value) throws InformException {
        this.setAsNumber(Double.parseDouble(value));
    }

    @Override
    public double getAsNumber() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return 0.0;
        }
        return this.ra.getCurrentRow().getNumeric(this.getDescriptor().getIndex());
    }

    private static double roundValue(double value, int precision) {
        long intVal = (long)value;
        if ((double)intVal == value) {
            return value;
        }
        return NumberConverter.simpleRoundTo(value, -precision);
    }

    @Override
    public void setAsNumber(Double value) throws InformException {
        if (this.desc.getAutoValueGenerator() == FieldDescriptor.AutoValueGenerator.BLOBSIZE) {
            return;
        }
        this.checkNumberValue(value);
        Row row = this.ra.getCurrentRow();
        this.checkAssignable(row);
        if (this.desc.getType() == DataType.FLOAT && this.desc.getPrecision() >= 0) {
            value = NumericField.roundValue(value, this.desc.getPrecision());
        }
        if (row.setNumeric(this.getDescriptor().getIndex(), value)) {
            this.notifyModified();
        }
    }

    @Override
    public Scriptable getAsDate() throws InformException {
        double dateValue = this.ra.isCurrentRowAvailable() ? this.ra.getCurrentRow().getNumeric(this.getDescriptor().getIndex()) : 0.0;
        Object[] ctorArgs = new Object[]{DateTime.toUnixTime(dateValue)};
        return Context.getCurrentContext().newObject(this, "Date", ctorArgs);
    }

    @Override
    public void setAsDate(Scriptable value) throws InformException {
        this.setAsNumber(DateTime.fromUnixTime(((Date)Context.jsToJava(value, Date.class)).getTime()));
    }

    @Override
    public boolean getAsBoolean() throws InformException {
        if (!this.ra.isCurrentRowAvailable()) {
            return false;
        }
        return this.ra.getCurrentRow().getNumeric(this.getDescriptor().getIndex()) != 0.0;
    }

    @Override
    public void setAsBoolean(boolean value) throws InformException {
        Row row = this.ra.getCurrentRow();
        this.checkAssignable(row);
        if (row.setNumeric(this.getDescriptor().getIndex(), value ? 1.0 : 0.0)) {
            this.notifyModified();
        }
    }

    @Override
    protected void assignNotNullValue(Object value) {
        this.setAsNumber(ValueCaster.toNumber(value).doubleValue());
    }

    @Override
    public boolean isCompatibleValue(Object value) {
        return value instanceof Number || value instanceof Boolean;
    }

    private void checkAssignable(Row row) {
        if (this.isReadonlyPrimaryKey && !row.isNew()) {
            throw new InformException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0439 \u043a\u043b\u044e\u0447 \u0432\u043d\u0435\u0448\u043d\u0435\u0439 \u0442\u0430\u0431\u043b\u0438\u0446\u044b");
        }
    }
}

