/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.Strings;
import inform.agent.Core;
import inform.agent.Ini;
import inform.agent.scripts.MailMessage;
import inform.agent.scripts.MailMessagesList;
import inform.common.SmartScriptableObject;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.util.ArrayList;
import java.util.Properties;

public class POP3Connection
extends SmartScriptableObject {
    private static final int KNOWN_SSL_PORT = 995;
    private Store store = null;
    private MailMessagesList msgs;
    private Folder _inbox;
    private String host = "";
    private String username = "";
    private String password = "";
    static int attnum = 1;

    POP3Connection() {
    }

    private Folder inbox() throws MessagingException {
        if (this._inbox == null) {
            this._inbox = this.store.getFolder("INBOX");
        }
        if (!this._inbox.isOpen()) {
            this._inbox.open(2);
        }
        return this._inbox;
    }

    @SmartScriptableObject.PropertyTag
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @SmartScriptableObject.PropertyTag
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @SmartScriptableObject.PropertyTag
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @SmartScriptableObject.PropertyTag
    public MailMessagesList getMessages() throws NoSuchProviderException, MessagingException, Exception {
        if (this.msgs != null) {
            return this.msgs;
        }
        Folder inbox = this.inbox();
        try {
            Message[] inboxMsgs = inbox.getMessages();
            this.msgs = new MailMessagesList();
            for (int i = 0; i < inboxMsgs.length; ++i) {
                Message inMsg = inboxMsgs[i];
                MailMessage msg = new MailMessage(inMsg);
                MailMessage.dumpEnvelope(inMsg, msg);
                msg.setPop3conn(this);
                this.msgs.getMsgs().add(msg);
            }
        }
        catch (Exception e) {
            throw InformException.wrap(e, String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043f\u0438\u0441\u0435\u043c \u0441 POP3 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 (host: %s)", this.host));
        }
        return this.msgs;
    }

    @SmartScriptableObject.FunctionTag
    public void connect() throws MessagingException, InformException {
        try {
            Properties props = new Properties(System.getProperties());
            props.put("mail.pop3.starttls.enable", "true");
            props.put("mail.pop3.ssl.checkserveridentity", "false");
            props.put("mail.pop3.ssl.trust", "*");
            String host = this.host;
            int port = -1;
            int pidx = host.indexOf(58);
            if (pidx != -1) {
                port = Integer.parseInt(host.substring(pidx + 1));
                host = host.substring(0, pidx);
                if (port == 995) {
                    props.put("mail.pop3.ssl.enable", "true");
                }
            }
            if (!Strings.isVoid(Ini.DebugMail)) {
                props.put("mail.debug", "true");
                if (Ini.DebugMail.contains("auth")) {
                    props.put("mail.debug.auth", "true");
                }
            }
            Session session = Session.getInstance(props, null);
            this.store = session.getStore("pop3");
            this.store.connect(host, port, this.username, this.password);
        }
        catch (Throwable e) {
            if (this.store != null) {
                this.store.close();
            }
            this.store = null;
            throw InformException.wrap(e, String.format("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 POP3 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u043c (host: %s, username: %s)", this.host, this.username));
        }
    }

    Message[] getDeletedMessages() {
        int len = 0;
        for (MailMessage m : this.msgs.getMsgs()) {
            if (!m.isDeleted()) continue;
            ++len;
        }
        if (len == 0) {
            return null;
        }
        Message[] result = new Message[len];
        ArrayList<MailMessage> list = this.msgs.getMsgs();
        int ri = 0;
        for (int i = 0; i < list.size(); ++i) {
            MailMessage m = list.get(i);
            if (!m.isDeleted()) continue;
            result[ri++] = m.internalMessage();
        }
        return result;
    }

    @SmartScriptableObject.FunctionTag
    public void close() throws MessagingException, InformException {
        if (this.store == null) {
            return;
        }
        try {
            try {
                Message[] deleted;
                if (this.msgs != null && (deleted = this.getDeletedMessages()) != null) {
                    try {
                        this.inbox().setFlags(deleted, new Flags(Flags.Flag.DELETED), true);
                    }
                    catch (Exception e) {
                        Core.logger.error("deleting messages", e);
                    }
                }
                if (this._inbox != null) {
                    this._inbox.close(true);
                    this._inbox = null;
                }
            }
            finally {
                this.store.close();
                this.store = null;
                this.msgs = null;
            }
        }
        catch (Throwable e) {
            throw InformException.wrap(e, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 POP3 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f");
        }
    }
}

