/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.common.SmartScriptableObject;
import org.mozilla.javascript.Scriptable;

public class PageFormatLibrary
extends SmartScriptableObject {
    public PageFormatLibrary(Scriptable scope) {
        this.setParentScope(scope);
        for (PageFormat e : PageFormat.values()) {
            PageFormatLibrary.putConstProperty(this, e.name(), e.id);
        }
    }

    public static PageFormat pageFormat(int id) {
        for (PageFormat e : PageFormat.values()) {
            if (e.id != id) continue;
            return e;
        }
        return PageFormat.CustomPageFormat;
    }

    public static PageFormat pageFormat(double width, double height, boolean landscape) {
        for (PageFormat e : PageFormat.values()) {
            if (e.width != width || e.height != height || e.landscape != landscape) continue;
            return e;
        }
        return PageFormat.CustomPageFormat;
    }

    public static enum PageFormat {
        CustomPageFormat(0, -1.0, -1.0, false),
        A5(1, 148.0, 210.0, false),
        A5Landscape(2, 210.0, 148.0, true),
        A4(3, 210.0, 297.0, false),
        A4Landscape(4, 297.0, 210.0, true),
        A3(5, 297.0, 420.0, false),
        A3Landscape(6, 420.0, 297.0, true);

        public final int id;
        public final double width;
        public final double height;
        public final boolean landscape;

        private PageFormat(int id, double width, double height, boolean landscape) {
            this.id = id;
            this.width = width;
            this.height = height;
            this.landscape = landscape;
        }
    }
}

