/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.taggedio.LittleEndianDataInputStream;
import inform.agent.scripts.FileSystemLibrary;
import inform.common.SmartScriptableObject;
import java.io.Closeable;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class ScriptableBinaryFileReader
extends SmartScriptableObject
implements FileSystemLibrary.BinaryReader {
    protected DataInput input;
    protected boolean eof = false;

    public ScriptableBinaryFileReader(Scriptable scope, InputStream input) {
        this.setParentScope(scope);
        this.input = new LittleEndianDataInputStream(input);
    }

    @Override
    public String getClassName() {
        return "BinaryFileReader";
    }

    @SmartScriptableObject.PropertyTag
    public boolean getBigEndian() {
        return false;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getEof() {
        return this.eof;
    }

    @SmartScriptableObject.FunctionTag
    public Object readByte() {
        try {
            int b = this.input.readByte();
            return b >= 0 ? b : 256 - b;
        }
        catch (EOFException e) {
            this.eof = true;
            return Undefined.instance;
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx(e);
            return Undefined.instance;
        }
    }

    @SmartScriptableObject.FunctionTag
    public Object readInt16() {
        try {
            return this.input.readShort();
        }
        catch (EOFException e) {
            this.eof = true;
            return Undefined.instance;
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx(e);
            return Undefined.instance;
        }
    }

    @SmartScriptableObject.FunctionTag
    public Object readInt32() {
        try {
            return this.input.readInt();
        }
        catch (EOFException e) {
            this.eof = true;
            return Undefined.instance;
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx(e);
            return Undefined.instance;
        }
    }

    @SmartScriptableObject.FunctionTag
    public Object readUInt32() {
        try {
            int i = this.input.readInt();
            return i >= 0 ? (long)i : 0x100000000L - (long)i;
        }
        catch (EOFException e) {
            this.eof = true;
            return Undefined.instance;
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx(e);
            return Undefined.instance;
        }
    }

    @SmartScriptableObject.FunctionTag
    public Object readSingle() {
        try {
            return Float.valueOf(this.input.readFloat());
        }
        catch (EOFException e) {
            this.eof = true;
            return Undefined.instance;
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx(e);
            return Undefined.instance;
        }
    }

    @SmartScriptableObject.FunctionTag
    public Object readDouble() {
        try {
            return this.input.readDouble();
        }
        catch (EOFException e) {
            this.eof = true;
            return Undefined.instance;
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx(e);
            return Undefined.instance;
        }
    }

    @SmartScriptableObject.FunctionTag
    public void close() {
        try {
            ((Closeable)((Object)this.input)).close();
        }
        catch (Exception e) {
            Context.throwAsScriptRuntimeEx(e);
        }
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return ((InputStream)((Object)this.input)).read(buffer, offset, length);
    }
}

