/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.Core;
import inform.agent.ServerSideHost;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.Task;
import java.io.IOException;

public class ServerTask
extends ServerSideExecutable {
    private static final int TAG_SS_ONEXECUTE = 3;
    private String onExecute;
    private boolean isolated = false;

    public ServerTask(SSContext parentConext, double nodeID, ServerSideHost ssHost, AbstractConnectionManager dbManager, Task parent) {
        super(parentConext, 7, nodeID, ssHost, dbManager, parent);
        if (this.ssContext != null) {
            this.ssContext.nodeId = nodeID;
            this.ssContext.script = "module";
        }
        ServerTask.putConstProperty(this, "moduleID", nodeID);
    }

    @Override
    public void setIsolated() {
        if (this.isolated) {
            return;
        }
        this.isolated = true;
        this.dbManager = ConnectionManager.capture(-1, this.getHost(), "ServerTask::setIsolated");
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            if (this.isolated) {
                this.isolated = false;
                try {
                    this.dbManager.release();
                }
                catch (Throwable e) {
                    Core.logger.error("ServerTask[isolated]::close", e);
                }
                this.dbManager = null;
            }
        }
    }

    @Override
    protected void loadTag(int tag, TaggedReader reader) throws IOException, TaggedReaderException {
        switch (tag) {
            case 3: {
                this.onExecute = reader.getAnsi();
            }
        }
    }

    @Override
    public String getClassName() {
        return "ServerTask";
    }

    public String getOnExecute() {
        return this.onExecute;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public byte[] getModifiedParameters() throws IOException {
        return this.parameters != null ? this.parameters.getModifiedParameters() : null;
    }
}

