/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.ByteArrayOutputStream;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.Core;
import inform.agent.RequestHeader;
import inform.agent.db.AbstractConnectionManager;
import inform.agent.db.Row;
import inform.agent.db.connect.ConnectionManager;
import inform.agent.mtd.AuditJournal;
import inform.agent.mtd.MtdEngine;
import inform.agent.mtd.nodes.Node;
import inform.agent.scripts.Parameter;
import inform.agent.scripts.SSContext;
import inform.agent.scripts.ScriptableRequest;
import inform.agent.scripts.ServerTask;
import inform.agent.scripts.TaggedIOLibrary;
import inform.agent.scripts.Task;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashSet;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class ServerTaskRequest
extends ScriptableRequest {
    private static final int TAG_SERVER_TASK_MODIFIED_CONSTANTS = 1;
    private static final int TAG_SERVER_TASK_NODE_CONTENT = 2;
    public static final int TAG_SERVER_TASK_RESULT = 3;
    private static final int TAG_SERVER_TASK_DATASOURCE_PROFILE = 4;
    private byte[] constantsContent = null;
    private byte[] inputParametersContent = null;
    private StringBuilder logLine = new StringBuilder();

    public ServerTaskRequest(RequestHeader rq) {
        super(rq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Throwable {
        ByteArrayOutputStream result;
        double nodeID = this.getTranslatedNodeID();
        Node requestNode = MtdEngine.getNode(nodeID);
        AuditJournal journal = new AuditJournal(AuditJournal.Journal.EVENTS);
        AuditJournal.EventParams audit = null;
        if (journal.isEnabled() && requestNode != null && requestNode.isAuditEvents()) {
            audit = new AuditJournal.EventParams();
            audit.userId = this.getUserID();
            audit.loginId = this.getSessionID();
            audit.startTime = System.currentTimeMillis();
            audit.code = 3;
            audit.nodeId = nodeID;
        }
        Context cx = Core.asmoJsContextFactory.enterContext();
        ConnectionManager dbManager = ConnectionManager.capture(this.getRequestSessionID(), this, "rq:ServerTaskRequest");
        try {
            try {
                Node nodeInfo = nodeID == 0.0 ? null : MtdEngine.getValidNode(nodeID);
                try (ServerTask node = new ServerTask((SSContext)this.ssContext, nodeID, this, dbManager, null);){
                    byte[] content;
                    this.topLevelScope = ScriptableRequest.createTopLevelScope(cx, node, this, dbManager);
                    this.loadRequestContent(node, this.createRequestContentReader());
                    if (this.constantsContent != null) {
                        node.setConstantsContent(this.constantsContent);
                    }
                    if ((content = this.getServerTaskFromRequestContent(this.createRequestContentReader())) != null) {
                        node.load(new TaggedReader(new ByteArrayInputStream(content), content.length));
                        audit = null;
                    } else if (nodeInfo != null) {
                        node.load();
                    }
                    if (this.inputParametersContent != null) {
                        node.getParameters().loadParametersValues(node.getConstants(), new TaggedReader(this.inputParametersContent), this);
                    }
                    this.setServerSideExecutable(node);
                    node.setParentScope(this.getTopLevelScope());
                    this.setConstants(node.getConstants());
                    Object scriptResult = Undefined.instance;
                    node.executeScript(cx);
                    if (node.getOnExecute() == null || node.getOnExecute().length() <= 0) {
                        throw new InformException(String.format("\u041d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0441\u043e\u0431\u044b\u0442\u0438\u044f onExecute%s", nodeInfo == null ? "" : " \u0434\u043b\u044f " + nodeInfo.toLogString()));
                    }
                    scriptResult = ScriptableObject.callMethod(node, node.getOnExecute(), null);
                    if (dbManager.hasModifications()) {
                        StringBuilder message = new StringBuilder("\u0418\u043c\u0435\u044e\u0442\u0441\u044f \u043d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u044b\u0435 \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 ");
                        if (nodeInfo != null) {
                            message.append(nodeInfo.toLogString());
                        }
                        HashSet<Double> dsIds = new HashSet<Double>();
                        String delimiter = "";
                        for (Row r : dbManager.getModifiedRows()) {
                            dsIds.add(r.getTableDescriptor().getNodeId());
                        }
                        if (dsIds.size() > 1) {
                            message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0430\u0445 ");
                        } else {
                            message.append(" \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 ");
                        }
                        for (Double dsId : dsIds) {
                            message.append(String.format("%s%s", delimiter, NumberConverter.doubleToString(dsId)));
                            delimiter = ", ";
                        }
                        throw new InformException(message.toString());
                    }
                    dbManager.commit();
                    if (this.logLine.length() > 0) {
                        this.writeLogLine(this.logLine.toString());
                    }
                    result = this.prepareParametersAsResult(node, scriptResult);
                }
            }
            catch (Throwable ex) {
                if (audit != null) {
                    audit.remark = "Error: " + ex.toString();
                }
                throw ex;
            }
        }
        finally {
            try {
                ((AbstractConnectionManager)dbManager).release();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
            try {
                Context.exit();
            }
            catch (Throwable ex) {
                Core.logger.error(null, ex);
            }
            if (audit != null) {
                audit.stopTime = System.currentTimeMillis();
                journal.registrateEvent(this.ssContext, audit);
            }
        }
        if (result != null) {
            this.sendResult(result.toByteArray());
        } else {
            this.sendResult();
        }
    }

    private byte[] getServerTaskFromRequestContent(TaggedReader reader) throws IOException, TaggedReaderException {
        int tag;
        byte[] result = null;
        do {
            if ((tag = reader.getNextTag()) != 2) continue;
            result = reader.getSubStreamData();
            break;
        } while (tag != 0);
        return result;
    }

    private void loadRequestContent(Task task, TaggedReader reader) throws IOException, TaggedReaderException {
        int tag;
        do {
            tag = reader.getNextTag();
            switch (tag) {
                case 1: {
                    this.constantsContent = reader.getSubStreamData();
                    break;
                }
                case 153: {
                    this.inputParametersContent = reader.getSubStreamData();
                    break;
                }
                case 4: {
                    task.setDatasourceProfile();
                }
            }
        } while (tag != 0);
    }

    private ByteArrayOutputStream prepareParametersAsResult(ServerTask node, Object scriptResult) throws Exception {
        String profile;
        byte[] r;
        boolean hasReturnParams = false;
        ByteArrayOutputStream subOut = new ByteArrayOutputStream();
        TaggedWriter subWriter = new TaggedWriter(subOut);
        for (Parameter p : node.getParameters().values()) {
            if (!p.returnValue()) continue;
            hasReturnParams = true;
            node.getParameters().storeParameter(subWriter, p, true);
        }
        subWriter.flush();
        ByteArrayOutputStream out = null;
        TaggedWriter writer = null;
        if (hasReturnParams || scriptResult != Undefined.instance) {
            out = new ByteArrayOutputStream();
            writer = new TaggedWriter(out);
        }
        if (scriptResult != Undefined.instance && (r = TaggedIOLibrary.serializeObject(scriptResult)) != null && r.length != 0) {
            writer.putRaw(3, r);
        }
        if (hasReturnParams) {
            writer.putEmpty(153);
            writer.putRaw(202, subOut);
            writer.flush();
        }
        if (writer != null) {
            writer.flush();
        }
        if ((profile = node.getProfile()) != null) {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            TaggedWriter w = new TaggedWriter(o);
            w.putAnsi(13, profile);
            w.flush();
            this.sendRequestState(o.internalBuffer(), o.size());
        }
        return out;
    }

    @Override
    public void appendToLog(String msg) throws Exception {
        this.logLine.append(msg);
    }
}

