/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.scripts.AsmoFormatter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class StringsLibrary
extends ScriptableObject {
    private static final String[] availJSFunctionsNames = new String[]{"format", "trimLeft", "trimRight", "trimAll", "left", "replace", "upper", "lower", "chr", "right", "formatFloat"};
    private static final DecimalFormatSymbols defaultSymbols = StringsLibrary.getDefaultSymbols();

    public StringsLibrary(Scriptable scope) {
        this.setParentScope(scope);
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
    }

    @Override
    public String getClassName() {
        return "Strings";
    }

    public static Object format(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        if (args.length == 0) {
            Context.reportRuntimeError("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
            return null;
        }
        String formatStr = (String)Context.jsToJava(args[0], String.class);
        Object[] formatArgs = Arrays.copyOfRange(args, 1, args.length);
        AsmoFormatter f = new AsmoFormatter(formatStr, formatArgs);
        return Context.javaToJS(f.execute(), thisObj);
    }

    private static DecimalFormatSymbols getDefaultSymbols() {
        DecimalFormatSymbols result = new DecimalFormatSymbols(Locale.FRENCH);
        result.setGroupingSeparator(' ');
        result.setDecimalSeparator('.');
        return result;
    }

    public static Object formatFloat(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        if (args.length != 2) {
            Context.reportRuntimeError("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
            return null;
        }
        String formatStr = (String)Context.jsToJava(args[0], String.class);
        formatStr = formatStr.replace('\"', "'".charAt(0)).replaceAll("[eE][\\+\\-]?[#0]+", "E0");
        double value = (Double)Context.jsToJava(args[1], Double.class);
        DecimalFormat f = new DecimalFormat(formatStr, defaultSymbols);
        f.setGroupingSize(3);
        return Context.javaToJS(f.format(value), thisObj);
    }

    public Object trimLeft(String str) {
        int i;
        for (i = 0; i < str.length() && Character.isWhitespace(str.charAt(i)); ++i) {
        }
        if (i < str.length()) {
            return Context.javaToJS(str.substring(i), this);
        }
        return Context.javaToJS("", null);
    }

    public Object trimRight(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && Character.isWhitespace(str.charAt(i)); --i) {
        }
        if (i >= 0) {
            return Context.javaToJS(str.substring(0, i + 1), this);
        }
        return Context.javaToJS("", this);
    }

    public Object trimAll(String str) {
        return Context.javaToJS(str.trim(), this);
    }

    public Object left(String str, int n) throws InformException {
        if (n < 0) {
            throw new InformException("\u0412\u0442\u043e\u0440\u043e\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c");
        }
        if (n > str.length()) {
            return Context.javaToJS(str, this);
        }
        return Context.javaToJS(str.substring(0, n), this);
    }

    public Object right(String str, int n) throws InformException {
        if (n < 0) {
            throw new InformException("\u0412\u0442\u043e\u0440\u043e\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c");
        }
        if (n > str.length()) {
            return Context.javaToJS(str, this);
        }
        return Context.javaToJS(str.substring(str.length() - n, str.length()), this);
    }

    public Object replace(String str, String src, String dest) {
        return Context.javaToJS(str.replace(src, dest), this);
    }

    public Object upper(String str) {
        return Context.javaToJS(str.toUpperCase(), this);
    }

    public Object lower(String str) {
        return Context.javaToJS(str.toLowerCase(), this);
    }

    public Object chr(int ch) throws UnsupportedEncodingException {
        byte[] strBytes = new byte[]{(byte)ch};
        return Context.javaToJS(new String(strBytes, "windows-1251"), this);
    }

    public static String convertClientFormatStrToServer(String format) {
        String result = format.replace('\"', "'".charAt(0));
        return result;
    }
}

