/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.textdocuments.odt.OdtDocument;
import inform.agent.scripts.textdocuments.word.WordDocument;
import inform.common.SmartScriptableObject;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;

public class TextDocumentsLibrary
extends SmartScriptableObject {
    public static final int TEXTDOCUMENTS_PARAGRAPH = 1;
    public static final int TEXTDOCUMENTS_TABLE = 2;
    public static final int ALIGN_LEFT = 11;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 12;
    public static final int ALIGN_BOTH = 4;
    public static final int PICTURE_TYPE_PNG = 1;
    public static final int PICTURE_TYPE_JPEG = 2;
    private static final String MESSAGE_BADTYPE = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u0442\u0438\u043f\u043e\u043c '%s'. \u041f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c, \u043f\u043e\u043b\u0435\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b (\u0441 \u0442\u0438\u043f\u043e\u043c Blob \u0438\u043b\u0438 BlobFile) \u0438\u043b\u0438 \u0441\u0442\u0440\u043e\u043a\u043e\u0439 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c \u0444\u0430\u0439\u043b\u0430.";

    public TextDocumentsLibrary(Scriptable scope) {
        this.setParentScope(scope);
        TextDocumentsLibrary.putConstProperty(this, "TEXTDOCUMENTS_PARAGRAPH", 1);
        TextDocumentsLibrary.putConstProperty(this, "TEXTDOCUMENTS_TABLE", 2);
        TextDocumentsLibrary.putConstProperty(this, "ALIGN_LEFT", 11);
        TextDocumentsLibrary.putConstProperty(this, "ALIGN_CENTER", 2);
        TextDocumentsLibrary.putConstProperty(this, "ALIGN_RIGHT", 12);
        TextDocumentsLibrary.putConstProperty(this, "ALIGN_BOTH", 4);
        TextDocumentsLibrary.putConstProperty(this, "PICTURE_TYPE_PNG", 1);
        TextDocumentsLibrary.putConstProperty(this, "PICTURE_TYPE_JPEG", 2);
        for (UnderlinePatterns type : UnderlinePatterns.values()) {
            TextDocumentsLibrary.putConstProperty(this, "FONT_UNDERLINE_" + type.name(), type.getValue());
        }
    }

    @Override
    public String getClassName() {
        return "TextDocuments";
    }

    @SmartScriptableObject.FunctionTag
    public Object openDocument(Object dataSource, Object documentFormat) throws Exception {
        String fileFormat;
        if (documentFormat instanceof Undefined) {
            fileFormat = this.getFileFormat(dataSource.toString());
            if (fileFormat.equals("")) {
                throw new InformException(String.format(MESSAGE_BADTYPE, dataSource.getClass().getName()));
            }
        } else if (!documentFormat.toString().equalsIgnoreCase("DOCX") && !documentFormat.toString().equalsIgnoreCase("ODT")) {
            fileFormat = this.getFileFormat(documentFormat.toString());
            if (fileFormat.equals("")) {
                throw new InformException(String.format(MESSAGE_BADTYPE, dataSource.getClass().getName()));
            }
        } else {
            fileFormat = documentFormat.toString();
        }
        if (fileFormat != null) {
            if (fileFormat.equalsIgnoreCase("DOCX")) {
                if (dataSource instanceof String) {
                    return WordDocument.openWordDocument((Scriptable)this, (String)dataSource);
                }
                if (dataSource instanceof BinaryObject) {
                    return WordDocument.openWordDocument((Scriptable)this, (BinaryObject)dataSource);
                }
                if (dataSource instanceof DatasourceField) {
                    return WordDocument.openWordDocument((Scriptable)this, (DatasourceField)dataSource);
                }
            } else if (fileFormat.equalsIgnoreCase("ODT")) {
                if (dataSource instanceof String) {
                    return OdtDocument.openOdtDocument((Scriptable)this, (String)dataSource);
                }
                if (dataSource instanceof BinaryObject) {
                    return OdtDocument.openOdtDocument((Scriptable)this, (BinaryObject)dataSource);
                }
                if (dataSource instanceof DatasourceField) {
                    return OdtDocument.openOdtDocument((Scriptable)this, (DatasourceField)dataSource);
                }
            }
        }
        throw new InformException(String.format(MESSAGE_BADTYPE, dataSource.getClass().getName()));
    }

    private String getFileFormat(String filePath) {
        int lastDotIndex = filePath.lastIndexOf(".");
        if (lastDotIndex != -1 && lastDotIndex < filePath.length() - 1) {
            return filePath.substring(lastDotIndex + 1);
        }
        return "";
    }
}

