/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedWriter;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.DatasourceField;
import inform.agent.scripts.textutils.TextExtractor;
import inform.common.Base64BinString;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.mozilla.javascript.Scriptable;

public class TextLibrary
extends SmartScriptableObject {
    private static final String MESSAGE_UNKNOWNDATATYPE = "\u041f\u0435\u0440\u0435\u0434\u0430\u0432\u0430\u0435\u043c\u044b\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0431\u0438\u043d\u0430\u0440\u043d\u044b\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u043c \u0438\u043b\u0438 \u043f\u043e\u043b\u0435\u043c \u0442\u0430\u0431\u043b\u0438\u0446\u044b \u0441 \u0442\u0438\u043f\u043e\u043c Blob \u0438\u043b\u0438 BlobFile";

    public TextLibrary(Scriptable scope) {
        this.setParentScope(scope);
        for (TextExtractor.DOCUMENT_FORMAT type : TextExtractor.DOCUMENT_FORMAT.values()) {
            TextLibrary.putConstProperty(this, type.name(), type.getTypeId());
        }
    }

    @Override
    public String getClassName() {
        return "Text";
    }

    @SmartScriptableObject.FunctionTag
    public String binaryToBase64(Object arg) {
        if (arg instanceof BinaryObject) {
            BinaryObject binObj = (BinaryObject)arg;
            return Base64BinString.Encode(binObj.getInternalBuffer(), binObj.getSize());
        }
        return "";
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject base64ToBinary(Object arg) {
        if (arg instanceof String) {
            return new BinaryObject(Base64BinString.Decode((String)arg));
        }
        return null;
    }

    @SmartScriptableObject.FunctionTag
    public String binaryToString(BinaryObject arg, Object codepage) {
        Charset cp = this.toCharset(codepage);
        return new String(arg.getInternalBuffer(), 0, arg.getSize(), cp);
    }

    private Charset toCharset(Object codepage) {
        String cp;
        if (!(codepage instanceof String)) {
            return TaggedWriter.ANSI;
        }
        switch (cp = codepage.toString()) {
            case "utf16": 
            case "utf-16": 
            case "UTF16": 
            case "UTF-16": {
                return TaggedWriter.UTF16LE;
            }
        }
        return Charset.forName(cp);
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject stringToBinary(Object val, Object codepage) {
        String str = val.toString();
        Charset cp = this.toCharset(codepage);
        return new BinaryObject(str.getBytes(cp));
    }

    @SmartScriptableObject.FunctionTag
    public String transform(String template, Object model) throws Throwable {
        throw new InformException("\u041c\u0435\u0442\u043e\u0434 Text.transform \u0443\u0441\u0442\u0430\u0440\u0435\u043b \u0438 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u044d\u0442\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438 \u0430\u0433\u0435\u043d\u0442\u0430");
    }

    private TextExtractor createTextExtractor(Object arg) throws Exception {
        if (arg == null) {
            return null;
        }
        if (arg instanceof BinaryObject) {
            return new TextExtractor(((BinaryObject)arg).getInternalBuffer());
        }
        if (arg instanceof DatasourceField) {
            DatasourceField field = (DatasourceField)arg;
            switch (field.getDataType()) {
                case BLOB: 
                case FILE: {
                    BinaryObject binary = field.getAsBinary();
                    return binary == null ? null : new TextExtractor(binary.getInternalBuffer());
                }
            }
        }
        throw new IOException(MESSAGE_UNKNOWNDATATYPE);
    }

    @SmartScriptableObject.FunctionTag
    public int determineFormat(Object arg) throws Exception {
        TextExtractor textExtractor = this.createTextExtractor(arg);
        if (textExtractor == null) {
            return 0;
        }
        TextExtractor.DOCUMENT_FORMAT format = textExtractor.getFormat();
        return format == null ? 0 : format.getTypeId();
    }

    @SmartScriptableObject.FunctionTag
    public String extractText(Object arg) throws Exception {
        TextExtractor textExtractor = this.createTextExtractor(arg);
        return textExtractor == null ? null : textExtractor.extractText();
    }

    @SmartScriptableObject.FunctionTag
    public String formUrlEncodedStringOf(Object arg) throws Exception {
        String urlEncodedString = "";
        URLCodec codec = new URLCodec();
        if (arg instanceof DatasourceField) {
            DatasourceField field = (DatasourceField)arg;
            switch (field.getDataType()) {
                case BLOB: 
                case FILE: {
                    arg = field.getAsBinary();
                }
            }
        }
        if (arg instanceof BinaryObject) {
            BinaryObject bo = (BinaryObject)arg;
            byte[] origBytes = Arrays.copyOfRange(bo.getInternalBuffer(), 0, bo.getSize());
            byte[] resBytes = codec.encode(origBytes);
            urlEncodedString = new String(resBytes, StandardCharsets.US_ASCII);
        } else if (arg instanceof String) {
            try {
                urlEncodedString = codec.encode((String)arg);
            }
            catch (EncoderException e) {
                throw new InformException(e.getMessage(), e);
            }
        }
        return urlEncodedString;
    }
}

