/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.Core;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.WebImage;
import inform.agent.scripts.metadata.MetadataLibrary;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class WebCanvas
extends ScriptableObject {
    private static final String[] availJSPropertiesNames = new String[]{"width", "height"};
    private static final String[] availJSFunctionsNames = new String[]{"getImage", "getTextWidth", "getTextHeight", "drawRect", "fillRect", "strokeRect", "setFillColor", "setFillGradient", "setStrokeColor", "loadGraphics", "setFont", "drawEllipse", "fillEllipse", "strokeEllipse", "strokePolyline", "drawImage", "drawText", "drawPolygon", "fillPolygon", "strokePolygon", "drawArc", "fillArc", "strokeArc", "setPixel"};
    BufferedImage img;
    Graphics2D g2d;
    Color currentColor;
    Paint currentPaint;
    Font currentFont;
    BasicStroke currentStroke;

    public WebCanvas(Scriptable scope, int width, int height) {
        this.setParentScope(scope);
        for (String s : availJSPropertiesNames) {
            this.defineProperty(s, WebCanvas.class, 0);
        }
        this.defineFunctionProperties(availJSFunctionsNames, this.getClass(), 0);
        this.currentPaint = new Color(0, 0, 0, 255);
        this.currentColor = new Color(0, 0, 0, 255);
        this.currentFont = new Font("Arial Black", 0, 12);
        this.currentStroke = new BasicStroke();
        this.img = new BufferedImage(width, height, 2);
        this.g2d = this.img.createGraphics();
    }

    @Override
    public String getClassName() {
        return "WebCanvas";
    }

    public void loadGraphics(double nodeid) {
        try {
            BinaryObject data = MetadataLibrary._getNodeContent(nodeid);
            File f = File.createTempFile("img", null);
            String filename = f.getName();
            try (FileOutputStream fileOutputStream = new FileOutputStream(filename);
                 BufferedOutputStream output = new BufferedOutputStream(fileOutputStream);){
                ((OutputStream)output).write(data.getInternalBuffer(), 0, data.getSize());
            }
            File ff = new File(filename);
            this.img = ImageIO.read(ff);
            if (!f.delete()) {
                Core.logger.debug("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b " + f.getName() + " \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c");
            }
            if (!ff.delete()) {
                Core.logger.debug("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b " + ff.getName() + " \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c");
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        this.g2d = this.img.createGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryObject getImage(String format) throws Exception {
        byte[] data = null;
        try {
            String filename = this.getImageFile(format);
            File f = new File(filename);
            data = new byte[(int)f.length()];
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(filename));){
                int ln = ((InputStream)input).read(data, 0, (int)f.length());
                if ((long)ln != f.length()) {
                    throw new Exception("getImage \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0435\u0442 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u043d\u044b\u0445(" + ln + ") \u0431\u0430\u0439\u0442 \u0441 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c(" + f.length() + ") \u0444\u0430\u0439\u043b\u0430");
                }
            }
            if (!f.delete()) {
                Core.logger.debug("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b " + f.getName() + " \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c");
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return new BinaryObject(data);
    }

    public String getImageFile(String format) {
        String filename = "";
        try {
            File f = File.createTempFile("png", null);
            filename = f.getName();
            if (!f.delete()) {
                Core.logger.debug("\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435: \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b " + f.getName() + " \u043d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0443\u0434\u0430\u043b\u0438\u0442\u044c");
            }
            if ("jpg".equalsIgnoreCase(format) || "jpeg".equalsIgnoreCase(format)) {
                BufferedImage _img = new BufferedImage(this.img.getWidth(), this.img.getHeight(), 1);
                ColorConvertOp op = new ColorConvertOp(null);
                op.filter(this.img, _img);
                ImageIO.write((RenderedImage)_img, format, new File(filename));
            } else {
                ImageIO.write((RenderedImage)this.img, format, new File(filename));
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return filename;
    }

    public void setFillColor(int ABGR) {
        this.currentPaint = new Color(ABGR & 0xFF, ABGR >>> 8 & 0xFF, ABGR >>> 16 & 0xFF, ABGR >>> 24);
        this.g2d.setPaint(this.currentPaint);
    }

    public int getWidth() {
        return this.img.getWidth();
    }

    public int getHeight() {
        return this.img.getHeight();
    }

    public void setFillGradient(int x0, int y0, int ABGR0, int x1, int y1, int ABGR1, boolean cycled) {
        this.currentPaint = new GradientPaint(x0, y0, new Color(ABGR0 & 0xFF, ABGR0 >>> 8 & 0xFF, ABGR0 >>> 16 & 0xFF, ABGR0 >>> 24), x1, y1, new Color(ABGR1 & 0xFF, ABGR1 >>> 8 & 0xFF, ABGR1 >>> 16 & 0xFF, ABGR1 >>> 24), cycled);
        this.g2d.setPaint(this.currentPaint);
    }

    public static void setStrokeColor(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        WebCanvas Obj = (WebCanvas)thisObj;
        int n = args.length;
        if (n != 1 && n != 3) {
            throw new Exception("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c (color, width, [m0, m1, ...])");
        }
        double _ABGR = ValueCaster.toDouble(args[0]);
        long ABGR = (long)_ABGR;
        int A = (int)(ABGR >>> 24);
        int B = (int)(ABGR >>> 16 & 0xFFL);
        int G = (int)(ABGR >>> 8 & 0xFFL);
        int R = (int)(ABGR & 0xFFL);
        Obj.currentColor = new Color(A << 24 | R << 16 | G << 8 | B, true);
        Obj.g2d.setColor(Obj.currentColor);
        if (n > 1) {
            int width = ValueCaster.toInt(args[1]);
            NativeArray mm = (NativeArray)args[2];
            int mn = (int)mm.getLength();
            float[] m = new float[mn];
            for (int i = 0; i < mn; ++i) {
                m[i] = ValueCaster.toInt(mm.get(i, (Scriptable)mm));
            }
            Obj.currentStroke = new BasicStroke(width, 2, 0, width, m, 0.0f);
            Obj.g2d.setStroke(Obj.currentStroke);
        }
    }

    public void setFont(String name, int size, int style) {
        int _style = 0;
        if ((style & 1) != 0) {
            _style |= 1;
        }
        if ((style & 2) != 0) {
            _style |= 2;
        }
        this.currentFont = new Font(name, _style, size);
        this.g2d.setFont(this.currentFont);
    }

    public void drawText(int x, int y, String S, int angle) {
        this.g2d.setFont(this.currentFont);
        this.g2d.setColor(this.currentColor);
        if (angle == 0) {
            this.g2d.drawString(S, x, y);
        } else {
            double PI = Math.PI;
            FontRenderContext _frc = this.g2d.getFontRenderContext();
            TextLayout _layout = new TextLayout(S, this.currentFont, _frc);
            Rectangle2D _bounds = _layout.getBounds();
            int lx = (int)_bounds.getWidth();
            int ly = (int)_bounds.getHeight();
            int _size = Math.max(10, 3 * Math.max(lx, ly));
            BufferedImage _img = new BufferedImage(_size, _size, 2);
            Graphics2D _g2d = _img.createGraphics();
            _g2d.setFont(this.currentFont);
            _g2d.setColor(this.currentColor);
            int baseX = (_size - lx) / 2;
            int baseY = (_size - ly) / 2;
            _g2d.drawString(S, baseX, baseY);
            _g2d.translate(x - baseX, y - baseY);
            _g2d.rotate(Math.PI * (double)(360 - angle) / 180.0, baseX, baseY);
            this.g2d.drawImage(_img, _g2d.getTransform(), null);
        }
    }

    public Rectangle2D getTextBounds(String S) {
        this.g2d.setFont(this.currentFont);
        FontRenderContext _frc = this.g2d.getFontRenderContext();
        TextLayout _layout = new TextLayout(S, this.currentFont, _frc);
        return _layout.getBounds();
    }

    public int getTextWidth(String S) {
        return (int)this.getTextBounds(S).getWidth();
    }

    public int getTextHeight(String S) {
        return (int)this.getTextBounds(S).getHeight();
    }

    public void strokeRect(int x0, int y0, int w, int h) {
        this.g2d.setStroke(this.currentStroke);
        this.g2d.setColor(this.currentColor);
        this.g2d.drawRect(x0, y0, w, h);
    }

    public void fillRect(int x0, int y0, int w, int h) {
        this.g2d.setPaint(this.currentPaint);
        this.g2d.fillRect(x0, y0, w, h);
    }

    public void drawRect(int x0, int y0, int w, int h) {
        this.fillRect(x0, y0, w, h);
        this.strokeRect(x0, y0, w, h);
    }

    public void strokeEllipse(int xc, int yc, int rx, int ry) {
        Ellipse2D.Double E = new Ellipse2D.Double(xc, yc, rx, ry);
        this.g2d.setStroke(this.currentStroke);
        this.g2d.setColor(this.currentColor);
        this.g2d.draw(E);
    }

    public void fillEllipse(int xc, int yc, int rx, int ry) {
        Ellipse2D.Double E = new Ellipse2D.Double(xc, yc, rx, ry);
        this.g2d.setPaint(this.currentPaint);
        this.g2d.fill(E);
    }

    public void drawEllipse(int xc, int yc, int rx, int ry) {
        this.fillEllipse(xc, yc, rx, ry);
        this.strokeEllipse(xc, yc, rx, ry);
    }

    public void strokeArc(int xc, int yc, int rx, int ry, double start, double extent) {
        int x0 = xc - rx;
        int y0 = yc - ry;
        Arc2D.Double A = new Arc2D.Double(x0, y0, 2 * rx, 2 * ry, start, extent, 0);
        this.g2d.setStroke(this.currentStroke);
        this.g2d.setColor(this.currentColor);
        this.g2d.draw(A);
    }

    public void fillArc(int xc, int yc, int rx, int ry, double start, double extent) {
        int x0 = xc - rx;
        int y0 = yc - ry;
        Arc2D.Double A = new Arc2D.Double(x0, y0, 2 * rx, 2 * ry, start, extent, 0);
        this.g2d.setPaint(this.currentPaint);
        this.g2d.fill(A);
    }

    public void drawArc(int xc, int yc, int rx, int ry, double start, double extent) {
        this.fillArc(xc, yc, rx, ry, start, extent);
        this.strokeArc(xc, yc, rx, ry, start, extent);
    }

    public void setPixel(int x, int y) {
        this.g2d.setStroke(new BasicStroke());
        this.g2d.setColor(this.currentColor);
        this.g2d.drawLine(x, y, x, y);
    }

    public void drawImage(WebImage WI, int x, int y, double rot, double sx, double sy) {
        WI.translate(x, y);
        WI.rotate(360.0 - rot, WI.getWidth() / 2, WI.getHeight() / 2);
        WI.scale(sx, sy);
        this.g2d.drawImage(WI.img, WI.g2d.getTransform(), null);
    }

    public static void strokePolygon(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        WebCanvas Obj = (WebCanvas)thisObj;
        int np = args.length;
        if (np == 0 || np > 1 && np % 2 != 0) {
            throw new Exception("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c (x, y, x, y, ...)");
        }
        Polygon poly = new Polygon();
        if (np > 1) {
            for (int i = 0; i < np / 2; ++i) {
                int x = ValueCaster.toInt(args[2 * i]);
                int y = ValueCaster.toInt(args[2 * i + 1]);
                poly.addPoint(x, y);
            }
        } else {
            NativeArray xy = (NativeArray)args[0];
            int l = (int)xy.getLength();
            if (l % 2 != 0) {
                throw new Exception("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442 x \u0438 y \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c");
            }
            for (int i = 0; i < l / 2; ++i) {
                int xx = ValueCaster.toInt(xy.get(2 * i, (Scriptable)xy));
                int yy = ValueCaster.toInt(xy.get(2 * i + 1, (Scriptable)xy));
                poly.addPoint(xx, yy);
            }
        }
        Obj.g2d.setStroke(Obj.currentStroke);
        Obj.g2d.setColor(Obj.currentColor);
        Obj.g2d.draw(poly);
    }

    public static void fillPolygon(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        WebCanvas Obj = (WebCanvas)thisObj;
        int np = args.length;
        if (np == 0 || np > 1 && np % 2 != 0) {
            throw new Exception("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c (x, y, x, y, ...)");
        }
        Polygon poly = new Polygon();
        if (np > 1) {
            for (int i = 0; i < np / 2; ++i) {
                int x = ValueCaster.toInt(args[2 * i]);
                int y = ValueCaster.toInt(args[2 * i + 1]);
                poly.addPoint(x, y);
            }
        } else {
            NativeArray xy = (NativeArray)args[0];
            int l = (int)xy.getLength();
            if (l % 2 != 0) {
                throw new Exception("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442 x \u0438 y \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c");
            }
            for (int i = 0; i < l / 2; ++i) {
                int xx = ValueCaster.toInt(xy.get(2 * i, (Scriptable)xy));
                int yy = ValueCaster.toInt(xy.get(2 * i + 1, (Scriptable)xy));
                poly.addPoint(xx, yy);
            }
        }
        Obj.g2d.setPaint(Obj.currentPaint);
        Obj.g2d.fill(poly);
    }

    public static void drawPolygon(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        WebCanvas Obj = (WebCanvas)thisObj;
        int np = args.length;
        if (np == 0 || np > 1 && np % 2 != 0) {
            throw new Exception("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c (x, y, x, y, ...)");
        }
        Polygon poly = new Polygon();
        if (np > 1) {
            for (int i = 0; i < np / 2; ++i) {
                int x = ValueCaster.toInt(args[2 * i]);
                int y = ValueCaster.toInt(args[2 * i + 1]);
                poly.addPoint(x, y);
            }
        } else {
            NativeArray xy = (NativeArray)args[0];
            int l = (int)xy.getLength();
            if (l % 2 != 0) {
                throw new Exception("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442 x \u0438 y \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c");
            }
            for (int i = 0; i < l / 2; ++i) {
                int xx = ValueCaster.toInt(xy.get(2 * i, (Scriptable)xy));
                int yy = ValueCaster.toInt(xy.get(2 * i + 1, (Scriptable)xy));
                poly.addPoint(xx, yy);
            }
        }
        Obj.g2d.setPaint(Obj.currentPaint);
        Obj.g2d.fill(poly);
        Obj.g2d.setStroke(Obj.currentStroke);
        Obj.g2d.setColor(Obj.currentColor);
        Obj.g2d.draw(poly);
    }

    public static void strokePolyline(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws Exception {
        int i;
        int[] yy;
        int[] xx;
        WebCanvas Obj = (WebCanvas)thisObj;
        int np = args.length;
        if (np == 0 || np > 1 && np % 2 != 0) {
            throw new Exception("\u0410\u0440\u0433\u0443\u043c\u0435\u043d\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c (x, y, x, y, ...)");
        }
        if (np > 1) {
            xx = new int[np / 2];
            yy = new int[np / 2];
            for (i = 0; i < np / 2; ++i) {
                xx[i] = ValueCaster.toInt(args[2 * i]);
                yy[i] = ValueCaster.toInt(args[2 * i + 1]);
            }
        } else {
            NativeArray xy = (NativeArray)args[0];
            int l = (int)xy.getLength();
            if (l % 2 != 0) {
                throw new Exception("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442 x \u0438 y \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u0442\u044c");
            }
            xx = new int[l / 2];
            yy = new int[l / 2];
            for (int i2 = 0; i2 < l / 2; ++i2) {
                xx[i2] = ValueCaster.toInt(xy.get(2 * i2, (Scriptable)xy));
                yy[i2] = ValueCaster.toInt(xy.get(2 * i2 + 1, (Scriptable)xy));
            }
        }
        Obj.g2d.setStroke(Obj.currentStroke);
        Obj.g2d.setColor(Obj.currentColor);
        for (i = 0; i < xx.length - 1; ++i) {
            Obj.g2d.drawLine(xx[i], yy[i], xx[i + 1], yy[i + 1]);
        }
    }
}

