/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.metadata.MetadataLibrary;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class WebImage
extends ScriptableObject {
    private static final String[] availJSPropertiesNames = new String[]{"width", "height"};
    BufferedImage img;
    Graphics2D g2d;

    public WebImage(Scriptable scope, double nodeid) {
        this.setParentScope(scope);
        for (String s : availJSPropertiesNames) {
            this.defineProperty(s, WebImage.class, 0);
        }
        this.loadGraphics(nodeid);
    }

    @Override
    public String getClassName() {
        return "WebImage";
    }

    public void loadGraphics(double nodeid) {
        try {
            BinaryObject data = MetadataLibrary._getNodeContent(nodeid);
            File f = File.createTempFile("img", null);
            String filename = f.getName();
            try (FileOutputStream fileOutputStream = new FileOutputStream(filename);
                 BufferedOutputStream output = new BufferedOutputStream(fileOutputStream);){
                ((OutputStream)output).write(data.getInternalBuffer(), 0, data.getSize());
            }
            File ff = new File(filename);
            this.img = ImageIO.read(ff);
            f.delete();
            ff.delete();
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        this.g2d = this.img.createGraphics();
    }

    public int getWidth() {
        return this.img.getWidth();
    }

    public int getHeight() {
        return this.img.getHeight();
    }

    public void rotate(double rot, int x, int y) {
        double PI = Math.PI;
        this.g2d.rotate(Math.PI * rot / 180.0, x, y);
    }

    public void scale(double sx, double sy) {
        this.g2d.scale(sx, sy);
    }

    public void translate(int sx, int sy) {
        this.g2d.translate(sx, sy);
    }
}

