/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoCertificate;
import inform.agent.scripts.crypto.CryptoPrivateKey;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.common.SmartScriptableObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.mozilla.javascript.Scriptable;
import ru.CryptoPro.JCP.params.CryptParamsSpec;

public class CryptoCipher
extends SmartScriptableObject {
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final String algorithmName;
    private SecretKey secretKey = null;
    private SecretKey symKey = null;
    private Cipher cipher = null;

    public CryptoCipher(Scriptable scope, CryptoPrivateKey privateKey, CryptoCertificate certificate, String algorithmName) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (privateKey == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u043e\u0433\u043e \u043a\u043b\u044e\u0447\u0430");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0441\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u0430");
        }
        this.setParentScope(scope);
        this.privateKey = privateKey.privateKey();
        this.publicKey = certificate.certificate().getPublicKey();
        this.algorithmName = algorithmName;
    }

    @Override
    public String getClassName() {
        return "Cipher";
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject encryptKey(String exchKeyAlgName, String cipherAlgName, BinaryObject iv) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException {
        KeyAgreement ka = KeyAgreement.getInstance(exchKeyAlgName);
        IvParameterSpec spec = null;
        if (iv != null) {
            spec = new IvParameterSpec(iv.getInternalBuffer());
        }
        ka.init((Key)this.privateKey, spec);
        ka.doPhase(this.publicKey, true);
        this.secretKey = ka.generateSecret(this.algorithmName);
        KeyGenerator kg = KeyGenerator.getInstance(this.algorithmName);
        if (exchKeyAlgName.equals("GOST3410_2012_256") || exchKeyAlgName.equals("GOST3410DH_2012_256") || exchKeyAlgName.equals("GOST3410EPH_2012_256") || exchKeyAlgName.equals("GOST3410DHEPH_2012_256") || exchKeyAlgName.equals("GOST3410_2012_512") || exchKeyAlgName.equals("GOST3410DH_2012_512") || exchKeyAlgName.equals("GOST3410EPH_2012_512") || exchKeyAlgName.equals("GOST3410DHEPH_2012_512")) {
            kg.init((AlgorithmParameterSpec)CryptParamsSpec.getInstance((int)14));
        }
        this.symKey = kg.generateKey();
        this.cipher = Cipher.getInstance(cipherAlgName);
        this.cipher.init(3, this.secretKey);
        byte[] wrap = this.cipher.wrap(this.symKey);
        return new BinaryObject(wrap);
    }

    @SmartScriptableObject.FunctionTag
    public void decryptKey(BinaryObject wrappeSessiondKey, String exchKeyAlgName, String cipherAlgName, BinaryObject iv) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException {
        KeyAgreement ka = KeyAgreement.getInstance(exchKeyAlgName);
        IvParameterSpec spec = null;
        if (iv != null) {
            spec = new IvParameterSpec(iv.getInternalBuffer());
        }
        ka.init((Key)this.privateKey, spec);
        ka.doPhase(this.publicKey, true);
        this.secretKey = ka.generateSecret(this.algorithmName);
        this.cipher = Cipher.getInstance(cipherAlgName);
        this.cipher.init(4, this.secretKey);
        this.symKey = (SecretKey)this.cipher.unwrap(wrappeSessiondKey.getInternalBuffer(), null, 3);
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject initEncrypter(String cipherAlgName, BinaryObject iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipher = Cipher.getInstance(cipherAlgName);
        IvParameterSpec spec = null;
        if (iv != null) {
            spec = new IvParameterSpec(iv.getInternalBuffer());
        }
        this.cipher.init(1, (Key)this.symKey, spec);
        return new BinaryObject(this.cipher.getIV());
    }

    @SmartScriptableObject.FunctionTag
    public void initDecrypter(String cipherAlgName, BinaryObject iv) throws InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        this.cipher = Cipher.getInstance(cipherAlgName);
        IvParameterSpec spec = null;
        if (iv != null) {
            spec = new IvParameterSpec(iv.getInternalBuffer());
        }
        this.cipher.init(2, (Key)this.symKey, spec);
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject encrypt(Object data, Object codepage) throws Exception {
        byte[] value = CryptoUtils.dataAsBytes(data, codepage);
        if (value == null) {
            return null;
        }
        return new BinaryObject(this.cipher.doFinal(value, 0, value.length));
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject decrypt(BinaryObject data) throws IOException, IllegalBlockSizeException, BadPaddingException {
        if (data == null) {
            return null;
        }
        byte[] value = data.getInternalBuffer();
        if (value == null) {
            return null;
        }
        return new BinaryObject(this.cipher.doFinal(value, 0, value.length));
    }

    @SmartScriptableObject.FunctionTag
    public String decryptString(BinaryObject data, Object codepage) throws IOException, IllegalBlockSizeException, BadPaddingException {
        if (data == null) {
            return null;
        }
        byte[] value = data.getInternalBuffer();
        if (value == null) {
            return null;
        }
        return new String(this.cipher.doFinal(value, 0, value.length), Charset.forName(codepage instanceof String && !((String)codepage).isEmpty() ? (String)codepage : "UTF-8"));
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject generateIV(int length) throws NoSuchAlgorithmException {
        byte[] iv = new byte[length];
        SecureRandom random = SecureRandom.getInstance("CPRandom");
        random.nextBytes(iv);
        return new BinaryObject(iv);
    }

    @SmartScriptableObject.FunctionTag
    public CryptoMac createMac(String algorithmName) throws NoSuchAlgorithmException, InvalidKeyException {
        return new CryptoMac(algorithmName);
    }

    private class CryptoMac
    extends SmartScriptableObject {
        final Mac mac;
        private byte[] value;

        CryptoMac(String algorithmName) throws NoSuchAlgorithmException, InvalidKeyException {
            if (CryptoCipher.this.secretKey == null) {
                throw new IllegalArgumentException("\u041d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d \u043a\u043b\u044e\u0447 \u0441\u0435\u0441\u0441\u0438\u0438");
            }
            this.mac = Mac.getInstance(algorithmName);
            this.mac.init(CryptoCipher.this.secretKey);
        }

        @Override
        public String getClassName() {
            return "Mac";
        }

        @SmartScriptableObject.FunctionTag
        public void update(Object data, Object codepage) throws Exception {
            byte[] v = CryptoUtils.dataAsBytes(data, codepage);
            if (v == null) {
                return;
            }
            this.mac.update(v);
        }

        @SmartScriptableObject.FunctionTag
        public void reset() {
            this.mac.reset();
        }

        @SmartScriptableObject.PropertyTag
        public BinaryObject getValue() {
            return new BinaryObject(this.value);
        }

        @SmartScriptableObject.FunctionTag
        public void finish() {
            this.value = this.mac.doFinal();
        }
    }
}

