/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.common.SmartScriptableObject;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.mozilla.javascript.Scriptable;
import ru.CryptoPro.JCP.Digest.GostDigest;
import ru.CryptoPro.JCP.Digest.GostDigest2012_256;
import ru.CryptoPro.JCP.Digest.GostDigest2012_512;
import ru.CryptoPro.JCP.params.OID;

public class CryptoDigest
extends SmartScriptableObject {
    private final MessageDigest digest;
    private byte[] value = null;

    public CryptoDigest(Scriptable scope, String algorithmName, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.setParentScope(scope);
        this.digest = MessageDigest.getInstance(algorithmName, providerName);
    }

    @Override
    public String getClassName() {
        return "Digest";
    }

    @SmartScriptableObject.FunctionTag
    public void update(Object data, Object codepage) throws Exception {
        byte[] v = CryptoUtils.dataAsBytes(data, codepage);
        if (v == null) {
            return;
        }
        this.digest.update(v);
    }

    @SmartScriptableObject.FunctionTag
    public void finish() {
        this.value = this.digest.digest();
    }

    @SmartScriptableObject.PropertyTag
    public BinaryObject getValue() {
        return new BinaryObject(this.value);
    }

    @SmartScriptableObject.FunctionTag
    public void reset() {
        this.digest.reset();
    }

    @SmartScriptableObject.FunctionTag
    public void setParameter(String value) {
        String algorithm = this.digest.getAlgorithm();
        if (algorithm.equalsIgnoreCase("GOST3411")) {
            GostDigest gostDigest = (GostDigest)this.digest;
            if (value == null || value.isEmpty()) {
                gostDigest.reset();
            } else {
                gostDigest.reset(new OID(value));
            }
        } else if (algorithm.equalsIgnoreCase("GOST3411_2012_256")) {
            GostDigest2012_256 gostDigest = (GostDigest2012_256)this.digest;
            if (value == null || value.isEmpty()) {
                gostDigest.reset();
            } else {
                gostDigest.reset(new OID(value));
            }
        } else if (algorithm.equalsIgnoreCase("GOST3411_2012_512")) {
            GostDigest2012_512 gostDigest = (GostDigest2012_512)this.digest;
            if (value == null || value.isEmpty()) {
                gostDigest.reset();
            } else {
                gostDigest.reset(new OID(value));
            }
        }
    }
}

