/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.crypto.CryptoCertificate;
import inform.agent.scripts.crypto.CryptoPrivateKey;
import inform.agent.scripts.crypto.CryptoUtils;
import inform.common.SmartScriptableObject;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import org.mozilla.javascript.Scriptable;

public class CryptoSignature
extends SmartScriptableObject {
    private final Signature signature;

    public CryptoSignature(Scriptable scope, String algorithmName, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.setParentScope(scope);
        this.signature = Signature.getInstance(algorithmName, providerName);
    }

    @Override
    public String getClassName() {
        return "Signature";
    }

    @SmartScriptableObject.FunctionTag
    public void initSign(CryptoPrivateKey key) throws InvalidKeyException {
        this.signature.initSign(key.privateKey());
    }

    @SmartScriptableObject.FunctionTag
    public void initVerify(CryptoCertificate cert) throws InvalidKeyException {
        this.signature.initVerify(cert.certificate());
    }

    @SmartScriptableObject.FunctionTag
    public void update(Object data, Object codepage) throws Exception {
        byte[] value = CryptoUtils.dataAsBytes(data, codepage);
        if (value == null) {
            return;
        }
        this.signature.update(value);
    }

    @SmartScriptableObject.FunctionTag
    public BinaryObject sign() throws SignatureException {
        return new BinaryObject(this.signature.sign());
    }

    @SmartScriptableObject.FunctionTag
    public boolean verify(BinaryObject data) throws SignatureException {
        return this.signature.verify(data.getInternalBuffer());
    }
}

