/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.crypto;

import inform.agent.db.FieldDescriptor;
import inform.agent.scripts.BinaryObject;
import inform.agent.scripts.BlobField;
import inform.agent.scripts.DatasourceField;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mozilla.javascript.Undefined;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CryptoUtils {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String bytesToHex(byte[] bytes, char dlm) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        char[] hexChars = new char[bytes.length * 3];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 3] = hexArray[v >>> 4];
            hexChars[j * 3 + 1] = hexArray[v & 0xF];
            hexChars[j * 3 + 2] = dlm;
        }
        hexChars[hexChars.length - 1] = 32;
        return new String(hexChars);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] dataAsBytes(Object data, Object codepage) throws Exception {
        if (data == null) return null;
        if (data instanceof Undefined) {
            return null;
        }
        Charset charset = codepage instanceof Charset ? (Charset)codepage : Charset.forName(codepage instanceof String && !((String)codepage).isEmpty() ? (String)codepage : "UTF-8");
        byte[] value = null;
        if (data instanceof BinaryObject) {
            BinaryObject binary = (BinaryObject)data;
            return Arrays.copyOf(binary.getInternalBuffer(), binary.getSize());
        }
        if (!(data instanceof DatasourceField)) return data.toString().getBytes(charset);
        DatasourceField field = (DatasourceField)data;
        if (field.isEmpty()) return value;
        switch (field.getDataType()) {
            case BLOB: 
            case FILE: {
                if (field.getDescriptor().getBlobRawType() != FieldDescriptor.BlobRawType.BINARY) return field.getAsString().getBytes(charset);
                if (field.getDescriptor().getPostgreSQLReviewType() == FieldDescriptor.PostgreSQLReviewType.TSVECTOR) return field.getAsString().getBytes(charset);
                BinaryObject binary = ((BlobField)field).getAsBinary();
                if (binary == null) return value;
                return Arrays.copyOf(binary.getInternalBuffer(), binary.getSize());
            }
            default: {
                return field.getAsString().getBytes(charset);
            }
        }
    }

    public static Document loadDocument(byte[] data) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(true);
        dbf.setNamespaceAware(true);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(data));
    }

    public static byte[] documentAsBytes(Document doc) throws TransformerConfigurationException, TransformerException, IOException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(doc), new StreamResult(os));
        os.flush();
        return os.toByteArray();
    }
}

