/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.expr;

import inform.agent.expr.ConditionBlockTerm;
import inform.agent.expr.Expression;
import inform.agent.expr.FieldTerm;
import inform.agent.expr.OperationTerm;
import inform.agent.expr.Term;
import inform.agent.expr.ValueTerm;
import inform.agent.scripts.Constants;
import inform.agent.scripts.ParametersList;
import inform.agent.scripts.ServerSideExecutable;
import inform.agent.scripts.ServerSideTable;
import inform.agent.scripts.expr.SSTableBrace;
import inform.agent.scripts.expr.SSTableCompare;
import inform.agent.scripts.expr.SSTableEvaluator;
import inform.agent.scripts.expr.SSTableField;
import inform.agent.scripts.expr.SSTableIgnored;
import inform.agent.scripts.expr.SSTableNOPEvaluator;
import inform.agent.scripts.expr.SSTableOperation;
import inform.agent.scripts.expr.SSTableValue;
import org.mozilla.javascript.Scriptable;

public class SSTableExpression
extends Expression<SSTableEvaluator> {
    private final ServerSideExecutable ssTable;
    private final SSTableIgnored ignoredEvaluator = new SSTableIgnored();

    public SSTableExpression(ServerSideTable ssTable, Scriptable scope) {
        super(scope);
        this.ssTable = ssTable;
    }

    @Override
    public Constants getConstants() {
        return this.ssTable.getConstants();
    }

    @Override
    public ParametersList getParameters() {
        return this.ssTable.getParameters();
    }

    @Override
    public SSTableEvaluator createIgnored() {
        return this.ignoredEvaluator;
    }

    @Override
    public SSTableEvaluator createNOP(SSTableEvaluator left, SSTableEvaluator right) {
        return new SSTableNOPEvaluator(nopOperation, left, right);
    }

    @Override
    public SSTableEvaluator createEvaluator(Term term) {
        switch (term.getToken()) {
            case field: {
                return new SSTableField((FieldTerm)term);
            }
            case value: {
                return new SSTableValue((ValueTerm)term);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public SSTableEvaluator createEvaluator(Term term, SSTableEvaluator arg) {
        switch (term.getToken()) {
            case openBrace: {
                return new SSTableBrace(term, arg);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public SSTableEvaluator createEvaluator(Term term, SSTableEvaluator left, SSTableEvaluator right) {
        switch (term.getToken()) {
            case or: 
            case and: {
                return new SSTableOperation((OperationTerm)term, left, right);
            }
            case equal: 
            case notEqual: 
            case less: 
            case lessEqual: 
            case greater: 
            case greaterEqual: 
            case like: 
            case notLike: 
            case startWith: 
            case notStartWith: {
                return new SSTableCompare((OperationTerm)term, left, right);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected SSTableEvaluator compileCompare(Expression.Parser it) {
        if (it.current instanceof ConditionBlockTerm) {
            ConditionBlockTerm block = (ConditionBlockTerm)it.current;
            it.next();
            return (SSTableEvaluator)block.createEvaluator();
        }
        return (SSTableEvaluator)super.compileCompare(it);
    }
}

