/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.expr;

import inform.agent.db.types.DataType;
import inform.agent.expr.FieldTerm;
import inform.agent.scripts.DatasetField;
import inform.agent.scripts.DirectoryField;
import inform.agent.scripts.ServerSideTable;
import inform.agent.scripts.ServerSideTableRecord;
import inform.agent.scripts.expr.SSTableArgument;

public class SSTableField
extends SSTableArgument {
    private final FieldTerm fieldTerm;
    private DatasetField field = null;

    public SSTableField(FieldTerm term) {
        super(term);
        this.fieldTerm = term;
    }

    @Override
    public boolean execute() {
        if (this.isIgnored()) {
            return true;
        }
        throw new IllegalStateException();
    }

    @Override
    boolean isNull() throws Exception {
        if (this.field == null) {
            return true;
        }
        if (this.field.getIsNull()) {
            return true;
        }
        if (SSTableField.isStringable(this.field.getDataType())) {
            return this.field.getAsString().trim().length() == 0;
        }
        return false;
    }

    @Override
    int valueCount() {
        return 1;
    }

    @Override
    Object getValue() throws Exception {
        if (this.field == null) {
            return 0;
        }
        return this.field.getValue();
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.field != null && SSTableField.isStringable(this.field.getDataType());
    }

    @Override
    public boolean isIgnored() {
        return this.field == null;
    }

    @Override
    public void afterLoad(ServerSideTable ssTable) {
        super.afterLoad(ssTable);
        this.field = null;
        int[] path = this.fieldTerm.getFieldIdPath();
        if (path == null || path.length == 0) {
            return;
        }
        ServerSideTableRecord table = ssTable.getTable();
        this.field = table.getFields().get(path[0]);
        for (int i = 1; i < path.length && this.field != null; ++i) {
            int fieldId = path[i];
            if (!(this.field instanceof DirectoryField)) {
                this.field = null;
                break;
            }
            this.field = ((DirectoryField)this.field).getDirectoryField(fieldId);
        }
    }

    @Override
    public DataType getDataType() {
        if (this.field == null) {
            return DataType.STRING;
        }
        return this.field.getDataType();
    }
}

