/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.expr;

import inform.agent.expr.OperationTerm;
import inform.agent.scripts.ServerSideTable;
import inform.agent.scripts.expr.SSTableEvaluator;

public class SSTableOperation
extends SSTableEvaluator {
    protected final SSTableEvaluator left;
    protected final SSTableEvaluator right;

    public SSTableOperation(OperationTerm term, SSTableEvaluator left, SSTableEvaluator right) {
        super(term);
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean isIgnored() {
        return this.term.isIgnored() || this.left.isIgnored() && this.right.isIgnored();
    }

    @Override
    public boolean isStringType() throws Exception {
        return this.left.isStringType() || this.right.isStringType();
    }

    @Override
    public boolean execute() throws Exception {
        if (this.isIgnored()) {
            return true;
        }
        if (this.left.isIgnored()) {
            return this.right.execute();
        }
        if (this.right.isIgnored()) {
            return this.left.execute();
        }
        switch (this.term.getToken()) {
            case and: {
                return this.left.execute() && this.right.execute();
            }
            case or: {
                return this.left.execute() || this.right.execute();
            }
        }
        return false;
    }

    @Override
    public void afterLoad(ServerSideTable ssTable) {
        if (this.left != null) {
            this.left.afterLoad(ssTable);
        }
        if (this.right != null) {
            this.right.afterLoad(ssTable);
        }
    }
}

