/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatAligment;
import inform.common.SmartScriptableObject;
import java.io.IOException;

public class BoolFormat
extends Format {
    private String true_presentation = "\u0414\u0430";
    private String false_presentation = "\u041d\u0435\u0442";
    private static final int TAG_DF_TRUE = 99;
    private static final int TAG_DF_FALSE = 98;

    protected BoolFormat(int id) {
        super(id);
    }

    protected BoolFormat(int id, byte[] options) throws IOException, TaggedReaderException {
        this(id);
        if (options != null) {
            this.decodeOptions(new TaggedReader(options));
        }
    }

    @SmartScriptableObject.PropertyTag
    public String getTruePresentation() {
        return this.true_presentation;
    }

    public void setTruePresentation(String value) {
        this.true_presentation = value;
    }

    @SmartScriptableObject.PropertyTag
    public String getFalsePresentation() {
        return this.false_presentation;
    }

    public void setFalsePresentation(String value) {
        this.false_presentation = value;
    }

    protected void decodeOptions(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 98: {
                    this.false_presentation = reader.getAnsi(98);
                    break;
                }
                case 99: {
                    this.true_presentation = reader.getAnsi(99);
                }
            }
        }
    }

    @Override
    public final String format(Object value) throws InformException {
        if (null == value) {
            return "";
        }
        return this.formatValue(ValueCaster.toBoolean(value));
    }

    @Override
    public DataType getDataType() {
        return DataType.BOOLEAN;
    }

    @Override
    public FormatAligment getAlignment() {
        return FormatAligment.RIGHT;
    }

    protected String formatValue(boolean value) throws InformException {
        if (value) {
            return this.true_presentation;
        }
        return this.false_presentation;
    }
}

