/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.InformException;
import inform.adt.NumberConverter;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatAligment;
import inform.common.SmartScriptableObject;
import java.io.IOException;

public class FloatFormat
extends Format {
    public static final int TAG_DF_SHOW_INTGS = 53;
    public static final int TAG_DF_SHOW_CENTS = 50;
    public static final int TAG_DF_SCALE_CONST_ID = 95;
    public static final int TAG_DF_SCALE = 100;
    public static final int TAG_DF_KEEP_TAIL_ZERO = 97;
    public static final int TAG_DF_WITH_SEPARATOR = 96;
    protected boolean hideInts = false;
    protected boolean hideFrcs = false;
    protected boolean keep_tail_zero = false;
    protected boolean with_separator = false;
    protected int scale = -1;
    protected int scaleConstant = 0;

    protected FloatFormat(int id) {
        super(id);
    }

    protected FloatFormat(int id, byte[] options) throws IOException, TaggedReaderException {
        this(id);
        if (options != null) {
            this.decodeOptions(new TaggedReader(options));
        }
    }

    @SmartScriptableObject.PropertyTag
    public boolean getHideInts() {
        return this.hideInts;
    }

    public void setHideInts(boolean value) {
        this.hideInts = value;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getHideFrcs() {
        return this.hideFrcs;
    }

    public void setHideFrcs(boolean value) {
        this.hideFrcs = value;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getKeepTailZero() {
        return this.keep_tail_zero;
    }

    public void setKeepTailZero(boolean value) {
        this.keep_tail_zero = value;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getWithSeparator() {
        return this.with_separator;
    }

    public void setWithSeparator(boolean value) {
        this.with_separator = value;
    }

    @SmartScriptableObject.PropertyTag
    public int getScale() {
        return this.scale;
    }

    public void setScale(int value) {
        this.scale = value;
    }

    @SmartScriptableObject.PropertyTag
    public int getScaleConstant() {
        return this.scaleConstant;
    }

    public void setScaleConstant(int value) {
        this.scaleConstant = value;
    }

    protected void decodeOptions(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 53: {
                    this.hideInts = true;
                    break;
                }
                case 50: {
                    this.hideFrcs = true;
                    break;
                }
                case 95: {
                    this.scaleConstant = reader.getInt(95);
                    break;
                }
                case 100: {
                    this.scale = reader.getInt(100);
                    break;
                }
                case 97: {
                    this.keep_tail_zero = true;
                    break;
                }
                case 96: {
                    this.with_separator = true;
                }
            }
        }
        if (this.scaleConstant != 0) {
            // empty if block
        }
    }

    @Override
    public final String format(Object value) throws InformException {
        if (null == value) {
            return "";
        }
        return this.formatValue(ValueCaster.toDouble(value));
    }

    protected String formatValue(double value) throws InformException {
        int fl;
        long i = (long)value;
        int n = fl = 0 > this.scale ? 18 : this.scale;
        if (0.5 <= value - (double)i && this.scale == 0) {
            value = ++i;
        } else if (0 < fl && fl < 16) {
            value = NumberConverter.simpleRoundTo(value, -fl);
            i = (long)value;
        }
        String is = Long.toString(i);
        int il = is.length() + 1;
        if (this.with_separator) {
            is = this.setThousandSeparators(is, " ");
        }
        if (this.hideFrcs || 0 == this.scale) {
            return is;
        }
        String fs = String.format("%." + fl + "f", value).substring(il);
        if (!this.keep_tail_zero) {
            while (fs.endsWith("0")) {
                fs = fs.substring(0, fs.length() - 1);
            }
        }
        if (this.hideInts) {
            return fs;
        }
        if (-1 == this.scale && (0 == fs.length() || fs.equals("0"))) {
            return is;
        }
        return is + (String)(fs.isEmpty() ? "" : "." + fs);
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    @Override
    public FormatAligment getAlignment() {
        return FormatAligment.RIGHT;
    }
}

