/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.DateTime;
import inform.adt.InformException;
import inform.adt.TimeZoneHost;
import inform.agent.db.types.DataType;
import inform.agent.scripts.format.BoolFormat;
import inform.agent.scripts.format.DateFormat;
import inform.agent.scripts.format.FloatFormat;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.IntegerFormat;
import inform.agent.scripts.format.IntervalFormat;
import inform.agent.scripts.format.MetatreeNodeFormat;
import inform.agent.scripts.format.MoneyFormat;
import inform.agent.scripts.format.SpecDateFormat;
import inform.agent.scripts.format.SpellDateFormat;
import inform.agent.scripts.format.SpellMoneyFormat;
import inform.agent.scripts.format.SpellNumberFormat;
import java.io.IOException;

public class FormatManager {
    public static final Format stdFormat = new Format(0);
    public static final Format stdIntFormat = new IntegerFormat(0);
    public static final Format stdBoolFormat = new BoolFormat(0);
    public static final Format stdMetatreeNodeFormat = new MetatreeNodeFormat(0);
    public static final int DATETIME_DD_MM_YYYY = 401;
    public static final int DATETIME_MM_YYYY = 402;
    public static final int DATETIME_YYYY = 403;
    public static final int DATETIME_HH_MM = 404;
    public static final int DATETIME_HH_MM_SS = 405;
    public static final int DATETIME_DD_MM_YYYY_HH_MM = 406;
    public static final int DATETIME_HH = 407;
    public static final int DATETIME_DD = 408;
    public static final int DATETIME_DD_MM = 409;
    public static final int DATETIME_DD_MM_YYYY_HH_MM_SS = 410;
    public static final int DATETIME_Q_YYYY = 411;
    public static final int DATETIME_YYYY_MM_DD = 412;
    public static final int DATETIME_DD_MONTH_YYYY = 451;
    public static final int DATETIME_MONTH_YYYY = 452;
    public static final int DATETIME_DD_MONTH = 453;
    public static final int DATETIME_MONTH = 454;
    public static final int DATETIME_10D_MONTH = 455;
    public static final int DATETIME_HY_YYYY = 456;
    public static final int DATETIME_10D = 457;
    public static final int DATETIME_Q = 458;
    public static final int DATETIME_HY = 459;
    public static final int INTERVAL_HHH_MM_SS = 501;
    public static final int INTERVAL_MMM_SS = 502;
    public static final int INTERVAL_SSS = 503;
    public static final int INTERVAL_HHH_MM = 504;
    public static final int INTERVAL_MMM = 505;
    public static final int INTERVAL_HHH = 506;
    public static final int INTERVAL_YYYY_DDD_HH_CC = 507;
    public static final int INTERVAL_DDD_HH_MM_CC = 508;
    public static final int INTERVAL_DDD_HH_MM = 509;
    public static final int INTERVAL_DDD_HH = 510;
    public static final int FLOAT_STD = 601;
    public static final int FLOAT_MONEY = 602;
    public static final int FLOAT_MONEY_SPELL = 650;
    public static final int FLOAT_SPELL = 651;
    public static final int BOOL_CUSTOM = 701;
    public static final int METATREENODE_TRUNK = 1001;
    public static final int METATREENODE_FULL = 1002;

    public static Format createFormat(int id, DataType type, byte[] options) throws InformException {
        return FormatManager.createFormat(id, type, options, false);
    }

    public static Format createFormat(int id, DataType type, byte[] options, boolean ignoreType) throws InformException {
        try {
            switch (id) {
                case 401: 
                case 402: 
                case 403: 
                case 404: 
                case 405: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 410: 
                case 411: 
                case 412: {
                    if (!ignoreType && type != DataType.DATE_TIME) break;
                    return new DateFormat(id);
                }
                case 451: 
                case 452: 
                case 453: 
                case 454: {
                    if (!ignoreType && type != DataType.DATE_TIME) break;
                    return new SpellDateFormat(id, options);
                }
                case 455: 
                case 456: 
                case 457: 
                case 458: 
                case 459: {
                    if (!ignoreType && type != DataType.DATE_TIME) break;
                    return new SpecDateFormat(id);
                }
                case 501: 
                case 502: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 507: 
                case 508: 
                case 509: 
                case 510: {
                    if (!ignoreType && type != DataType.INTERVAL) break;
                    return new IntervalFormat(id, options);
                }
                case 601: {
                    if (!ignoreType && type != DataType.FLOAT && type != DataType.INTEGER) break;
                    return new FloatFormat(id, options);
                }
                case 602: {
                    if (!ignoreType && type != DataType.FLOAT && type != DataType.INTEGER) break;
                    return new MoneyFormat(id, options);
                }
                case 650: {
                    if (!ignoreType && type != DataType.FLOAT && type != DataType.INTEGER) break;
                    return new SpellMoneyFormat(id, options);
                }
                case 651: {
                    if (!ignoreType && type != DataType.FLOAT && type != DataType.INTEGER) break;
                    return new SpellNumberFormat(id, options);
                }
                case 701: {
                    if (!ignoreType && type != DataType.BOOLEAN) break;
                    return new BoolFormat(id, options);
                }
                case 1001: 
                case 1002: {
                    if (!ignoreType && type != DataType.METATREE_NODE) break;
                    return new MetatreeNodeFormat(id);
                }
            }
        }
        catch (IOException e) {
            throw InformException.wrap(e);
        }
        return FormatManager.getStdFormat(type);
    }

    public static Format getStdFormat(DataType type) {
        switch (type) {
            case INTEGER: {
                return stdIntFormat;
            }
            case METATREE_NODE: {
                return stdMetatreeNodeFormat;
            }
            case BOOLEAN: {
                return stdBoolFormat;
            }
        }
        return stdFormat;
    }

    public static boolean hasTime(int format) {
        switch (format) {
            case 406: 
            case 410: {
                return true;
            }
        }
        return false;
    }

    public static double toServerTime(double value, int format, TimeZoneHost timeZoneHost) {
        if (DateTime.isServerTimeZoneHost(timeZoneHost) && !FormatManager.hasTime(format)) {
            return value;
        }
        return DateTime.toServerTime(value, timeZoneHost);
    }

    public static double fromServerTime(double value, int format, TimeZoneHost timeZoneHost) {
        if (DateTime.isServerTimeZoneHost(timeZoneHost) && !FormatManager.hasTime(format)) {
            return value;
        }
        return DateTime.fromServerTime(value, timeZoneHost);
    }

    public static enum FormatType {
        DATETIME_DD_MM_YYYY(401),
        DATETIME_MM_YYYY(402),
        DATETIME_YYYY(403),
        DATETIME_HH_MM(404),
        DATETIME_HH_MM_SS(405),
        DATETIME_DD_MM_YYYY_HH_MM(406),
        DATETIME_HH(407),
        DATETIME_DD(408),
        DATETIME_DD_MM(409),
        DATETIME_DD_MM_YYYY_HH_MM_SS(410),
        DATETIME_Q_YYYY(411),
        DATETIME_YYYY_MM_DD(412),
        DATETIME_DD_MONTH_YYYY(451),
        DATETIME_MONTH_YYYY(452),
        DATETIME_DD_MONTH(453),
        DATETIME_MONTH(454),
        DATETIME_10D_MONTH(455),
        DATETIME_HY_YYYY(456),
        DATETIME_10D(457),
        DATETIME_Q(458),
        DATETIME_HY(459),
        INTERVAL_HHH_MM_SS(501),
        INTERVAL_MMM_SS(502),
        INTERVAL_SSS(503),
        INTERVAL_HHH_MM(504),
        INTERVAL_MMM(505),
        INTERVAL_HHH(506),
        INTERVAL_YYYY_DDD_HH_CC(507),
        INTERVAL_DDD_HH_MM_CC(508),
        INTERVAL_DDD_HH_MM(509),
        INTERVAL_DDD_HH(510),
        FLOAT_STD(601),
        FLOAT_MONEY(602),
        FLOAT_MONEY_SPELL(650),
        FLOAT_SPELL(651),
        BOOL_CUSTOM(701),
        METATREENODE_TRUNK(1001),
        METATREENODE_FULL(1002);

        private int formatId;

        private FormatType(int formatId) {
            this.formatId = formatId;
        }

        public int getFormatId() {
            return this.formatId;
        }
    }
}

