/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.taggedio.TaggedReader;
import inform.agent.scripts.format.DateFormat;
import inform.agent.scripts.format.DateTimeStrCase;
import java.io.IOException;
import java.util.Calendar;

public class SpellDateFormat
extends DateFormat {
    public static final int TAG_DF_GENITIV = 52;
    public static final int TAG_DF_PREPOSITIONAL = 65;
    private DateTimeStrCase stringCase = DateTimeStrCase.NOMINATIVE;

    protected SpellDateFormat(int id) {
        super(id);
    }

    protected SpellDateFormat(int id, byte[] options) throws IOException {
        this(id);
        if (options != null) {
            this.decodeOptions(new TaggedReader(options));
        }
    }

    protected void decodeOptions(TaggedReader reader) throws IOException {
        this.stringCase = DateTimeStrCase.NOMINATIVE;
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 52: {
                    this.stringCase = DateTimeStrCase.GENETIVE;
                    break;
                }
                case 65: {
                    this.stringCase = DateTimeStrCase.PREPOSITIONAL;
                }
            }
        }
    }

    @Override
    protected String toStringWithFormat(Calendar cal) {
        int Year = cal.get(1);
        int Month = cal.get(2);
        int Day = cal.get(5);
        switch (this.id) {
            case 451: {
                return String.format("%02d %s %04d", Day, this.getStringFromMonth(Month, DateTimeStrCase.NOMINATIVE), Year);
            }
            case 452: {
                return String.format("%s %04d", this.getStringFromMonth(Month, this.stringCase), Year);
            }
            case 453: {
                return String.format("%02d %s", Day, this.getStringFromMonth(Month, DateTimeStrCase.NOMINATIVE));
            }
            case 454: {
                return String.format("%s", this.getStringFromMonth(Month, this.stringCase));
            }
        }
        return "";
    }
}

