/*
 * Decompiled with CFR 0.152.
 */
package inform.agent.scripts.format;

import inform.adt.InformException;
import inform.adt.taggedio.TaggedReader;
import inform.adt.taggedio.TaggedReaderException;
import inform.agent.db.types.DataType;
import inform.agent.db.types.ValueCaster;
import inform.agent.scripts.format.CurrencyFormat;
import inform.agent.scripts.format.Format;
import inform.agent.scripts.format.FormatAligment;
import inform.common.SmartScriptableObject;
import java.io.IOException;

public class SpellNumberFormat
extends Format {
    public static final int TAG_DF_SCALE_NUMBER = 56;
    public static final int TAG_DF_SHOW_WHOLE = 58;
    public static final int TAG_DF_NUMBER_TYPE = 57;
    int prec = 2;
    int kind = 0;
    boolean showWhole = false;

    @SmartScriptableObject.PropertyTag
    public int getPrec() {
        return this.prec;
    }

    public void setPrec(int value) {
        this.prec = value;
    }

    @SmartScriptableObject.PropertyTag
    public int getKind() {
        return this.kind;
    }

    public void setKind(int value) {
        this.kind = value;
    }

    @SmartScriptableObject.PropertyTag
    public boolean getShowWhole() {
        return this.showWhole;
    }

    public void setShowWhole(boolean value) {
        this.showWhole = value;
    }

    protected void decodeOptions(TaggedReader reader) throws IOException, TaggedReaderException {
        while (reader.getNextTag() != 0) {
            switch (reader.getCurrentTag()) {
                case 56: {
                    this.prec = reader.getInt();
                    break;
                }
                case 58: {
                    this.showWhole = true;
                    break;
                }
                case 57: {
                    this.kind = reader.getInt();
                }
            }
        }
    }

    protected SpellNumberFormat(int id, byte[] options) throws IOException, TaggedReaderException {
        super(id);
        if (options != null) {
            this.decodeOptions(new TaggedReader(options));
        }
    }

    @Override
    public final String format(Object value) throws InformException {
        Double num = ValueCaster.toDouble(value);
        return CurrencyFormat.NumberToSpelledString(num, this.prec, this.kind, this.showWhole);
    }

    @Override
    public DataType getDataType() {
        return DataType.FLOAT;
    }

    @Override
    public FormatAligment getAlignment() {
        return FormatAligment.RIGHT;
    }
}

